#!/usr/bin/perl
#
# Tired of transferring multiple packs from XDCC bots?
#
# Just use /xdcc -q 1 2 3 to get three packs from the server
#
# by Stefan "tommie" Tomanek <stefan@kann-nix.org>
#
#
# Commands:
# 
# /xdcc -q Nickname packnumbers
#	Downloads the specified packs from the server
# /xdcc -l
# 	Lists the download queue
# /xdcc -c
# 	Clears the queue
#
# History:
#
# 26.02.2002
# *first release, report bugs :)
#
# 01.03.2002
# *CHanged to GPL
#
# 08.03.200
# *some bugfixes

use strict;
use warnings;

use vars qw($VERSION %IRSSI);
$VERSION = "20020309";
%IRSSI = (
        authors     => "Stefan Tomanek",
	contact     => "stefan\@pico.ruhr.de",
	name        => "xdcctools",
	description => "advances downloading from XDCC bots",
	license     => "GPLv2",
	url         => "",
	changed     => "$VERSION",
);

use Irssi;


use vars qw(@queue);

sub contains {
	my ($item, @list) = @_;
	foreach (@list) {
		($item eq $_) && return 1;
	}
	return 0;
}

sub event_privmsg_dcc_close {
	my ($server, $msg, $nick, $address, $target) = @_;
	unless (scalar(@queue) > 0) {return 0};
	if ($nick eq @{$queue[0]}[0] && @{$queue[0]}[2] == 2) {
		if ($msg =~ /\*\*\* Closing Connection:/) {
			# We should try again
			@{$queue[0]}[2] = 0;
			process_queue();
		} elsif ($msg =~ /\*\*\* Transfer Completed/) {
			# Mark the transfer as completed
			@{$queue[0]}[2] = 3;
			process_queue();
		} elsif ($msg =~ /\*\*\* You already requested that pack/) {
			###FIXME
			@{$queue[0]}[2] = 0;
			process_queue();
		}
	}
}

sub event_dcc_connected {
	my ($dcc) = @_;
	unless ( $dcc->{type} eq 'get' ) { return 1; };
	my $nick = $dcc->{nick};
	if (scalar(@queue) > 0) {
		if ( @{$queue[0]}[0] eq $nick ) {
			@{$queue[0]}[2] = 2;
		}
	}
	process_queue()
}

sub event_dcc_closed {
	my ($dcc) = @_;
	unless ( $dcc->{type} == 'get' ) { return 1; };
	my $nick = $dcc->{nick};
	if (scalar(@queue) > 0) {
		if ( @{$queue[0]}[0] eq $nick ) {
			@{$queue[0]}[2] = 3;
		}
	}
	process_queue()
}

sub process_queue {
	unless (scalar(@queue) > 0) {return 0};
	shift @queue if ( @{$queue[0]}[2] == 3 );
	unless (scalar(@queue) > 0) {return 0};
	if ( @{$queue[0]}[2] == 0 ) {
		my $server = Irssi::server_find_chatnet(@{$queue[0]}[3]);
		$server->command('MSG '.@{$queue[0]}[0].' xdcc send '.@{$queue[0]}[1]);
		@{$queue[0]}[2] = 1;
	}
}

sub cmd_xdcc_queue {
	my ($args, $server, $witem) = @_;
	my ($nick, $packs) = split(/ /, $args, 2);
	my @packs = split(/ /, $packs);
	foreach (@packs) {
		# 0: Waiting, 1: Processing, 2: Doenloading
		my $status = 0;
		my @item = ($nick, $_, $status, $server->{chatnet});
		push @queue, \@item;
	}
	process_queue()
}

sub list_xdcc_queue {
	Irssi::print "%R>>%n Wanted XDCC packs:";
	foreach (@queue) {
		Irssi::print "%B->%n ".@{$_}[0]."(".@{$_}[3]."): Pack ".@{$_}[1]." Status ".@{$_}[2];
	}
	Irssi::print "%R<<%n";
}

sub cmd_xdcc {
	my ($args, $server, $witem) = @_;
	my @arg = split(/ /, $args);
	
	if (scalar(@arg) == 0) {
		list_xdcc_queue();
	} elsif ($arg[0] eq '-q') {
		# queue files
		shift @arg;
		cmd_xdcc_queue("@arg", $server, $witem);
	} elsif ($arg[0] eq '-l') {
		# list queue
		list_xdcc_queue();
	} elsif ($arg[0] eq '-c') {
		# clear queue
		foreach (0..(scalar(@queue)-1)) {
			pop @queue;
		}
		Irssi::print "%R>>%n XDCC queue cleared";
	}
}

Irssi::command_bind('xdcc', 'cmd_xdcc');
Irssi::command_bind('queue', 'cmd_queue');
Irssi::signal_add('dcc connected', 'event_dcc_connected');
Irssi::signal_add('message irc notice', 'event_privmsg_dcc_close');

