/*
 setup-festival.c : speech plugin for irssi - configuration for festival

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <irssi-plugin.h>
#include "speech.h"

static gchar *festival_address;
static gint festival_port;
static gchar *festival_init;

SETUP_REC plugin_speech_options[] =
{
    { SETUP_TYPE_ENTRY, &festival_address, "festival_address", "localhost" },
    { SETUP_TYPE_SPIN, &festival_port, "festival_port", GINT_TO_POINTER(1314) },
    { SETUP_TYPE_ENTRY, &festival_init, "festival_init", "" },

    { 0, NULL, NULL }
};

void plugin_speech_get_setup(PLUGIN_REC *plugin)
{
    PLUGIN_DATA *data = plugin->data;

    data->server = g_strdup(festival_address);
    data->port = festival_port;
    data->init = g_strdup(festival_init);
}

void plugin_speech_setup_init(PLUGIN_REC *plugin)
{
    setup_read("plugin_speech", plugin_speech_options);
    plugin_speech_get_setup(plugin);
}

void plugin_speech_setup_deinit(PLUGIN_REC *plugin)
{
    setup_free(plugin_speech_options);
}
