/*
 speech.c : speech plugin for irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <irssi-plugin.h>
#include "speech.h"

static void plugin_init_callback(gint h, PLUGIN_DATA *data)
{
    data->handle = h;
    if (h == -1)
    {
        /* can't connect */
        printtext(NULL, NULL, MSGLEVEL_CLIENTERROR, "Speech plugin: Festival server not running on %s:%d", data->server, data->port);
        plugin_destroy(data->plugin);
    }
    else
    {
        /* connect ok */
        printtext(NULL, NULL, MSGLEVEL_CLIENTNOTICE, "Speech plugin loaded");
        if (*data->init != '\0')
        {
            /* send initialization command */
            write(h, data->init, strlen(data->init));
            write(h, "\n", 1);
        }
        plugin_speech_events_init(data->plugin);
    }
}

gchar *plugin_description(void)
{
    return "text -> speech plugin";
}

gint plugin_version(void)
{
    return PLUGIN_LAYER_VERSION;
}

static void deinit(PLUGIN_REC *plugin)
{
    PLUGIN_DATA *data = plugin->data;

    if (data->loaded)
        printtext(NULL, NULL, MSGLEVEL_CLIENTNOTICE, "Speech plugin unloaded");
    plugin_speech_setup_deinit(plugin);

    if (data->handle != -1)
        net_disconnect(data->handle);

    g_free(data->init);
    g_free(data->server);
    g_free(data);
    plugin->data = NULL;
}

void plugin_deinit(PLUGIN_REC *plugin)
{
    deinit(plugin);
}

gboolean plugin_init(gint gui, PLUGIN_REC *plugin, gchar *args)
{
    PLUGIN_DATA *data;

    plugin->data = data = g_new0(PLUGIN_DATA, 1);
    data->plugin = plugin;
    data->handle = -1;
    data->gui = gui;;

    plugin_speech_setup_init(plugin);
    if (args != NULL && *args != '\0')
    {
        g_free(data->server);
        data->server = g_strdup(data->server);
    }

    printtext(NULL, NULL, MSGLEVEL_CLIENTNOTICE, "Speech plugin: Connecting to festival (%s:%d)..", data->server, data->port);
    if (!net_connect_nonblock(data->server, data->port, NULL, (NET_CALLBACK) plugin_init_callback, data))
    {
        printtext(NULL, NULL, MSGLEVEL_CLIENTERROR, "Speech plugin: Festival server not running on %s:%d", data->server, data->port);
        deinit(plugin);
        return FALSE;
    }

    data->loaded = TRUE;
    if (gui == IRSSI_GUI_GTK || gui == IRSSI_GUI_GNOME)
	plugin_speech_gtk_init(plugin);
    return TRUE;
}
