/*
 gui-channels.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"

/*static gboolean gui_channel_init(CHANNEL_REC *channel)
{
    GUI_CHANNEL_REC *rec;

    g_return_val_if_fail(channel != NULL, FALSE);

    rec = g_new0(GUI_CHANNEL_REC, 1);
    channel->gui_data = rec;

    signal_emit("gui channel created", 1, channel);
    return TRUE;
}

static gboolean signal_channel_destroyed(CHANNEL_REC *channel)
{
    g_return_val_if_fail(channel != NULL, FALSE);

    g_free(channel->gui_data);
    channel->gui_data = NULL;
    return TRUE;
}*/

static gboolean signal_channel_open(CHANNEL_REC *channel)
{
    WINDOW_REC *window;

    gui_window_redraw(CHANNEL_PARENT(channel));

    window = CHANNEL_PARENT(channel);
    WINDOW_GUI(window)->parent->active = window;
    cur_channel = window->active;
    signal_emit("channel changed", 1, channel);
    signal_emit("window focused", 1, window);

    if (CHANNEL_PARENT(channel)->active != channel)
    {
        CHANNEL_PARENT(channel)->active = channel;
        signal_emit("channel focused", 1, channel);
    }
    return TRUE;
}

static gboolean signal_channel_focused(CHANNEL_REC *channel)
{
    if (cur_channel == NULL || CHANNEL_PARENT(cur_channel) == CHANNEL_PARENT(channel))
    {
        cur_channel = channel;
        signal_emit("channel changed", 1, cur_channel);
    }

    if (cur_channel == channel ||
        WINDOW_GUI(CHANNEL_PARENT(cur_channel))->parent !=
        WINDOW_GUI(CHANNEL_PARENT(channel))->parent)
    {
        /* need to redraw the window too.. */
        signal_emit("window focused", 1, CHANNEL_PARENT(channel));
    }

    if (channel->type == CHANNEL_TYPE_CHANNEL)
    {
        /* redraw channel widgets */
        signal_emit("channel topic changed", 1, channel);
        signal_emit("channel mode changed", 1, channel);
    }

    return TRUE;
}

void gui_channels_init(void)
{
    signal_add("gui channel open", (SIGNAL_FUNC) signal_channel_open);
    /*signal_add("gui channel init", (SIGNAL_FUNC) gui_channel_init);
    signal_add("channel destroyed", (SIGNAL_FUNC) signal_channel_destroyed);*/
    signal_add("channel focused", (SIGNAL_FUNC) signal_channel_focused);
}

void gui_channels_deinit(void)
{
    signal_remove("gui channel open", (SIGNAL_FUNC) signal_channel_open);
    /*signal_remove("gui channel init", (SIGNAL_FUNC) gui_channel_init);
    signal_remove("channel destroyed", (SIGNAL_FUNC) signal_channel_destroyed);*/
    signal_remove("channel focused", (SIGNAL_FUNC) signal_channel_focused);
}
