#ifndef __IRC_H
#define __IRC_H

/*

Defines signals:

irc_send_cmd():
 "send irc command", data, server_rec, channel_rec

irc_parse_incoming():
 "server event", message, server_rec, sender_nick, sender_address
 "event <event name>", arguments, server_rec, sender_nick, sender_address

irc_parse_outgoing(): ("send command", GUI should call this)
 "command <command name>", arguments, server_rec, channel_rec

*/

#define IRC_MASK_NICK   0x01
#define IRC_MASK_USER   0x02
#define IRC_MASK_HOST   0x04
#define IRC_MASK_DOMAIN 0x08

#define ismodeflag(a) ((a) == '@' || (a) == '+' || (a) == '-' || (a) == '~')
#define ischannel(a) ((a) == '#' || (a) == '&' || (a) == '!' || (a) == '+')

void irc_send_cmd(SERVER_REC *serv, gchar *cmd);
gboolean irc_mask_match(gchar *mask, gchar *nick, gchar *user, gchar *host);
gboolean irc_mask_match_address(gchar *mask, gchar *nick, gchar *address);
gboolean irc_masks_match(gchar *masks, gchar *nick, gchar *address);

gchar *irc_get_mask(gchar *nick, gchar *host, gint flags);

void irc_init(void);
void irc_deinit(void);

#endif
