/*
 ui-printtext.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"
#include "txt.h"

#ifndef N_
#define N_(a) a
#endif

FORMAT_REC default_formats[] =
{
    /* ---- */
    { NULL, N_("Line beginning"), 0 },

    { "line_start", N_("%B-%W!%B-%n "), 0 },
    { "line_start_irssi", N_("%B-%W!%B- %WIrssi:%n "), 0 },
    { "timestamp", N_("[$[-2.0]4:$[-2.0]5] "), 6, { 1, 1, 1, 1, 1, 1 } },
    { "daychange", N_("Day changed to $[-2.0]2-$[-2.0]1 $3"), 3, { 1, 1, 1 } },

    /* ---- */
    { NULL, N_("Server"), 0 },

    { "looking_up", N_("Looking up %_$1%_"), 1, { 0 } },
    { "connecting", N_("Connecting to %_$1%_ %K[%n$2%K]%n port %_$3%_"), 3, { 0, 0, 1 } },
    { "connection_established", N_("Connection to %_$1%_ established"), 1, { 0 } },
    { "cant_connect", N_("Unable to connect server %_$1%_ port %_$2%_ %K[%n$3%K]"), 3, { 0, 1, 0 } },
    { "connection_lost", N_("Connection lost to %_$1%_"), 1, { 0 } },
    { "lag_disconnected", N_("No PONG reply from server %_$1%_ in $2 seconds, disconnecting"), 2, { 0, 1 } },
    { "disconnected", N_("Disconnected from %_$1%_ %K[%n$2%K]"), 2, { 0, 0 } },
    { "server_changed", N_("Changed to %_$3%_ server %_$2%_"), 3, { 0, 0, 0 } },
    { "unknown_server_tag", N_("Unknown server tag %_$1%_"), 1, { 0 } },
    { "server_list", N_("%_$1%_: $2:$3 ($4)"), 5, { 0, 0, 1, 0, 0 } },
    { "server_lookup_list", N_("%_$1%_: $2:$3 ($4) (connecting...)"), 5, { 0, 0, 1, 0, 0 } },
    { "server_reconnect_list", N_("%_$1%_: $2:$3 ($4) ($6 left before reconnecting)"), 6, { 0, 0, 1, 0, 0, 0 } },
    { "server_reconnect_removed", N_("Removed reconnection to server %_$1%_ port %_$2%_"), 3, { 0, 1, 0 } },
    { "server_reconnect_not_found", N_("Reconnection tag %_$1%_ not found"), 1, { 0 } },

    /* ---- */
    { NULL, N_("Channels"), 0 },

    { "join", N_("%c%_$1%_ %K[%c$2%K]%n has joined %_$3"), 3, { 0, 0, 0 } },
    { "part", N_("%c$1 %K[%n$2%K]%n has left %_$3%_ %K[%n$4%K]"), 4, { 0, 0, 0, 0 } },
    { "talking_in", N_("You are now talking to channel %_$1%_"), 1, { 0 } },
    { "joinerror_toomany", N_("Cannot join to channel %_$1%_ %K(%nYou have joined to too many channels%K)"), 1, { 0 } },
    { "joinerror_full", N_("Cannot join to channel %_$1%_ %K(%nChannel is full%K)"), 1, { 0 } },
    { "joinerror_invite", N_("Cannot join to channel %_$1%_ %K(%nYou must be invited%K)"), 1, { 0 } },
    { "joinerror_banned", N_("Cannot join to channel %_$1%_ %K(%nYou are banned%K)"), 1, { 0 } },
    { "joinerror_bad_key", N_("Cannot join to channel %_$1%_ %K(%nBad channel key%K)"), 1, { 0 } },
    { "joinerror_bad_mask", N_("Cannot join to channel %_$1%_ %K(%nBad channel mask%K)"), 1, { 0 } },
    { "joinerror_unavail", N_("Cannot join to channel %_$1%_ %K(%nChannel is temporarily unavailable%K)"), 1, { 0 } },
    { "kick", N_("%c$1%n was kicked from %_$2%_ by %_$3%_ %K[%n$4%K]"), 4, { 0, 0, 0, 0 } },
    { "quit", N_("%c$1 %K[%n$2%K]%n has quit IRC %K[%n$3%K]"), 3, { 0, 0, 0 } },
    { "invite", N_("%_$1%_ invites you to %_$2"), 2, { 0, 0 } },
    { "names", N_("%K[%g%_Users%_%K(%g$1%K)]%n $2"), 2, { 0, 0 } },
    { "endofnames", N_("%g%_$1%_%K:%n Total of %_$2%_ nicks %K[%n%_$3%_ ops, %_$4%_ voices, %_$5%_ normal%K]"), 5, { 0, 1, 1, 1, 1 } },
    { "channel_created", N_("Channel %_$1%_ created $2"), 2, { 0, 0 } },
    { "topic", N_("Topic for %c$1%K:%n $2"), 2, { 0, 0 } },
    { "no_topic", N_("No topic set for %c$1"), 1, { 0 } },
    { "new_topic", N_("%_$1%_ changed the topic of %c$2%n to%K:%n $3"), 3, { 0, 0, 0 } },
    { "topic_unset", N_("Topic unset by %_$1%_ on %c$2"), 2, { 0, 0 } },
    { "topic_info", N_("Topic set by %_$1%_ %K[%n$2%K]"), 2, { 0, 0 } },
    { "chanmode_change", N_("mode/%c$1 %K[%n$2%K]%n by %_$3"), 3, { 0, 0, 0 } },
    { "server_chanmode_change", N_("%RServerMode/%c$1 %K[%n$2%K]%n by %_$3"), 3, { 0, 0, 0 } },
    { "channel_mode", N_("mode/%c$1 %K[%n$2%K]"), 2, { 0, 0 } },
    { "bantype", N_("Ban type changed to %_$1"), 1, { 0 } },
    { "banlist", N_("%_$1%_: ban %c$2"), 2, { 0, 0 } },
    { "banlist_long", N_("%_$1%_: ban %c$2 %K[%nby %_$3%_, $4 secs ago%K]"), 4, { 0, 0, 0, 1 } },
    { "ebanlist", N_("%_$1%_: ban exception %c$2"), 2, { 0, 0 } },
    { "ebanlist_long", N_("%_$1%_: ban exception %c$2 %K[%nby %_$3%_, $4 secs ago%K]"), 4, { 0, 0, 0, 1 } },
    { "invitelist", N_("%_$1%_: invite %c$2"), 2, { 0, 0 } },
    { "no_such_channel", N_("$1: No such channel"), 1, { 0 } },
    { "channel_synced", N_("Join to %_$1%_ was synced in %_$2%_ secs"), 2, { 0, 2 } },

    /* ---- */
    { NULL, N_("Nick"), 0 },

    { "usermode_change", N_("Mode change %K[%n%_$1%_%K]%n for user %c$2"), 2, { 0, 0 } },
    { "user_mode", N_("Your user mode is %K[%n%_$1%_%K]"), 1, { 0 } },
    { "away", N_("You have been marked as being away"), 0 },
    { "unaway", N_("You are no longer marked as being away"), 0 },
    { "nick_away", N_("$1 is away: $2"), 2, { 0, 0 } },
    { "no_such_nick", N_("$1: No such nick/channel"), 1, { 0 } },
    { "your_nick_changed", N_("You're now known as %c$1"), 1, { 0 } },
    { "nick_changed", N_("%_$1%_ is now known as %c$2"), 2, { 0, 0 } },
    { "nick_in_use", N_("Nick %_$1%_ is already in use"), 1, { 0 } },
    { "nick_unavailable", N_("Nick %_$1%_ is temporarily unavailable"), 1, { 0 } },
    { "your_nick_owned", N_("Your nick is owned by %_$4%_ %K[%n$2@$3%K]"), 4, { 0, 0, 0, 0 } },

    /* ---- */
    { NULL, N_("Who queries"), 0 },

    { "whois", N_("%_$1%_ %K[%n$2@$3%K]%n%: ircname  : $4"), 4, { 0, 0, 0, 0 } },
    { "whois_idle", N_(" idle     : $2 hours $3 mins $4 secs"), 4, { 0, 1, 1, 1 } },
    { "whois_idle_signon", N_(" idle     : $2 hours $3 mins $4 secs %K[%nsignon: $5%K]"), 5, { 0, 1, 1, 1, 0 } },
    { "whois_server", N_(" server   : $2 %K[%n$3%K]"), 3, { 0, 0, 0 } },
    { "whois_oper", N_("          : %_IRC operator%_"), 1, { 0 } },
    { "whois_channels", N_(" channels : $2"), 2, { 0, 0 } },
    { "whois_away", N_(" away     : $2"), 2, { 0, 0 } },
    { "end_of_whois", N_("End of WHOIS"), 1, { 0 } },
    { "who", N_("$[-10]1 %_$[!9]2%_ $[!3]3 $[!2]4 $5@$6 %K(%W$7%K)"), 7, { 0, 0, 0, 0, 0, 0, 0 } },
    { "end_of_who", N_("End of /WHO list"), 1, { 0 } },

    /* ---- */
    { NULL, N_("Your messages"), 0 },

    { "own_msg", N_("%K<%n$3%W$1%K>%n %|$2"), 3, { 0, 0, 0 } },
    { "own_msg_channel", N_("%K<%n$4%W$1%K:%c$2%K>%n %|$3"), 4, { 0, 0, 0, 0 } },
    { "own_msg_private", N_("%K[%rmsg%K(%R$1%K)]%n $2"), 2, { 0, 0 } },
    { "own_msg_private_query", N_("%K<%W$3%K>%n %|$2"), 3, { 0, 0, 0 } },
    { "own_notice", N_("%K[%rnotice%K(%R$1%K)]%n $2"), 2, { 0, 0 } },
    { "own_me", N_("%W * $1%n $2"), 2, { 0, 0 } },
    { "own_ctcp", N_("%K[%rctcp%K(%R$1%K)]%n $2 $3"), 3, { 0, 0, 0 } },
    { "own_dcc", N_("%K[%rdcc%K(%R$1%K)]%n $2"), 2, { 0, 0 } },

    /* ---- */
    { NULL, N_("Received messages"), 0 },

    { "pubmsg_me", N_("%K<%n$3%Y$1%K>%n %|$2"), 3, { 0, 0, 0 } },
    { "pubmsg_me_channel", N_("%K<%n$4%Y$1%K:%c$2%K>%n %|$3"), 4, { 0, 0, 0, 0 } },
    { "pubmsg_hilight", N_("%K<%n$4$1$2%K>%n %|$3"), 4, { 0, 0, 0, 0 } },
    { "pubmsg_hilight_channel", N_("%K<%n$5$1$2%K:%c$3%K>%n %|$4"), 5, { 0, 0, 0, 0, 0 } },
    { "pubmsg", N_("%K<%n$3$1%K>%n %|$2"), 3, { 0, 0, 0 } },
    { "pubmsg_channel", N_("%K<%n$4$1%K:%c$2%K>%n %|$3"), 4, { 0, 0, 0, 0 } },
    { "msg_private", N_("%K[%R$1%K(%r$2%K)]%n $3"), 3, { 0, 0, 0 } },
    { "msg_private_query", N_("%K<%R$1%K>%n %|$3"), 3, { 0, 0, 0 } },
    { "dcc_msg", N_("%K[%G$1%K(%gdcc%K)]%n $2"), 2, { 0, 0 } },
    { "notice_server", N_("%g!$1%n $2"), 2, { 0, 0 } },
    { "notice_public", N_("%K-%M$1%K:%m$2%K-%n $3"), 3, { 0, 0, 0 } },
    { "notice_public_ops", N_("%K-%M$1%K:%m@$2%K-%n $3"), 3, { 0, 0, 0 } },
    { "notice_private", N_("%K-%M$1%K(%m$2%K)-%n $3"), 3, { 0, 0, 0 } },
    { "action_dcc", N_("%W (*dcc*) $1%n $2"), 2, { 0, 0 } },
    { "action_private", N_("%W (*) $1%n $3"), 3, { 0, 0, 0 } },
    { "action_private_query", N_("%W * $1%n $3"), 3, { 0, 0, 0 } },
    { "action_public", N_("%W * $1%n $2"), 2, { 0, 0 } },
    { "action_public_channel", N_("%W * $1%K:%c$2%n $3"), 3, { 0, 0, 0 } },

    /* ---- */
    { NULL, N_("CTCPs"), 0 },

    { "ctcp_reply", N_("CTCP %_$1%_ reply from %_$2%_%K:%n $3"), 3, { 0, 0, 0 } },
    { "ctcp_ping_reply", N_("CTCP %_PING%_ reply from %_$1%_: $2.$3 seconds"), 3, { 0, 2, 2 } },
    { "ctcp_requested", N_("%g>>> %_$1%_ %K[%g$2%K] %grequested %_$3%_ from %_$4"), 4, { 0, 0, 0, 0 } },
    { "dcc_ctcp", N_("%g>>> DCC CTCP received from %_$1%_%K: %g$2"), 2, { 0, 0 } },

    /* ---- */
    { NULL, N_("DCC"), 0 },

    { "dcc_chat", N_("%gDCC CHAT from %_$1%_ %K[%g$2 port $3%K]"), 3, { 0, 0, 1 } },
    { "dcc_chat_not_found", N_("%gNo DCC CHAT connection open to %_$1"), 1, { 0 } },
    { "dcc_chat_connected", N_("%gDCC %_CHAT%_ connection with %_$1%_ %K%K[%g$2 port $3%K]%g established"), 3, { 0, 0, 1 } },
    { "dcc_chat_disconnected", N_("%gDCC lost chat to %_$1"), 1, { 0 } },
    { "dcc_send", N_("%gDCC SEND from %_$1%_ %K[%g$2 port $3%K]: %g$4 %K[%g$5 bytes%K]"), 5, { 0, 0, 1, 0, 2 } },
    { "dcc_send_exists", N_("%gDCC already sending file %G$1%g for %_$2%_"), 2, { 0, 0 } },
    { "dcc_send_not_found", N_("%gDCC not sending file %G$2%g to %_$1"), 2, { 0, 0 } },
    { "dcc_send_file_not_found", N_("%gDCC file not found: %G$1%g"), 1, { 0 } },
    { "dcc_send_connected", N_("%gDCC sending file %G$1%g for %_$2%_ %K[%g$3 port $4%K]"), 4, { 0, 0, 0, 1 } },
    { "dcc_send_complete", N_("%gDCC sent file $1 %K[%g%_$2%_kb%K]%g for %_$3%_ in %_$4%_ secs %K[%g%_$5kb/s%_%K]"), 5, { 0, 2, 0, 2, 3 } },
    { "dcc_send_aborted", N_("%gDCC aborted sending file $1 for %_$2%_"), 2, { 0, 0 } },
    { "dcc_get_not_found", N_("%gDCC no file offered by %_$1"), 1, { 0 } },
    { "dcc_get_connected", N_("%gDCC receiving file %G$1%g from %_$2%_ %K[%g$3 port $4%K]"), 4, { 0, 0, 0, 1 } },
    { "dcc_get_complete", N_("%gDCC received file %G$1%g %K[%g$2kb%K]%g from %_$3%_ in %_$4%_ secs %K[%g$5kb/s%K]"), 5, { 0, 2, 0, 2, 3 } },
    { "dcc_get_aborted", N_("%gDCC aborted receiving file $1 from %_$2%_"), 2, { 0, 0 } },
    { "dcc_unknown_ctcp", N_("%gDCC unknown ctcp %G$1%g from %_$2%_ %K[%g$3%K]"), 3, { 0, 0, 0 } },
    { "dcc_unknown_reply", N_("%gDCC unknown reply %G$1%g from %_$2%_ %K[%g$3%K]"), 3, { 0, 0, 0 } },
    { "dcc_unknown_type", N_("%gDCC unknown type %_$1"), 1, { 0 } },
    { "dcc_connect_error", N_("%gDCC can't connect to %_$1%_ port %_$2"), 2, { 0, 1 } },
    { "dcc_cant_create", N_("%gDCC can't create file %G$1%g"), 1, { 0 } },
    { "dcc_rejected", N_("%gDCC %G$1%g was rejected by %_$2%_ %K[%G$3%K]"), 3, { 0, 0, 0 } },
    { "dcc_close", N_("%gDCC %G$1%g close for %_$2%_ %K[%G$3%K]"), 3, { 0, 0, 0 } },

    /* ---- */
    { NULL, N_("Other server events"), 0 },

    { "online", N_("Users online: %_$1"), 1, { 0 } },
    { "pong", N_("PONG received from $1: $2"), 2, { 0, 0 } },
    { "wallops", N_("%WWALLOP%n $1: $2"), 2, { 0, 0 } },
    { "action_wallops", N_("%WWALLOP * $1%n $2"), 2, { 0, 0 } },
    { "error", N_("%_ERROR%_ $1"), 1, { 0 } },
    { "unknown_mode", N_("Unknown mode character $1"), 1, { 0 } },
    { "not_chanop", N_("You're not channel operator in $1"), 1, { 0 } },

    /* ---- */
    { NULL, N_("Logging"), 0 },

    { "log_opened", N_("Log file %W$1%n opened"), 1, { 0 } },
    { "log_open_failed", N_("Couldn't open log file %W$1"), 1, { 0 } },
    { "log_not_open", N_("Log file %W$1%n not open"), 1, { 0 } },
    { "log_closed", N_("Closed log file %W$1"), 1, { 0 } },
    { "log_listentry", N_("%W$1%K:%n $2"), 2, { 0, 0 } },
    { "log_sublistentry", N_("     + %W$1%K:%n $2"), 2, { 0, 0 } },

    /* ---- */
    { NULL, N_("Misc"), 0 },

    { "levels_error", N_("You must specify one of the following levels: $1"), 1, { 0 } },
    { "ignored", N_("Ignoring %_$1%_ from %_$2%_"), 2, { 0, 0 } },
    { "unignored", N_("Unignored %_$1%_ from %_$2%_"), 2, { 0, 0 } },
    { "ignore_not_found", N_("%_$1%_ is not being ignored"), 1, { 0 } },
    { "autoignore", N_("Flood detected from %_$1%_, autoignoring for %_$2%_ minutes"), 2, { 0, 1 } },
    { "autounignore", N_("Unignoring %_$1"), 1, { 0 } },
    { "lastlog_start", N_("%_Lastlog:"), 0 },
    { "lastlog_end", N_("%_End of Lastlog"), 0 },
    { "ircjoin", N_("%_$1%_ %K[%n$2@$3%K] [%n%_$4%_%K]%n has joined to $5"), 5, { 0, 0, 0, 0, 0 } },
    { "ircpart", N_("%_$1%_ has left $2"), 2, { 0, 0 } },
    { "notify_online", N_("On $1: %_$2%_"), 2, { 0, 0 } },
    { "notify_offline", N_("offline: $1"), 1, { 0 } },
    { "no_query", N_("No query with %_$1%_"), 1, { 0 } },
    { "plugin_load_error", N_("Error loading plugin %_$1%_: $2"), 2, { 0, 0 } },
    { "plugin_invalid", N_("Plugin %_$1%_ is not irssi plugin"), 1, { 0 } },
    { "plugin_invalid_version", N_("Plugin %_$1%_ isn't compatible with this irssi version"), 1, { 0 } },
    { "plugin_already_loaded", N_("Plugin %_$1%_ is already loaded"), 1, { 0 } },
    { "plugin_not_loaded", N_("Plugin %_$1%_ not loaded"), 1, { 0 } },
    { "perl_error", N_("Perl error: $1"), 1, { 0 } },

    { NULL, NULL }
};

gboolean ui_formats_check(gint num, gchar *format)
{
    for (; *format != '\0'; format++)
    {
        if (*format != '$') continue;

	format++;
	if (*format == '[')
	{
	    /* skip everything until ']' .. */
            format++;
	    while (*format != ']' && *format != '\0') format++;
	    if (*format == ']') format++;
	}
        if (*format == '\0' || *format-'1' < 0 || *format-'1' >= default_formats[num].params)
        {
            /* end of line / out of range.. */
            return FALSE;
        }
    }

    return TRUE;
}

gint ui_formats_find(gchar *format)
{
    gint num;

    num = 0;
    for (num = 0; num < TEXTS; num++)
    {
        if (default_formats[num].tag != NULL && strcmp(default_formats[num].tag, format) == 0)
            return num;
    }

    return -1;
}
