#ifndef __UI_PRINTTEXT_H
#define __UI_PRINTTEXT_H

#define PRINTFLAG_BOLD          0x01
#define PRINTFLAG_REVERSE       0x02
#define PRINTFLAG_UNDERLINE     0x04
#define PRINTFLAG_BEEP          0x08
#define PRINTFLAG_BLINK         0x10
#define PRINTFLAG_MIRC_COLOR    0x20
#define PRINTFLAG_INDENT        0x40

void printtext(SERVER_REC *server, gchar *channel, gint level, gchar *str, ...);
void printformat(SERVER_REC *server, gchar *channel, gint level, gint formatnum, ...);
void ui_beep(void);

void ui_printtext_init(void);
void ui_printtext_deinit(void);

/* internal */
void output_format_text_args(GString *out, SERVER_REC *server, gchar *channel, gint level, FORMAT_REC *format, gchar *text, va_list args);

#endif
