'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) entryfield.n 1.21 94/12/17 16:04:44
'/" 
.so man.macros
.HS entryfield iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
entryfield \- Create and manipulate a entry field widget
.SH SYNOPSIS
\fBentryfield\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- LabeledWidget <- entryfield
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBborderWidth\fR	\fBcursor\fR	\fBexportSelection\fR
\fBforeground\fR	\fBhighlightColor\fR	\fBhighlightThickness\fR	\fBinsertBackground\fR
\fBinsertBorderWidth\fR	\fBinsertOffTime\fR	\fBinsertOnTime\fR	\fBinsertWidth\fR
\fBjustify\fR	\fBrelief\fR	\fBselectBackground\fR	\fBselectBorderWidth\fR
\fBselectForeground\fR	\fBtextVariable\fR	\fBwidth\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBshow\fR	\fBstate\fR
.fi
.LP
See the "entry" manual entry for details on the associated options.
.SH "INHERITED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBdisabledForeground\fR	\fBlabelBitmap\fR	\fBlabelFont\fR	\fBlabelImage\fR
\fBlabelMargin\fR	\fBlabelPos\fR	\fBlabelText\fR	\fBlabelVariable\fR
\fBstate\fR
.fi
.LP
See the "labeledwidget" class manual entry for details on the 
inherited options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBchildSitePos\fR
Class:	\fBPosition\fR
Command-Line Switch:	\fB-childsitepos\fR
.fi
.IP
Specifies the position of the child site in the entry field: \fBn\fR, 
\fBs\fR, \fBe\fR, or \fBw\fR.  The default is e.
.LP
.nf
Name:	\fBcommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-command\fR
.fi
.IP
Specifies a Tcl command to be executed upon detection of a Return key 
press event.
.LP
.nf
Name:	\fBfixed\fR
Class:	\fBFixed\fR
Command-Line Switch:	\fB-fixed\fR
.fi
.IP
Restrict entry to the specified number of chars.  A value of 0, which is the
default, denotes no limit.  The value is the maximum number of chars the 
user may type into the field, regardles of field width.  For example,
if the field width is set to 20 and the fixed value is 10, the user will 
only be able to type 10 characters into the field which is 20 characters long.
.LP
.nf
Name:	\fBfocusCommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-focuscommand\fR
.fi
.IP
Specifies a Tcl command to be executed upon reception of focus.
.LP
.nf
Name:	\fBinvalid\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-invalid\fR
.fi
.IP
Specifies a Tcl command to be executed upon determination of invalid input.
The default is bell.
.LP
.nf
Name:	\fBtextBackground\fR
Class:	\fBBackground\fR
Command-Line Switch:	\fB-textbackground\fR
.fi
.IP
Background color for inside textual portion of the entry field.  The value
may be given in any of the forms acceptable to \fBTk_GetColor\fR.
.LP
.nf
Name:	\fBtextFont\fR
Class:	\fBFont\fR
Command-Line Switch:	\fB-textfont\fR
.fi
.IP
Name of font to use for display of text in entryfield.  The value
may be given in any of the forms acceptable to \fBTk_GetFont\fR.
.LP
.nf
Name:	\fBpasting\fR
Class:	\fBBehavior\fR
Command-Line Switch:	\fB-pasting\fR
.fi
.IP
Option to enable/disable pasting into the entry component of the
entryfield.  Valid values are 0 (disabled) or 1 (enabled).
Defaults to 1.
.LP
.nf
Name:	\fBvalidate\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-validate\fR
.fi
.IP
The validate option allows specification of a validation mechanism.  Standard
character validation such as \fBnumeric\fR, \fBalphabetic\fR, \fBinteger\fR,
\fBhexidecimal\fR, \fBreal\fR, and \fBalphanumeric\fR can be handled through 
the use of keywords.  Should more
extensive validation be necessary, the value may contain the name of
a command script.  The script should return a boolean value.  True for 
valid, false for invalid.  If false is returned, then the procedure 
associated with the invalid option will be invoked.
If the validation script contains
any \fB%\fR characters, then the script will not be
executed directly.  Instead, a new script will be
generated by replacing each \fB%\fR, and the character following
it, with information from the entryfield.  The replacement
depends on the character following the \fB%\fR, as defined in the
list below.
.TP
\fB%c\fR
Replaced with the current input character.
.TP
\fB%P\fR
Replaced with the contents of the entryfield modified to include the latest
keystoke.  This is equivalent to peeking at the future contents, enabling
rejection prior to the update.
.TP
\fB%S\fR
Replaced with the current contents of the entryfield prior to the latest
keystroke being added.
.TP
\fB%W\fR
Replaced with the entryfield widget pathname.
.LP
.BE

.SH DESCRIPTION
.PP
The \fBentryfield\fR command creates an enhanced text entry widget with an
optional associated label.  Addtional options support validation and 
establishing a upper limit on the number of characters which may be
entered in the field.
.DE

.SH "METHODS"
.PP
The \fBentryfield\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for entryfield widgets:
.SH "ASSOCIATED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBdelete\fR	\fBget\fR	\fBicursor\fR	\fBindex\fR	
\fBinsert\fR	\fBscan\fR	\fBselection\fR	\fBxview\fR	
.fi
.LP
See the "entry" manual entry for details on the associated methods.
.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBentryfield\fR
command.
.TP
\fIpathName \fBchildsite\fR
Returns the path name of the child site.
.TP
\fIpathName \fBclear\fR
Clear entry widget
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBentryfield\fR
command.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBefchildsite\fR
Class:	\fBframe\fR
.fi
.IP
The efchildsite component is the user child site for the entry field.  See 
the "frame" widget manual entry for details on the efchildsite component item.
.LP
.nf
Name:	\fBentry\fR
Class:	\fBentry\fR
.fi
.IP
The entry component provides the entry field for user text input and display.
See the "entry" widget manual entry for details on the entry component item.
.fi

.SH EXAMPLE
.DS
 option add *textBackground white
 
 proc returnCmd {} {
     puts stdout "Return Pressed"
 }
 
 proc invalidCmd {} {
     puts stdout "Alphabetic contents invalid"
 }
 
 entryfield .ef -command returnCmd
 
 entryfield .fef -labeltext "Fixed:" -fixed 10 -width 12
 
 entryfield .nef -labeltext "Numeric:" -validate numeric -width 12
 
 entryfield .aef -labeltext "Alphabetic:" \\
    -validate alphabetic -width 12 -invalid invalidCmd
 
 entryfield .pef -labeltext "Password:" \\
    -show \267 -width 12 -command returnCmd
 
 Labeledwidget::alignlabels .ef .fef .nef .aef .pef

 pack .ef -fill x -expand yes -padx 10 -pady 5
 pack .fef -fill x -expand yes -padx 10 -pady 5
 pack .nef -fill x -expand yes -padx 10 -pady 5
 pack .aef -fill x -expand yes -padx 10 -pady 5
 pack .pef -fill x -expand yes -padx 10 -pady 5
.DE
.SH AUTHOR
Sue Yockey
.DE
Mark L. Ulferts
.LP
.SH KEYWORDS
entryfield, widget
