/*****************************************************************************
 *                           WidgetManager.cc
 * Author: Matthew Ballance 
 * Desc:   Tracks the native widgets created. The names of the native 
 *         widgets are also tracked... 
 *
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *
 *****************************************************************************/
#ifndef INCLUDED_WIDGET_MANAGER_H
#define INCLUDED_WIDGET_MANAGER_H

#include <string.h>
#include <stdlib.h>
#include "types.h"
#include "vector.h"
#include "ivi_String.h"
#include <tcl.h>
#include "WidgetMgrTypes.h"

#ifdef __cplusplus
extern "C" {
#endif

/*********************************************************
 * WidgetMgr_AddType()
 *********************************************************/
int WidgetMgr_AddType(
    Tcl_Interp     *interp,
    const Char     *typeName
    );

/*********************************************************
 * WidgetMgr_AddInst()
 *********************************************************/
int WidgetMgr_AddInst(
    Tcl_Interp     *interp,
    const Char     *widgetType,
    const Char     *widgetInst,
    voidPtr         widgetPtr
    );

/*********************************************************
 * WidgetMgr_DelInst()
 *********************************************************/
int WidgetMgr_DelInst(
        Tcl_Interp        *interp,
        const char        *widgetType,
        const char        *widgetInst);

/*********************************************************
 * WidgetMgr_Init()
 *********************************************************/
int WidgetMgr_Init(
    Tcl_Interp     *interp
    );

/*********************************************************
 * WidgetMgr_GetObjHandle()
 *********************************************************/
voidPtr WidgetMgr_GetObjHandle(
    Tcl_Interp     *interp,
    const Char     *typeName,
    const Char     *instName
    );

#ifdef __cplusplus
};
#endif

#endif /*INCLUDED_WIDGET_MANAGER_H*/


