/****************************************************************************
 *                             IviRemoteSim.h
 *
 * Author: Matthew Ballance
 * Desc:   The IviRemoteSim object is an interface for the IVI application 
 *         to the remote simulator.
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_IVI_REMOTE_SIM_H
#define INCLUDED_IVI_REMOTE_SIM_H
#include "IviSim.h"
#include "RemoteAppTclCmdListener.h"
#include "RemoteCmdStub.h"
#include <tcl.h>


class IviRemoteProc;
class RemoteAppConnection;
class IviRemoteSimCmdChannel;
class IviRemoteSimRecvChannel;
class SigDB;
class IviRemoteDesignDBSrv;
class DFIO;

/****************************************************************************/
/** \class IviRemoteSim
 *  \brief Implements base class for remote-process simulators
 ****************************************************************************/
class IviRemoteSim : public IviSim {

    friend class IviRemoteSimCmdChannel;
    friend class IviRemoteSimRecvChannel;

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * IviRemoteSim()
         ************************************************************/
        IviRemoteSim(Tcl_Interp *interp, int argc, char **argv);

        /************************************************************
         * ~IviRemoteSim()
         ************************************************************/
        virtual ~IviRemoteSim();

        /************************************************************
         * LoadDesign()
         */
        /** Loads a design into this instance of the IviSim.
         ************************************************************/
        virtual int LoadDesign(char *design_path);

        /************************************************************
         * GetStdoutChannel() 
         ************************************************************/
        virtual const char *GetStdoutChannel();

        /************************************************************
         * Close()
         ************************************************************/
        virtual int Close();

        /************************************************************
         * Run()
         ************************************************************/
        virtual int Run(Uint32 max_time);

        /*****************************************************************
         * vpi_get_time()
         *****************************************************************/
        virtual void vpi_get_time(vpiHandle obj, s_vpi_time *t);

        /*****************************************************************
         * vpi_get()
         *****************************************************************/
        virtual Int32 vpi_get(Int32 property, vpiHandle ref);

    /****************************************************************
     * Protected Methods
     ****************************************************************/
    protected:

        /************************************************************
         * CreateDDB()
         */
        /** Creates and returns a DesignDB object 
         *
         * \note The DDB should be named ${inst_name}.ddb
         ************************************************************/
        virtual DesignDB *CreateDDB();

        /************************************************************
         * CreateDFIO()
         */
        /** Creates and returns a new DFIO object
         *
         * \note The DFIO instance name should be ${inst_name}.dfio
         ************************************************************/
        virtual DFIO *CreateDFIO();

        /************************************************************
         * CreateSDB()
         */
        /** Creates and returns a new SDB object.
         *
         * \note the SDB instance name should be ${inst_name}.sdb
         ************************************************************/
        virtual SigDB *CreateSDB();

        /************************************************************
         * StartSimulator()
         */
        /** Launches the simulator process and waits for design load
         ************************************************************/
        virtual int StartSimulator(const char *command);

    /****************************************************************
     * Private Methods
     ****************************************************************/
    private:

        /************************************************************
         * WaitCmd()
         ************************************************************/
        int WaitCmd();

    /****************************************************************
     * Private Methods
     ****************************************************************/
    private:

        /************************************************************
         * SetupRemoteObjs()
         ************************************************************/
        int SetupRemoteObjs();

    /****************************************************************
     * Private Data
     ****************************************************************/
    private:
        IviRemoteProc            *d_vvpProc;
        RemoteAppConnection      *d_conn;
        RemoteAppTclCmdListener  *d_cmdChan;
        SigDB                    *d_sdb;
        DesignDB                 *d_ddb;
        DFIO                     *d_dfio;

        Tcl_Interp               *d_interp;

        Uint64                    d_currTime;
//        Int32                     d_simResolution;

        Uchar                     d_buf[256];

        bool                      d_recv;

        Uint32                    d_cmd;
        Uchar                     d_data[256];
        Uint32                    d_len;
};

#endif /* INCLUDED_IVI_REMOTE_SIM_H */

