#ifndef _PACKET_C
#define _PACKET_C

#include <stdint.h>
#include <stdio.h>
#include "byte-order.c"
#include "network.c"

#define PAYLOAD_SAMPLES   256
#define PAYLOAD_BYTES     (PAYLOAD_SAMPLES*sizeof(float32_t))

typedef struct
{
  uint32_t index ;
  uint16_t channels ;
  uint16_t frames ;
  char data[PAYLOAD_BYTES] ;
}
packet_t;

void
packet_ntoh ( packet_t *p )
{
  p->index = ntoh32 ( p->index ) ;
  p->channels = ntoh16 ( p->channels ) ;
  p->frames = ntoh16 ( p->frames ) ;
  char *d = p->data ;
  int i = p->channels * p->frames ;
  while ( i-- ) {
    ntoh32_buf ( d , d ) ;
    d += 4 ;
  }
}

void
packet_hton ( packet_t *p )
{
  char *d = p->data ;
  int i = p->channels * p->frames ;
  while ( i-- ) {
    hton32_buf ( d , d ) ;
    d += 4 ;
  }
  p->index = hton32 ( p->index ) ;
  p->channels = hton16 ( p->channels ) ;
  p->frames = hton16 ( p->frames ) ;
}

void
packet_sendto ( int fd , packet_t *p , struct sockaddr_in address )
{
  packet_hton ( p ) ;
  sendto_exactly ( fd , (char *)p , sizeof(packet_t) , address ) ;
}

void
packet_recv ( int fd , packet_t *p , int flags )
{
  recv_exactly ( fd , (char *)p , sizeof(packet_t) , flags ) ;
  packet_ntoh ( p ) ;
}

#endif
