/*
 * JasperReports - Free Java Reporting Library.
 * Copyright (C) 2001 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of JasperReports.
 *
 * JasperReports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JasperReports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with JasperReports. If not, see <http://www.gnu.org/licenses/>.
 */
package net.sf.jasperreports.engine;

import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;


/**
 * @author Teodor Danciu (teodord@users.sourceforge.net)
 * @version $Id: JRPrintHyperlink.java 3502 2010-03-04 11:05:10Z teodord $
 */
public interface JRPrintHyperlink
{

	/**
	 * @deprecated Replaced by {@link #getHyperlinkTypeValue()}.
	 */
	public byte getHyperlinkType();

	/**
	 * Retrieves the hyperlink type for the element.
	 * <p>
	 * The actual hyperlink type is determined by {@link #getLinkType() getLinkType()}.
	 * This method can is used to determine whether the hyperlink type is one of the
	 * built-in types or a custom type. 
	 * When hyperlink is of custom type, {@link HyperlinkTypeEnum#CUSTOM CUSTOM} is returned.
	 * </p>
	 * @return one of the hyperlink type constants
	 * @see #getLinkType()
	 */
	public HyperlinkTypeEnum getHyperlinkTypeValue();

	/**
	 * @deprecated Replaced by {@link #setHyperlinkType(HyperlinkTypeEnum)}.
	 */
	public void setHyperlinkType(byte hyperlinkType);

	/**
	 * Sets the link type as a built-in hyperlink type.
	 * 
	 * @param hyperlinkType the built-in hyperlink type
	 * @see #getLinkType()
	 */
	public void setHyperlinkType(HyperlinkTypeEnum hyperlinkType);
		
	/**
	 * @deprecated Replaced by {@link #getHyperlinkTargetValue()}.
	 */
	public byte getHyperlinkTarget();
	
	/**
	 *
	 */
	public HyperlinkTargetEnum getHyperlinkTargetValue();
		
	/**
	 * @deprecated Replaced by {@link #setHyperlinkTarget(HyperlinkTargetEnum)}.
	 */
	public void setHyperlinkTarget(byte hyperlinkTarget);
	
	/**
	 *
	 */
	public void setHyperlinkTarget(HyperlinkTargetEnum hyperlinkTarget);
		
	/**
	 *
	 */
	public String getHyperlinkReference();
		
	/**
	 *
	 */
	public void setHyperlinkReference(String hyperlinkReference);

	/**
	 *
	 */
	public String getHyperlinkAnchor();
		
	/**
	 *
	 */
	public void setHyperlinkAnchor(String hyperlinkAnchor);

	/**
	 *
	 */
	public Integer getHyperlinkPage();
		
	/**
	 *
	 */
	public void setHyperlinkPage(Integer hyperlinkPage);

	
	/**
	 * Returns the hyperlink type.
	 * 
	 * @return the hyperlink type
	 */
	public String getLinkType();
	
	
	/**
	 * Sets the hyperlink type.
	 * <p>
	 * The type can be one of the built-in types
	 * (Reference, LocalAnchor, LocalPage, RemoteAnchor, RemotePage),
	 * or can be an arbitrary type.
	 * </p>
	 * @param type the hyperlink type
	 */
	public void setLinkType(String type);

	
	/**
	 * Returns the set of custom hyperlink parameters.
	 * 
	 * @return the set of custom hyperlink parameters
	 * @see #setHyperlinkParameters(JRPrintHyperlinkParameters)
	 * @see JRPrintHyperlinkParameter
	 */
	public JRPrintHyperlinkParameters getHyperlinkParameters();
	

	/**
	 * Sets the custom hyperlink parameters.
	 * <p>
	 * These parameters will be used to produce the actual hyperlink
	 * when the report is exported.
	 * </p>
	 * 
	 * @param parameters the set of custom hyperlink parameters
	 */
	public void setHyperlinkParameters(JRPrintHyperlinkParameters parameters);

	
	/**
	 * Returns the hyperlink tooltip.
	 * 
	 * @return the hyperlink tooltip
	 */
	public String getHyperlinkTooltip();
	
	
	/**
	 * Sets the tooltip to be used for the hyperlink.
	 * 
	 * @param tooltip the tooltip
	 */
	public void setHyperlinkTooltip(String tooltip);
	
	/**
	 * Returns the hyperlink target name.
	 * <p>
	 * The target name can be one of the built-in names
	 * (Self, Blank, Top, Parent),
	 * or can be an arbitrary name.
	 * </p>
	 * @return the hyperlink type
	 */
	public String getLinkTarget();


	/**
	 * Sets the hyperlink target name.
	 * <p>
	 * The target name can be one of the built-in names
	 * (Self, Blank, Top, Parent),
	 * or can be an arbitrary name.
	 * </p>
	 * @param linkTarget the hyperlink target name
	 */
	public void setLinkTarget(String linkTarget);
	
}
