#!/bin/sh

# resolution des liens - $0 peut etre un lien symbolique
if [ -z "$JAXE_HOME" -o ! -d "$JAXE_HOME" ] ; then
  PRG="$0"
  progname=`basename "$0"`

  while [ -h "$PRG" ] ; do
    ls=`ls -ld "$PRG"`
    link=`expr "$ls" : '.*-> \(.*\)$'`
    if expr "$link" : '/.*' > /dev/null; then
    PRG="$link"
    else
    PRG=`dirname "$PRG"`"/$link"
    fi
  done

  JAXE_HOME=`dirname "$PRG"`

  # chemin absolu
  JAXE_HOME=`cd "$JAXE_HOME" && pwd`
fi

# Jaxe doit etre lance dans son repertoire
cd $JAXE_HOME

java -Xmx256m -classpath lib/Jaxe.jar:lib/jazzy.jar:lib/log4j-1.2.14.jar:lib/fop_and_libs.jar:lib/jing.jar:config jaxe/Jaxe
