% ispell.sl	-*- mode: SLang; mode: fold -*-
% 
% Authors:	Guido Gonzato
% 		John Davis        
% 		Paul Boekholt <p.boekholt@hetnet.nl>
% 
% $Id: ispell.sl,v 1.12 2003/07/12 17:26:24 paul Exp paul $
% 
% Copyright (c) 2001-2003 Guido Gonzato, John Davis, Paul Boekholt.
% Released under the terms of the GNU GPL (version 2 or later).
% 
% This is Guido's auto-ispell, tweaked for async process by JED, merged
% with my own ispell and further tweaked by Paul Boekholt, patched up
% by Gnter Milde.

require("ispell_common");
require("bufutils");
use_namespace("ispell");
!if (is_defined("ispell_process"))
  public variable ispell_process = -1;

static variable buf, obuf, num_win;
static variable ibuf = " *ispell*", corbuf = "*corrections*";

%{{{ ispell process

public define kill_ispell()
{
   if (-1 != ispell_process)
     kill_process(ispell_process);
   ispell_process = -1;
}

static define wait_for_ispell_output (secs)
{
   variable max_time = _time () + secs;
   variable this_line = what_line ();
   secs *= 10;
   do
     {
        get_process_input (secs);
        if (what_line() > this_line + 1) % ispell gives me two lines, one 
	  % just blank.  If I leave the blank line, it will be picked up 
	  % when checking the next word, when this is called by ispell_region,
	  % which will then be confused.
	  {
	     return 0;
	  }
     }
   while (max_time > _time ());
   return -1;
}


static define start_ispell_process ()
{
   variable cbuf = whatbuf ();
   variable args = strtok (ispell_command + " -a");
   setbuf(ibuf);
   erase_buffer;
   message ("starting ispell process....");

   foreach (args)
     ;
   length (args) - 1;
   ispell_process = open_process ();
   if (ispell_process == -1)
     verror ("Unable to open ispell process");

   % () = wait_for_ispell_output (5); 
   % The header is NOT followed by a blank line...
   sleep(1);
   get_process_input(2);
   bob ();
   if (looking_at_char ('@'))     %  ispell header
     del_through_eol ();
   else if (looking_at("Can't open"))
     verror ("You don't have that dictionary!");
   process_query_at_exit (ispell_process, 0);
   setbuf (cbuf);
}


%}}}

%{{{ checking a word

static define send_word_to_ispell_process (word)
{

   setbuf (ibuf);
   if (ispell_process == -1)
     start_ispell_process ();

   erase_buffer ();
   send_process (ispell_process, strcat (word, "\n"));

   if (-1 == wait_for_ispell_output (5))
     verror ("ispell process is not responding");
}

define get_ispell_command(word, key_array, corrections)
{
   variable n, num;
   forever
     {
	num = get_mini_response("Enter choice. ");
	switch (num)
	  {case 'r': return read_mini("enter correct word", "", "");}
	  {case ' ': return NULL;}
	  {case 'a': send_process (ispell_process, strcat ("@", word, "\n"));
	     return NULL;}
	if (corrections != NULL)
	  {
	     if (num == '
')  return corrections[0];
	     n = where (key_array == num);
	     if (length(n))
	       return corrections[n[0]];
	  }
     }
}

% check a word
% is_auto =	1: called from autoispell
% 		2: called from ispell_region
define ispell_word (is_auto)
{
   variable num_win, old_buf, corrections = NULL;
   variable word, n, new_word, buf;
   variable keys = "0123456789!@#$%^&*()", key_array = Char_Type[20];

   skip_chars(ispell_letters);
   n = POINT;
   ispell_beginning_of_word();
   if (POINT == n)
     return;
   push_mark();
   ispell_end_of_word();
   
   buf = whatbuf();
   word = bufsubstr();
   if (strlen (word) < 3 and is_auto) return;
   send_word_to_ispell_process (word);

   %%
   %% parse output
   %%
   bob();
   if (looking_at_char('@'))   % ispell header
     {
        del_through_eol ();
     }

   EXIT_BLOCK
     {
        setbuf (buf);
     }

   if (looking_at_char('*') or looking_at_char('+') or looking_at_char('-'))
     {
        !if (is_auto)
          message ("Correct");   % '+' ==> is derived from
        return;
     }
   
   if (is_auto == 1) beep();
   
   if (looking_at_char('#') and is_auto < 2)
     {
	message("No clue.");
	return;
     }
   

   %del(); trim(); eol_trim(); bol();
   if (ffind_char (':'))
     {
        skip_chars(":\t ");
        push_mark();
        eol();
	corrections = strchop(bufsubstr(), ',', 0)[[-20:]];
	corrections = array_map (String_Type, &strtrim, corrections);
    
	erase_buffer();
	
	init_char_array (key_array, keys);
	n = length(corrections);
	key_array = key_array[[:n - 1]];
	variable i = 0;
        setbuf (corbuf);
	erase_buffer();
	loop (n)
	  {
	     vinsert("(%c) %s\n", key_array[i], corrections[i]);
	     ++i;
	  }
	buffer_format_in_columns();
     }
   else % there was no ':' which means it was a '#'
     {
        setbuf (corbuf);
	erase_buffer();
	insert ("no suggestions");
     }
   bob();
   insert(strcat ("Misspelled: ", word,
		  " \tKey: select correction\t r: enter correction\n",
		  "space: skip\t a: accept this session\t^G: quit\n"));
   pop2buf(buf);
   ispell_beginning_of_word();
   push_visible_mark();
   ispell_end_of_word();
   num_win = nwindows() - MINIBUFFER_ACTIVE;
   if (num_win == 1) recenter(3); % We want corbuf below
   old_buf = pop2buf_whatbuf (corbuf);
   bob;
   if (num_win == 1) fit_window();
   
   set_buffer_modified_flag(0);

   ERROR_BLOCK
     {
	sw2buf(old_buf);
	pop2buf(buf);
        if (num_win == 1) onewindow();
	pop_mark_0();
     }
   new_word = get_ispell_command(word, key_array, corrections);
   sw2buf(old_buf);
   pop2buf(buf);
   if (num_win == 1) onewindow();
   if (new_word != NULL)
     {  
	del_region();
	insert(new_word);
     }
   else
     pop_mark_0();
}

public define ispell ()
{
   ispell_word (0);
}

%}}}

%{{{ auto ispell

% I can't check words ending in newlines with this, because ^M may be bound to
% newline_and_indent, etc. I could rewrite this to use the after_key_hook,
% but autoispell has been broken for a month an no one has noticed, so I may
% remove it (I prefer flyspell).
public define autoispell_insert (char)
{
   insert_char (char);
   push_spot;
   go_left_1;
   bskip_chars(ispell_otherchars);
   ispell_word (1);
   pop_spot;
}

define autoispell_switch_active_buffer_hook(oldbuf) % hook is called with arg
{
   variable ch, on_off = ["OFF", "ON"];
   variable autospell = get_blocal("autoispell", 0);
  
   foreach (" ,;:.\"")
     {
        ch = char (());
        local_unsetkey (ch);
        if (autospell)
          local_setkey (sprintf (". %d autoispell_insert", ch[0]), ch);
        else
          local_setkey ("self_insert_cmd", ch);
     }
      vmessage ("Automatic ispell %s for this buffer", on_off[autospell]);
}

static define toggle_local_autoispell()
{
   !if (blocal_var_exists("autoispell"))
     {
	create_blocal_var ("autoispell");
	set_blocal_var (0, "autoispell");
     }
   set_blocal_var( not (get_blocal ("autoispell", 0)), "autoispell");
   autoispell_switch_active_buffer_hook("");  % hook expects an argument
}

% Turn on / toggle auto_ispell
public define auto_ispell ()
{
   if (ispell_process == -1)
     start_ispell_process ();
   toggle_local_autoispell();
   add_to_hook("_jed_switch_active_buffer_hooks", 
	       &autoispell_switch_active_buffer_hook);
}

%}}}

%{{{ checking a region

static variable local_ispell_hook;
% run a blocal hook, and check
static define runhook_and_check_word()
{
   if (@local_ispell_hook())
     ispell_word(2);
}

static define no_hook_check_word()
{
   ispell_word(2);
}

% check a region or the entire buffer.  It really works!
public define ispell_region()
{
   % if there is a bufferlocal "ispell_region_hook", use it!
   % Should be a reference to a function that returns 1 if the
   % word is to be checked
   variable ispell_word_fun;
   if (blocal_var_exists("ispell_region_hook"))
     {
	local_ispell_hook = get_blocal_var("ispell_region_hook");
	ispell_word_fun = &runhook_and_check_word;
     }
   else
     {
	ispell_word_fun = &no_hook_check_word;
     }

   if (ispell_process == -1)
     {
	start_ispell_process ();
	update_sans_update_hook(1);
	get_process_input(10);
     }
 
   push_narrow();
   ERROR_BLOCK
     {
	pop_narrow():
     }
   if (is_visible_mark) narrow();
   bob();
   while (not (eobp))
     {
	@ispell_word_fun;
	skip_chars(ispell_non_letters);
	skip_chars("\n");
     }
   pop_narrow();
   if (bufferp(corbuf))
     delbuf(corbuf);
}

%}}}
