#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <jvmpi.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <arena.h>

arena* arena_new (jint arena_id, const char* arena_name) {
    arena* a;
    a = malloc (sizeof (*a));
    if (a == NULL)
	return NULL;
    a->arena_id = arena_id;
    a->arena_name = strdup (arena_name);
    if (a->arena_name == NULL) {
	free (a);
	return NULL;
    }
    return a;
}

void arena_free (arena* arena) {
    if (arena == NULL)
	return;
    free (arena->arena_name);
    free (arena);
}

size_t arena_jmphash_func (void* a, size_t len) {
    arena* ap = (arena*)a;
    return ap->arena_id % len;
}

int arena_cmp_func (void* arena1, void* arena2) {
    arena* a1 = (arena*)arena1;
    arena* a2 = (arena*)arena2;
    return a1->arena_id - a2->arena_id;
}

void arena_print (arena* arena) {
    fprintf (stdout, "ARENA: %d, %s\n", arena->arena_id, arena->arena_name);
}

void arena_set_arena_id (arena *a, jint id) {
    if (a != NULL)
	a->arena_id = id;
}

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
