
/*
 * cmd.h -- written for Juice
 *	Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef PLAYER_CMD_H
#define PLAYER_CMD_H

#include "typedefs.h"

/* This splits the given program and it's arguments up into seperate strings */
void split_cmd_args (const char *progname);

/* This executes a command with the given parameters (It calls create_child()) */
/* nargs is the number of parameters, the parameters follow it */
bool run_command_list (const int nargs, ...);

/* This executes a command with the given parameters (It calls create_child()) */
/* parameters is an array of parameters, the last one must be NULL */
bool run_command_null (const char *parameters[]);

/* This destroy the buffer created byt split_cmd_args() */
void destroy_split_args ();

#endif
