# $Id: Fork.pm,v 1.3 2003/06/23 11:05:25 tsuchiya Exp $
package Juman::Fork;
require 5.000;
require Exporter;
use IO::Handle;
use IO::Pipe;
use POSIX;
use strict;
use vars qw/ @ISA @EXPORT_OK $TIMEOUT /;
@ISA = qw/ Exporter /;
@EXPORT_OK = qw/ $TIMEOUT /;

=head1 NAME

Juman::Fork - Ʊ˼¹Ԥҥץ

=head1 SYNOPSIS

 use Juman::Fork;
 $p = new Juman::Fork( "sort" );
 $p->print( "abc\n", "def\n", "ace\n" );
 $p->close;
 while( $_ = $p->getline ){
     print;
 }

=head1 DESCRIPTION

C<Juman::Fork> ϡꤵ줿ޥɤ fork ƻҥץȤƼ¹
ɸϤؤν񤭹ߤȡɸϵڤɸ२顼Ϥɤ߽
ԤΥ⥸塼Ǥ

=head1 CONSTRUCTOR

=over 4

=item new ( COMMAND [,ARGV] )

C<Juman::Fork> ֥ȤޤҥץȤƼ¹Ԥ륳
ɤ1˻ꤷ2ʹߤˤΥޥɤФ륳ޥɥ饤
ץꤷޤ

Example:

   $p = new Juman::Fork( "cat" "-n" );

=back

=head1 METHODS

=over 4

=item print( [STR,] )

ˤäƻꤵ줿ʸҥץɸϤϤ᥽åɤǤ

=item printf( FORMAT [,ARG] )

1ˤäƻꤵ줿񼰤˽äơꤵ줿ʸҥץ
ɸϤϤ᥽åɤǤ

=item getline()

ҥץɸϵڤɸ२顼Ϥ1ʬΥǡФ᥽
ɤǤC<timeout> ˤäꤵ줿ְɤ߽ФʤС
C<undef> ֤ޤ

=item timeout( VAL )

ҥץνϤ C<getline> ᥽åɤˤäƼФΥॢ
Ȼ֤ꤹ᥽åɤǤॢȻ֤νͤˤѿ 
C<$Juman::Fork::TIMEOUT> ͤȤޤ

=item alive()

ҥץĤäƤ뤫Ĵ٤᥽åɤǤ

=item pid()

ҥץ PID ֤᥽åɤǤ

=item close()

ҥץɸϤϢ뤵ƤѥפĤ᥽åɤǤ

=item kill()

ҥץλ᥽åɤǤ

=back

=head1 AUTHOR

TSUCHIYA Masatoshi <tsuchiya@pine.kuee.kyoto-u.ac.jp>

=cut

# ǥեȤΥॢȻ
$TIMEOUT = 60;


# ꤵ줿ޥɤҥץȤ fork 
sub new {
    my( $this, @argv ) = @_;
    ( @argv >= 1 ) || die 'Usage: $p = new Juman::Fork( command, [arguments] )';

    my $read  = new IO::Pipe;
    my $write = new IO::Pipe;

  FORK: {
	if( my $pid = fork ){
	    # ƥץ¦ν
	    $read->reader;
	    $write->writer;
	    $this = {
		     PID     => $pid,
		     READ    => $read,
		     WRITE   => $write,
		     TIMEOUT => $TIMEOUT,
		    };
	    bless $this;
	    return $this;
	} elsif( defined $pid ){
	    # ҥץ¦ν
	    $write->reader;
	    $read->writer;
	    STDOUT->fdopen( $read, "w" );
	    STDERR->fdopen( $read, "w" );
	    STDIN->fdopen( $write, "r" );
	    exec join( " ", @argv );
	    exit 0;
	} elsif( $! =~ /No more process/ ){
	    sleep 5;
	    redo FORK;
	} else {
	    die "Can't fork: $!\n";
	}
    }
}


# ҥץɸϤʸ񤭹
sub print {
    my $this = shift;
    $this->{WRITE}->print( @_ );
    $this->{WRITE}->flush;		# Ū˥եå夹
    1;
}


# ҥץɸϤФդ
sub printf {
    my $this = shift;
    my $fmt  = shift;
    $this->{WRITE}->print( sprintf( $fmt, @_ ) );
    $this->{WRITE}->flush;		# Ū˥եå夹
    1;
}


# ҥץɸϤĤؿ
sub close {
    my( $this ) = @_;
    $this->{WRITE}->close;
}


# ॢȤλ֤ꤹؿ
sub timeout {
    my( $this, $timeout ) = @_;
    $this->{TIMEOUT} = eval $timeout;
}


# ҥץɸϤɸ२顼Ϥ饿ॢȤĤɤ߽Ф
sub getline {
    my( $this ) = @_;
    my $buf = "";
    local $SIG{ALRM} = sub { die "SIGALRM is received\n"; };
    eval {
	alarm $this->{TIMEOUT};
	$buf = $this->{READ}->getline;
	alarm 0;
    };
    if( $@ =~ /SIGALRM is received/ ){
	return undef;
    }
    $buf;
}


# ҥץ PID ֤ؿ
sub pid {
    my( $this ) = @_;
    $this->{PID};
}


# ҥץޤƤ뤫Ĵ٤ؿ
sub alive {
    my( $this ) = @_;
    ( waitpid( $this->{PID},&POSIX::WNOHANG ) == 0 ) && ( $? == -1 );
}


# ҥץλؿ
sub kill {
    my( $this ) = @_;
    $this->{WRITE}->print( "\004" );
    $this->{WRITE}->close;
    sleep 1;
    kill 15, $this->{PID};
    sleep 1;
    kill 9, $this->{PID};
    $this->alive();			# To avoid zombie.
    $this->{PID} = 0;
    1;
}

1;
__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
