package com.ca.directory.jxplorer;

/**
 * Data class that holds the help system IDs.
 * These are used when for linking a help
 * topic to a help button on a dialog.
 * @author Trudi.
 */
public class HelpIDs
{
    /**
     * Stop monitor dialog.
     */
    public static final String ABORT = "abort";

    /**
     * Audio editor dialog.
     */
    public static final String ATTR_AUDIO = "attr.audio";

    /**
     * Default editor dialog.
     */
    public static final String ATTR_BINARY = "attr.binary";

    /**
     * Boolean editor dialog.
     */
    public static final String ATTR_BOOLEAN = "attr.boolean";

    /**
     * JPEGPhoto editor dialog.
     */
    public static final String ATTR_JPEGPHOTO = "attr.jpegphoto";

    /**
     * Password editor dialog.
     */
    public static final String ATTR_PASSWORD = "attr.password";

    /**
     * Address editor dialog.
     */
    public static final String ATTR_POSTAL = "attr.postal";

    /**
     * Generalized time editor dialog.
     */
    public static final String ATTR_TIME = "attr.time";

    /**
     * Change object class dialog.
     */
    public static final String CLASS_CHANGE = "class.change";

    /**
     * Advanced options dialog.
     */
    public static final String CONFIG_ADVANCED = "config.advanced";

    /**
     * Add bookmark dialog.
     */
    public static final String BOOKMARK_ADD = "bookmark.add";

    /**
     * Edit bookmark dialog.
     */
    public static final String BOOKMARK_EDIT = "bookmark.edit";

    /**
     * Delete bookmark dialog.
     */
    public static final String BOOKMARK_DELETE = "bookmark.delete";

    /**
     * Connection dialog.
     */
    public static final String CONNECT = "connect";

    /**
     * Customer support link.
     */
    public static final String CONTACT_SUPPORT = "contact.support";

    /**
     * New entry dialog.
     */
    public static final String ENTRY_NEW = "entry.new";

    /**
     * LDIF export dialog (full subtree).
     */
    public static final String LDIF_EXPORT_SUBTREE = "ldif.export.subtree";

    /**
     * LDIF export dialog (full tree).
     */
    public static final String LDIF_EXPORT_TREE = "ldif.export.tree";

    /**
     * Search dialog.
     */
    public static final String SEARCH = "search";

    /**
     * Delete search filter dialog.
     */
    public static final String SEARCH_DELETE_FILTER = "search.delete.filter";

    /**
     * Return attributes search results dialog.
     */
    public static final String SEARCH_RESULTS = "search.results";

    /**
     * Return attributes dialog.
     */
    public static final String SEARCH_RETURN_ATTRIBUTES = "search.return.attributes";

    /**
     * Manage certs dialog.
     */
    public static final String SSL_CERTS = "ssl.certs";

    /**
     * Keystore options dialog.
     */
    public static final String SSL_CHANGE_KEYSTORE = "ssl.change.keystore";

    /**
     * Change the keystore password dialog.
     */
    public static final String SSL_KEYSTORE_PASSWORD = "ssl.keystore.password";

    /**
     * Certificate dialog.
     */
    public static final String SSL_VIEW = "ssl.view";

    /**
     * Table of contents tab.
     */
    public static final String TAB_TOC = "TOC";

    /**
     * Search tab.
     */
    public static final String TAB_SEARCH = "Search";
}
