	/* ======================================================================
	 * Copyright (c) 1998-1999 The Johns Hopkins University.
	 * All rights reserved.
	 * The following code was written by Theo Schlossnagle for use in the
	 * Backhand project at The Center for Networking and Distributed Systems
	 * at The Johns Hopkins University.
	 * Please refer to the LICENSE file before using this software.
	 * ======================================================================
	*/
	/* This is exported for use in builtins.c */
	int find_highest_arriba(serverstat *ss) {
	  int i, highest=0;
	  for(i=0;i<HARD_SERVER_LIMIT;i++)
	    highest = MAX(highest,
			  ss[i].arriba);
	  return highest;
	}
	static int find_max_load(serverstat *ss, int ha) {
	  int i, highest=0;
	  float myaa;
	  for(i=0;i<HARD_SERVER_LIMIT;i++) {
	    if(ss[i].arriba) myaa = (float)ha/(float)ss[i].arriba;
	    else myaa = 0;
	    highest = MAX(highest,
			  (float)ss[i].load*myaa);
	  }
	  return highest;
	}
	static int set_high_watermark(void) {
	  int i=0, aload, ha;
	  ha = find_highest_arriba(serverstats);
	  aload = find_max_load(serverstats, ha);
	  if(aload>0) aload-=1; /* n - delta */
	  aload /= 1000; /* places hwm @ mag(load)*/
	  aload <<= 1;
	  while(aload >>=1) i++; /* log2(1+n-delta) */
	  aload = 1 << i; /* 2^(n+1) */
	  for(i=0;i<HARD_SERVER_LIMIT;i++)
	    aload = MAX(aload, serverstats[i].load_hwm/1000);
	  return aload;
	}

	#ifdef LINUX
#ifndef CPUSTATES
#define CPUSTATES 4
#endif
#ifndef NR_CPUS
#define NR_CPUS 8
#endif
#ifndef STATFILE
#define STATFILE "/proc/stat"
#endif
#ifndef MEMFILE
#define MEMFILE "/proc/meminfo"
#endif
#ifndef LOADFILE
#define LOADFILE "/proc/loadavg"
#endif

static long cp_time[NR_CPUS+1][CPUSTATES]={{0}};
static long cp_old[NR_CPUS+1][CPUSTATES]={{0}};
static int numcpus=0;

static void initstat(void) {
  FILE *proc_stat;
  int foundcpu=0, i, j;  /* we found a line beginning with "cpu " */
  char dummy[256];
  char line[1024];
  
  /* count the number of CPUs mentioned in the stat file */
  if((proc_stat=fopen(STATFILE, "r"))==NULL) {
    perror(STATFILE);
  }
  while(NULL!=fgets(line, sizeof(line)-1, proc_stat)){
    if(0==strncmp(line, "cpu", strlen("cpu"))){
      if(' '==line[strlen("cpu")]){
        /* line looks like "cpu ..." */
        foundcpu=1;
      } else if(isdigit(line[strlen("cpu")])){
        /* line looks like "cpuN ..." */
        numcpus++;
      }
    }
  }
  (void)fclose(proc_stat);
  
  /* 
   * If there is no line beginning with "cpuN" (eg. cpu0), then 
   * this is a uniprocessor system.
   */
  if(0==numcpus) {
    numcpus=foundcpu; 
  } 
  if(numcpus>(NR_CPUS+1)) numcpus=NR_CPUS+1;
  if((proc_stat=fopen(STATFILE,"r")) == NULL ) {
    perror(STATFILE);
    for( i=0; i < numcpus; i++)
      for(j=0;j<CPUSTATES;j++) cp_old[i][j] = 0;
  } else {
    for (i=0; i < numcpus; i++)
      fscanf(proc_stat, "%s %ld %ld %ld %ld \n",
             dummy, &cp_old[i][0], &cp_old[i][1], &cp_old[i][2],
             &cp_old[i][3]);
  }
  (void)fclose(proc_stat);
}

static void fillstat(serverstat *ss, server_rec *s,
		     struct in_addr from_addr, unsigned int webport) {
  FILE *proc_stat;
  char dummy[256];
  float ourload=0.0;
  float states[CPUSTATES] = {0.0}, ourcpu=0.0;
  int i, nstates, tmem, amem;

  /* Fill out hostname */
  strncpy(ss->hostname, s->server_hostname, 40);
  ss->hostname[39]='\0';

  /* Find CPU Idle now */
  if((proc_stat=fopen(STATFILE,"r")) == NULL ) {
    perror(STATFILE);
  } else {
    for (i=0; i < numcpus; i++) {
      fscanf(proc_stat, "%s %ld %ld %ld %ld",
             dummy, &cp_time[i][0], &cp_time[i][1], &cp_time[i][2],
             &cp_time[i][3]);
#define delta(cpustate) ((int)(cp_time[i][(cpustate)]-cp_old[i][(cpustate)]))
      nstates = 0;
      states[nstates++] += delta(3); /* IDLE */
      states[nstates++] += delta(0); /* USER */
      states[nstates++] += delta(1); /* NICE */
      states[nstates++] += delta(2); /* SYS  */
      cp_old[i][0] = cp_time[i][0];
      cp_old[i][1] = cp_time[i][1];
      cp_old[i][2] = cp_time[i][2];
      cp_old[i][3] = cp_time[i][3];
    }
  }
  (void)fclose(proc_stat);
  for(i=0;i<CPUSTATES;i++)
    ourcpu += states[i];
  ourcpu = (ourcpu==0.0)?0.0:(states[0]/ourcpu); //states[0] == IDLE
  ourcpu *= 1000.0;
  /* Find the memory now */
  tmem = -1;
  amem = -1;
  if((proc_stat=fopen(MEMFILE,"r")) == NULL) {
    perror(MEMFILE);
  } else {
    while(fgets(dummy, 100, proc_stat)) {
      if(strncmp(dummy, "Mem:", 4)==0) {
	int tm, um, fm, sm, bm, cm;
	sscanf(dummy+5, "%d %d %d %d %d %d", &tm, &um, &fm, &sm, &bm, &cm);
	tmem=tm/(1024*1024);
	fm /= (1024*1024);
	bm /= (1024*1024);
	cm /= (1024*1024);
	amem=MAX(fm+bm+cm-5, 0); // Free + Cached + Buffered ???
	break;
      }
    }
    fclose(proc_stat);
  }
  /* Find the load now */
  if((proc_stat=fopen(LOADFILE,"r")) == NULL ) {
    perror(LOADFILE);
  } else {
    if(fgets(dummy, 100, proc_stat)==NULL) {
      perror(LOADFILE);
    } else {
      ourload = atof(dummy);
    }
    (void)fclose(proc_stat);
  }
  ourload*=1000.0;  
  
  ss->nservers=0;
  ss->aservers=0;
  if(ap_exists_scoreboard_image()) {
    for(i=0;i<HARD_SERVER_LIMIT;i++) {
      if(ap_scoreboard_image->servers[i].status>=SERVER_READY)
	ss->nservers++;
      if(ap_scoreboard_image->servers[i].status==SERVER_READY)
	ss->aservers++;
    }
  }
  ss->arriba = mod_backhand_personal_arriba;
  ss->tmem = tmem;
  ss->amem = amem;
  if(!ss->contact.sin_port) {
    if(webport)
      ss->contact.sin_port = webport;
    else
      ss->contact.sin_port = ap_listeners->local_addr.sin_port;
  }
  ss->load=(int)ourload;
  ss->load_hwm = set_high_watermark()*1000;
  ss->cpu =(int)ourcpu;
  ss->ncpu=(int)numcpus;
  if(serverstats->contact.sin_addr.s_addr==0) {
    memcpy(&serverstats->contact.sin_addr, &from_addr, sizeof(struct in_addr));
  }
  memcpy(&ss->contact.sin_addr, &serverstats->contact.sin_addr,
	 sizeof(struct in_addr));
}
#else /* ELSE NOT LINUX */
#ifdef SOLARIS2
#include <kstat.h>
#include <fcntl.h>
#include <sys/var.h>
#include <sys/sysinfo.h>
#include <sys/ioctl.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#ifndef kstime_t
#define kstime_t hrtime_t
#endif 

#define DISKSTATES 3
struct kstat_list {
  kstat_t *k;
  struct kstat_list *next;
};
static kstat_ctl_t *kctl = NULL;
static struct kstat_list *disk = NULL, *cpu = NULL;
static kstat_t *syspages=NULL, *sysmisc=NULL;
static ulong_t physmem;
static ulong *cpu_old[CPU_STATES];
static kstime_t *old_update, *old_rtime, *old_wtime;
static int ncpu=0, ndisk=0, maxcpunum=0, *cpupos=NULL, pgsize;
static char diskname[80] = "";

void initstat(void) {
  kstat_t *k;
  int i,c;
  struct kstat_list *diskcur,*cpucur, *kl;
  /* Open the kstat interface */
  pgsize = sysconf(_SC_PAGESIZE);
  pgsize /= 1024; /* Page size in kb */
  if(NULL==(kctl=kstat_open())){
    perror("kstat");
    exit(1);
  }
  for(k=kctl->kc_chain;k;k=k->ks_next){
    if(!strncmp(k->ks_name, "cpu_stat", 8)){
      struct kstat_list *newone;
      int cpunum;
      
      (void)sscanf(k->ks_name, "cpu_stat%d", &cpunum);
      if(cpunum>maxcpunum) maxcpunum = cpunum;
      newone =
        (struct kstat_list *)malloc(sizeof(struct kstat_list));
      newone->k=k;
      newone->next=NULL;
      if(NULL==cpu){
        cpu=newone;
        cpucur=newone;
      } else {
        cpucur->next=newone;
        cpucur=newone;
      }
      ncpu++;
    } else if(!strncmp(k->ks_name, "system_pages", 12)) {
  /* Let's get the physical memory and the avilable memory */
      kstat_named_t *kn;
      syspages = k;
      if(kstat_read(kctl, syspages, 0)!=-1 &&
	 (kn = (kstat_named_t *)kstat_data_lookup(syspages, "physmem"))!=NULL)
	kn->value.ul /= 1024; /* pgsize in kb, we want mb */
	physmem = pgsize*kn->value.ul;
      else
        physmem = 0;
    } else if(!strncmp(k->ks_name, "system_misc", 11)) {
      sysmisc = k;
    } else if(!strcmp(k->ks_class, "disk")
       && !strcmp(k->ks_name, diskname)
       && KSTAT_TYPE_IO==k->ks_type){
      struct kstat_list *newone;
      
      newone = 
        (struct kstat_list *)malloc(sizeof(struct kstat_list));
      newone->k=k;
      newone->next=NULL;
      if(NULL==disk){
        disk=newone;
        diskcur=newone;
      } else {
        diskcur->next=newone;
        diskcur=newone;
      }
      ndisk++;
    }
  }
  if(maxcpunum<ncpu) maxcpunum=ncpu;
  cpupos = (int *)malloc((maxcpunum+1)*sizeof(int));
  for(i=0;i<=maxcpunum;i++) cpupos[i]=-1;
  for(kl=cpu;kl;kl=kl->next){
    (void)sscanf(kl->k->ks_name, "cpu_stat%d", &i);
    cpupos[i]=1;
  }
  c=0;
  for(i=0;i<=maxcpunum;i++) {
    if(0<cpupos[i]) {
      cpupos[i]=c;
      c++;
    }
  }
  for(i=0;i<CPU_STATES;i++){
    cpu_old[i] = (ulong *)malloc(ncpu*sizeof(ulong));
  }
  old_update = (kstime_t *)malloc(ndisk*sizeof(kstime_t));
  old_rtime = (kstime_t *)malloc(ndisk*sizeof(kstime_t));
  old_wtime = (kstime_t *)malloc(ndisk*sizeof(kstime_t));
  
}

#define delta(cpustate) ((int)(cpustat.cpu_sysinfo.cpu[(cpustate)] \
- cpu_old[(cpustate)][i]))

static void fillstat(serverstat *ss, server_rec *s,
		     struct in_addr from_addr, unsigned int webport) {
  float ourload=0.0;
  float ourcpu=0.0;
  float percent_idle=1.0, total=0.0;
  int tmem, amem, numcpus=0;
  int states[DISKSTATES] = {0};
  int i,j,nstates=0;
  cpu_stat_t cpustat;
  kstat_io_t dstat;
  kstat_named_t *kn;
  struct kstat_list *k;

  /* CPU stuff */
  total=0.0;
  for(k=cpu;k;k=k->next){       /* for each cpu... */
    int cpunum;

    (void)sscanf(k->k->ks_name, "cpu_stat%d", &cpunum);
    i=cpupos[cpunum];
    numcpus++;
    /* grab info */
    if(-1==kstat_read(kctl, k->k, (void *)&cpustat)){
      perror("kstat: cpustat");
      exit(1);
    }
                
    nstates=0;
    states[nstates++] += delta(CPU_IDLE);
    states[nstates++] += delta(CPU_WAIT);
    states[nstates++] += delta(CPU_USER);
    states[nstates++] += delta(CPU_KERNEL);

    /* save old values */
    for(j=0;j<CPU_STATES;j++){
      cpu_old[j][i]=cpustat.cpu_sysinfo.cpu[j];
    }
  }
  for(j=0;j<nstates;j++) total+=states[j];
  ourcpu = (total==0.0)?0.0:(states[0]+states[1])/total;
  ourcpu *= 1000.0;
  
  /* LOAD stuff */

  /* Fill out hostname */
  strncpy(ss->hostname, s->server_hostname, 40);
  ss->hostname[39]='\0';
  ss->nservers=0;
  ss->aservers=0;
  if(ap_exists_scoreboard_image()) {
    for(i=0;i<HARD_SERVER_LIMIT;i++) {
      if(ap_scoreboard_image->servers[i].status>=SERVER_READY)
	ss->nservers++;
      if(ap_scoreboard_image->servers[i].status==SERVER_READY)
	ss->aservers++;
    }
  }
  ss->arriba = mod_backhand_personal_arriba;

  /* Total/Available memory: We have physmem sotred in physmem 
     and that ain't changin' */
  ss->tmem = physmem;
  if(syspages &&
     kstat_read(kctl, syspages, 0)!=-1 &&
     ((kn = (kstat_named_t *)kstat_data_lookup(syspages, "freemem"))!=NULL))
    kn->value.ul /= 1024; /* pgsize in kb, we want mb */
    ss->amem = pgsize*kn->value.ul;
  else
    ss->amem = 0;
  if(!ss->contact.sin_port)
    if(webport) {
      ss->contact.sin_port = webport;
    } else {
      ss->contact.sin_port = ap_listeners->local_addr.sin_port;
    }
  if(sysmisc &&
     kstat_read(kctl, sysmisc, 0)!=-1 &&
     ((kn=(kstat_named_t *)kstat_data_lookup(sysmisc, "avenrun_1min"))!=NULL))
    ss->load=(int)(1000.0*(float)kn->value.ul/(float)FSCALE);
  else
    ss->load=0;
  ss->load_hwm=set_high_watermark()*1000;
  ss->cpu =(int)ourcpu;
  ss->ncpu=(int)numcpus;
  if(serverstats->contact.sin_addr.s_addr==0) {
/*    find_myip_from_broadcast(rsd,
			     &serverstats->contact.sin_addr,
			     broadcast_addr);
    ap_log_error(APLOG_MARK, APLOG_ERR|APLOG_NOERRNO, NULL,
		 "mod_backhand: Found my IP: %s",
		 inet_ntoa(serverstats->contact.sin_addr));*/
    memcpy(&serverstats->contact.sin_addr, &from_addr, sizeof(struct in_addr));
  }
  memcpy(&ss->contact.sin_addr, &serverstats->contact.sin_addr,
	 sizeof(struct in_addr));
}
#else /* ELSE NOT SOLARIS2 EITHER */
#ifdef DARWIN /* if DARWIN */
#include <mach/mach.h>

#define mytask mach_task_self()
static host_cpu_load_info_data_t	oldcpuinfo;
static host_cpu_load_info_data_t	newcpuinfo;
static int 				usermem, ncpu;


void initstat(void)
{
   register kern_return_t	kr;
   host_basic_info_data_t	hostinfo;
   int				count;

   count = HOST_CPU_LOAD_INFO_COUNT;
   kr = host_statistics(mach_host_self(), HOST_CPU_LOAD_INFO,
                        (host_info_t)&oldcpuinfo, &count);
   if(kr != KERN_SUCCESS)
      mach_error("can't get host_cpu_load_info???\n", kr);

   count = HOST_BASIC_INFO_COUNT;
   kr = host_info(mach_host_self(), HOST_BASIC_INFO,
                  (host_info_t)&hostinfo, &count);
   if(kr != KERN_SUCCESS)
      mach_error("can't get host_basic_info???\n", kr);
   
   ncpu    = (int)hostinfo.avail_cpus;   
   usermem = (int)hostinfo.memory_size /= 1024*1024;
      
}

static void fillstat(serverstat *ss, server_rec *s,
		     struct in_addr from_addr, unsigned int webport)
{
   register kern_return_t		kr;
   register int				i;
   int					count;
   register float 			ourcpu = 0.0;
   vm_statistics_data_t			vminfo;
   host_load_info_data_t		loadinfo;
   count = HOST_VM_INFO_COUNT;
   kr = host_statistics(mach_host_self(), HOST_VM_INFO,
                        (host_info_t)&vminfo, &count);
   if(kr != KERN_SUCCESS)
      mach_error("can't get host_vm_info???\n", kr);

   count = HOST_LOAD_INFO_COUNT;
   kr = host_statistics(mach_host_self(), HOST_LOAD_INFO,
                        (host_info_t)&loadinfo, &count);
   if(kr != KERN_SUCCESS)
      mach_error("can't get host_load_info???\n", kr);

   count = HOST_CPU_LOAD_INFO_COUNT;
   kr = host_statistics(mach_host_self(), HOST_CPU_LOAD_INFO,
                        (host_info_t)&newcpuinfo, &count);
   if(kr != KERN_SUCCESS)
      mach_error("can't get host_cpu_load_info???\n", kr);

  for(i = 0; i < CPU_STATE_MAX; i++)
     ourcpu += (float)(newcpuinfo.cpu_ticks[i] - oldcpuinfo.cpu_ticks[i]);     
  ourcpu = 1.0 - (((float)(newcpuinfo.cpu_ticks[CPU_STATE_IDLE] - 
                        oldcpuinfo.cpu_ticks[CPU_STATE_IDLE])) / ourcpu);
  ourcpu *= 1000.0;
  for(i = 0; i < CPU_STATE_MAX; i++)
    oldcpuinfo.cpu_ticks[i] = newcpuinfo.cpu_ticks[i];

  ss->load = (double)loadinfo.avenrun[0];
  ss->load_hwm = set_high_watermark() * 1000;

  ss->tmem = usermem;

  vminfo.free_count /= 1024*1024; /* calculate in mb */
  ss->amem = (int)(vm_page_size * vminfo.free_count);
  
  ss->cpu = (int)ourcpu;
  
  ss->ncpu = ncpu;
  
  /* Fill out hostname */
  strncpy(ss->hostname, s->server_hostname, 40);
  ss->hostname[39]='\0';
  if(!ss->contact.sin_port)
    if(webport) {
      ss->contact.sin_port = webport;
    } else {
      ss->contact.sin_port = ap_listeners->local_addr.sin_port;
    }
  ss->nservers=0;
  ss->aservers=0;
  if(ap_exists_scoreboard_image()) {
    for(i=0;i<HARD_SERVER_LIMIT;i++) {
      if(ap_scoreboard_image->servers[i].status>=SERVER_READY)
	ss->nservers++;
      if(ap_scoreboard_image->servers[i].status==SERVER_READY)
	ss->aservers++;
    }
  }
  ss->arriba = mod_backhand_personal_arriba;
  if(serverstats->contact.sin_addr.s_addr==0) {
    memcpy(&serverstats->contact.sin_addr, &from_addr, sizeof(struct in_addr));
  }
  memcpy(&ss->contact.sin_addr, &serverstats->contact.sin_addr,
	 sizeof(struct in_addr));

}

#else /* Darwin */
#ifdef BSD /* If BSD */
#include <machine/param.h>
#include <sys/types.h>
#include <sys/sysctl.h>
#include <vm/vm_param.h>
#include <sys/vmmeter.h>
#include <sys/dkstat.h>
static int usermem, ncpu, ourpagesize;
#ifdef KERN_CPUSTATS
static struct cpustats old, new;
#endif
void initstat(void) {
  int mib[2];
  size_t len;
  mib[0] = CTL_HW;
  mib[1] = HW_USERMEM;
  len = sizeof(int);
  sysctl(mib, 2, &usermem, &len, NULL, 0);
  mib[1] = HW_NCPU;
  sysctl(mib, 2, &ncpu, &len, NULL, 0);
  mib[1] = HW_PAGESIZE;
  sysctl(mib, 2, &ourpagesize, &len, NULL, 0);
#ifdef KERN_CPUSTATS
  mib[0] = CTL_KERN;
  mib[1] = KERN_CPUSTATS;
  len = sizeof(struct cpustats);
  sysctl(mib, 2, &old, &len, NULL, 0);
#endif
}
static void fillstat(serverstat *ss, server_rec *s,
		     struct in_addr from_addr, unsigned int webport) {
  int mib[2], i;
  size_t len;
  float ourcpu=0.0;
  struct loadavg ourload;
  struct vmtotal ourmem;
#ifdef KERN_CPUSTATS
  mib[0] = CTL_KERN;
  mib[1] = KERN_CPUSTATS;
  len = sizeof(struct cpustats);
  sysctl(mib, 2, &new, &len, NULL, 0);
  for(i=0;i<CPUSTATES;i++) ourcpu+=(new.cp_time[i]-old.cp_time[i]);
  ourcpu = 1.0 - (float)(new.cp_time[CP_IDLE]-old.cp_time[CP_IDLE])/ourcpu;
  ourcpu *= 1000.0;
#else
  ourcpu = 0;
#endif
  mib[0] = CTL_VM;
  mib[1] = VM_LOADAVG;
  len = sizeof(struct loadavg);
  sysctl(mib, 2, &ourload, &len, NULL, 0);
  ss->load = (int)1000.0*((float)ourload.ldavg[0]/(float)ourload.fscale);
  ss->load_hwm=set_high_watermark()*1000;
  ss->tmem=(int)usermem/(1024*1024); /* in mb */
#ifdef VM_TOTAL
  mib[1] = VM_TOTAL;
#else
#ifdef VM_METER
  mib[1] = VM_METER;
#else
#error VM_METER and VM_TOTAL are not here.
#endif
#endif
  len = sizeof(struct vmtotal);
  sysctl(mib, 2, &ourmem, &len, NULL, 0);
  ourmem.t_free /= 1024*1024; /* calculate in mb */
  ss->amem=(int)usermem-(ourpagesize*ourmem.t_free);
  ss->cpu =(int)ourcpu;
  ss->ncpu=(int)ncpu;
  /* Fill out hostname */
  strncpy(ss->hostname, s->server_hostname, 40);
  ss->hostname[39]='\0';
  if(!ss->contact.sin_port)
    if(webport) {
      ss->contact.sin_port = webport;
    } else {
      ss->contact.sin_port = ap_listeners->local_addr.sin_port;
    }
  ss->nservers=0;
  ss->aservers=0;
  if(ap_exists_scoreboard_image()) {
    for(i=0;i<HARD_SERVER_LIMIT;i++) {
      if(ap_scoreboard_image->servers[i].status>=SERVER_READY)
	ss->nservers++;
      if(ap_scoreboard_image->servers[i].status==SERVER_READY)
	ss->aservers++;
    }
  }
  ss->arriba = mod_backhand_personal_arriba;
  if(serverstats->contact.sin_addr.s_addr==0) {
    memcpy(&serverstats->contact.sin_addr, &from_addr, sizeof(struct in_addr));
  }
  memcpy(&ss->contact.sin_addr, &serverstats->contact.sin_addr,
	 sizeof(struct in_addr));
}
#else
#error Platform not supported.. patch it and mail me, or mail me `uname -a`
#endif /* NOT BSD OR OTHER */
#endif /* NOT DARWIN */
#endif /* NOT SOLARIS2 OR OTHER */
#endif /* NOT LINUX OR OTHER */
