/* -*- indent-tabs-mode: t; tab-width: 8; c-basic-offset: 8; -*- */

#include "libisofs/libisofs.h"
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <assert.h>
#include <sys/types.h>
#include <dirent.h>
#include <string.h>

#define SECSIZE 2048

int add_dir(const char *path,
	    struct iso_tree_dir **parent)
{
	DIR *dir;
	struct dirent *ent;
	int wasdir = 0;

	dir = opendir(path);
	if (dir) {
		char *dirname;

		wasdir = 1;

		dirname = strrchr(path, '/');
		if (!dirname)
			parent = iso_tree_add_dir (parent, path, 0);
		else
			parent = iso_tree_add_dir (parent, dirname + 1, 0);

		if (parent) {
			while ((ent = readdir(dir))) {
				char *p;

				if (strcmp(ent->d_name, ".") == 0 ||
				    strcmp(ent->d_name, "..") == 0)
					continue;

				p = malloc(strlen(path) +
					   strlen(ent->d_name) + 2);
				strcpy(p, path);
				p[strlen(path)] = '\\';
				strcpy(p + strlen(path) + 1, ent->d_name);
				if (!add_dir(p, parent)) {
					iso_tree_add_file (parent, p, 0);
				}
				free(p);
			}
		}
		closedir(dir);
	}
	return wasdir;
}

int main(int argc, char **argv)
{
	struct iso_volumeset *volset;
	struct burn_source *src;
	int fd;
	unsigned char buf[SECSIZE];
	enum burn_source_status st;

	if (argc < 2) {
		printf ("must pass target iso filename\n");
		return 1;
	}
	if (argc < 3) {
		printf ("must pass directory to build iso from\n");
		return 1;
	}

	fd = open (argv[1], O_WRONLY | O_CREAT | O_TRUNC, 00777);

	if (fd < 0) {
		printf ("failed to open %s\n", argv[1]);
		return 1;
	}

	{
		char *volume_names[] = { "my volume" };
		volset = iso_volumeset_new (1,
					    "my volume set",
					    volume_names,
					    NULL,
					    NULL,
					    NULL,
					    NULL);
	}

	add_dir (argv[2], iso_volumeset_get_root (volset));

	src = iso_source_new (volset, 0);
	iso_volumeset_free (volset);

	st = iso_source_generate (src, buf, SECSIZE);
	while (!st) {
		int w;
		for (w = 0; w < SECSIZE;) {
			int ret;
			ret = write (fd, buf + w, SECSIZE - w);
			if (ret < 0) {
				printf ("ERROR WRITING FILE\n");
				break;
			}
			w += ret;
		}
		st = iso_source_generate (src, buf, SECSIZE);
	}
	if (st != BURN_SOURCE_EOF) {
		printf ("ERROR IN ISO GENERATION\n");
	}

	burn_source_free (src);

	close (fd);

	return 0;
}
