/***************************************************************************
 $RCSfile: ctdriver_pcsc.c,v $
                             -------------------
    cvs         : $Id: ctdriver_pcsc.c,v 1.11 2003/04/21 03:01:38 aquamaniac Exp $
    begin       : Fri Nov 22 2002
    copyright   : (C) 2001 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef __declspec
# if BUILDING_CHIPCARD_DLL
#  define CHIPCARD_API __declspec (dllexport)
# else /* Not BUILDING_CHIPCARD_DLL */
#  define CHIPCARD_API __declspec (dllimport)
# endif /* Not BUILDING_CHIPCARD_DLL */
#else
# define CHIPCARD_API
#endif

#ifdef USE_PCSC

#include "ctdriver_pcsc.h"
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include <string.h>
#include <chameleon/debug.h>



CTDRIVERPCSC_DRIVERDATA *CTDriver_PCSC_DriverData_new() {
  CTDRIVERPCSC_DRIVERDATA *dd;

  DBG_ENTER;
  dd=(CTDRIVERPCSC_DRIVERDATA *)malloc(sizeof(CTDRIVERPCSC_DRIVERDATA));
  assert(dd);
  memset(dd,0,sizeof(CTDRIVERPCSC_DRIVERDATA));
  DBG_LEAVE;
  return dd;
}


void CTDriver_PCSC_DriverData_free(CTDRIVERPCSC_DRIVERDATA *dd) {
  DBG_ENTER;
  if (dd) {
    LibLoader_free(dd->libHandle);
    free(dd);
  }
  DBG_LEAVE;
}


CTDRIVERPCSC_READERDATA *CTDriver_PCSC_ReaderData_new() {
  CTDRIVERPCSC_READERDATA *rd;

  DBG_ENTER;
  rd=(CTDRIVERPCSC_READERDATA *)malloc(sizeof(CTDRIVERPCSC_READERDATA));
  assert(rd);
  memset(rd,0,sizeof(CTDRIVERPCSC_READERDATA));
  DBG_LEAVE;
  return rd;
}


void CTDriver_PCSC_ReaderData_free(CTDRIVERPCSC_READERDATA *rd) {
  DBG_ENTER;
  if (rd)
    free(rd);
  DBG_LEAVE;
}





ERRORCODE CTDriver_PCSC_AllocTerm(CTREADERTABLE *rt){
  DBG_ENTER;
  assert(rt);
  assert(rt->driver);
  assert(rt->driver->driverData);
  rt->driverData=CTDriver_PCSC_ReaderData_new();
  DBG_LEAVE;
  return 0;
}


ERRORCODE CTDriver_PCSC_ReleaseTerm(CTREADERTABLE *rt){
  DBG_ENTER;
  assert(rt);
  assert(rt->driver);
  assert(rt->driver->driverData);
  CTDriver_PCSC_ReaderData_free(rt->driverData);
  rt->driverData=0;
  DBG_LEAVE;
  return 0;
}


ERRORCODE CTDriver__PCSC_ReadStatus(CTREADERTABLE *rt,
				    int *newState,
				    char *atrbuffer,
				    int *atrbufferlen){
  DWORD atrlen;
  LONG scret;
  char namebuffer[256];
  DWORD namelen;
  DWORD state;
  DWORD proto;
  CTDRIVERPCSC_DRIVERDATA *dd;
  CTDRIVERPCSC_READERDATA *rd;

  DBG_ENTER;
  assert(rt);
  assert(rt->driver);
  assert(rt->driver->driverData);
  assert(rt->driverData);
  assert(rt->descr);

  dd=(CTDRIVERPCSC_DRIVERDATA *)rt->driver->driverData;
  rd=(CTDRIVERPCSC_READERDATA *)rt->driverData;

  DBG_DEBUG("Reading status (Proto: %d)", (unsigned int)(rd->protocol));
  *newState=0;
  namelen=sizeof(namebuffer);
  atrlen=*atrbufferlen;
  scret=(*(dd->status))(rd->cardhandle,
			namebuffer,
			&namelen,
			&state,
			&proto,//&rd->protocol,
			atrbuffer,
			&atrlen);
  if (scret!=SCARD_S_SUCCESS) {
    DBG_NOTICE("SCard error: %08x",(unsigned int)scret);
    /* give back the card handle if we still have one */
    if (rd->cardhandle) {
      DBG_DEBUG("Disconnected handle %08x",
		(unsigned int)(rd->cardhandle));
      (*(dd->disconnect))(rd->cardhandle,SCARD_RESET_CARD);
    }
    rd->cardhandle=0;
    rt->openCount=0;
    rt->cardChanged++;
    return Error_New(0,
		     ERROR_SEVERITY_ERR,
		     Error_FindType(CTCORE_ERROR_TYPE),
		     CTCORE_ERROR_DRIVER_IO);
  }
  else {
    DBG_DEBUG("Reader status is %04x (Protocol: %d)",
	      (unsigned int)state,
	      (unsigned int)(proto));
    *atrbufferlen=atrlen;

    /* check for processor card */
    if (proto==SCARD_PROTOCOL_T0 ||
	proto==SCARD_PROTOCOL_T1)
      *newState|=CTREADERSTATUS_PROCESSOR;
    else
      *newState&=~CTREADERSTATUS_PROCESSOR;

    if (state & SCARD_PRESENT) {
      DBG_DEBUG("Card is inserted");
      *newState|=CTREADERSTATUS_INSERTED;
    }
    else {
      DBG_DEBUG("Card is not inserted");
    }
    if (state & SCARD_POWERED) {
      DBG_DEBUG("Card is connected");
      *newState|=CTREADERSTATUS_CONNECTED;
    }
    else {
      DBG_DEBUG("Card is not connected");
    }
    if (!(*newState & CTREADERSTATUS_CONNECTED)) {
      DBG_INFO("Card status changed to DISCONNECTED");
      /* give back the card handle if we still have one */
      if (rd->cardhandle) {
	DBG_DEBUG("Disconnecting handle %08x",
		  (unsigned int)(rd->cardhandle));
	(*(dd->disconnect))(rd->cardhandle,SCARD_LEAVE_CARD);
      }
      rd->cardhandle=0;
      rt->openCount=0;
      rt->cardChanged++;
    }
  }
  return 0;
}


ERRORCODE CTDriver__PCSC_ConnectTerm(CTREADERTABLE *rt){
  CTDRIVERPCSC_DRIVERDATA *dd;
  CTDRIVERPCSC_READERDATA *rd;
  LONG scret;

  DBG_ENTER;
  assert(rt);
  assert(rt->driver);
  assert(rt->driver->driverData);
  assert(rt->driverData);
  assert(rt->descr);

  dd=(CTDRIVERPCSC_DRIVERDATA *)rt->driver->driverData;
  rd=(CTDRIVERPCSC_READERDATA *)rt->driverData;

  if (rt->openCount<1) {
    assert(rd->cardhandle==0);
    scret=(*(dd->connect))(dd->context,
			   rt->descr->name,
			   SCARD_SHARE_EXCLUSIVE,
			   SCARD_PROTOCOL_ANY,
			   &rd->cardhandle,
			   &rd->protocol);

    if (scret!=SCARD_S_SUCCESS) {
      DBG_ERROR("Could not connect (%08x)",(unsigned int)scret);
      rt->openCount=0;
      DBG_LEAVE;
      return Error_New(0,
		       ERROR_SEVERITY_ERR,
		       Error_FindType(CTCORE_ERROR_TYPE),
		       CTCORE_ERROR_DRIVER_IO);
    }
  }
  else {
    /* card already was connected, so reconnect it (reset) */
    scret=(*(dd->reconnect))(rd->cardhandle,
			     SCARD_SHARE_EXCLUSIVE,
			     SCARD_PROTOCOL_ANY,
			     SCARD_RESET_CARD,
			     &rd->protocol);
    if (scret!=SCARD_S_SUCCESS) {
      DBG_ERROR("Could not reconnect (%08x)",(unsigned int)scret);
      rt->openCount=0;
      if (rd->cardhandle) {
	DBG_DEBUG("Disconnecting handle %08x",
		  (unsigned int)(rd->cardhandle));
	(*(dd->disconnect))(rd->cardhandle,SCARD_LEAVE_CARD);
      }
      DBG_LEAVE;
      return Error_New(0,
		       ERROR_SEVERITY_ERR,
		       Error_FindType(CTCORE_ERROR_TYPE),
		       CTCORE_ERROR_DRIVER_IO);

    }
  }

  rt->openCount++;
  DBG_DEBUG("Protocol is: %d (OpenCount: %d)",
	    (unsigned int)(rd->protocol),rt->openCount);

  DBG_LEAVE;
  return 0;
}


ERRORCODE CTDriver_PCSC_DisconnectTerm(CTREADERTABLE *rt){
  CTDRIVERPCSC_DRIVERDATA *dd;
  CTDRIVERPCSC_READERDATA *rd;
  LONG scret;
  int oc;

  DBG_ENTER;
  assert(rt);
  assert(rt->driver);
  assert(rt->driver->driverData);
  assert(rt->driverData);
  dd=(CTDRIVERPCSC_DRIVERDATA *)rt->driver->driverData;
  rd=(CTDRIVERPCSC_READERDATA *)rt->driverData;

  oc=rt->openCount--;
  if (rt->openCount<0)
    rt->openCount=0;

  rt->openCount=0;
  if (oc>0) {
    scret=(*(dd->disconnect))(rd->cardhandle,
			      SCARD_LEAVE_CARD);
    rd->cardhandle=0;
    if (scret!=SCARD_S_SUCCESS) {
      DBG_ERROR("SCard error: %08x",(unsigned int)scret);
      DBG_LEAVE;
      return Error_New(0,
		       ERROR_SEVERITY_ERR,
		       Error_FindType(CTCORE_ERROR_TYPE),
		       CTCORE_ERROR_DRIVER_IO);
    }
  }
  DBG_LEAVE;
  return 0;
}


ERRORCODE CTDriver_PCSC_ConnectTerm(CTREADERTABLE *rt,
				    char *atrbuffer,
				    int *atrbufferlen){
  CTDRIVERPCSC_DRIVERDATA *dd;
  CTDRIVERPCSC_READERDATA *rd;
  int newState;
  ERRORCODE err;

  DBG_ENTER;
  assert(rt);
  assert(rt->driver);
  assert(rt->driver->driverData);
  assert(rt->driverData);
  assert(rt->descr);

  dd=(CTDRIVERPCSC_DRIVERDATA *)rt->driver->driverData;
  rd=(CTDRIVERPCSC_READERDATA *)rt->driverData;

  err=CTDriver__PCSC_ConnectTerm(rt);
  if (!Error_IsOk(err)) {
    DBG_ERROR_ERR(err);
    DBG_LEAVE;
    rt->openCount=0;
    return err;
  }
  rt->cardChanged=0;

  /* get the status. This checks whether we really are connected and
   * it gets us the ATR of the card */
  err=CTDriver__PCSC_ReadStatus(rt,
				&newState,
				atrbuffer,
				atrbufferlen);
  if (!Error_IsOk(err)) {
    ERRORCODE err2;

    DBG_ERROR_ERR(err);
    err2=CTDriver_PCSC_DisconnectTerm(rt);
    if (!Error_IsOk(err2)) {
      DBG_ERROR_ERR(err2);
    }
    DBG_LEAVE;
    return err;
  }
  else {
    rt->deltaStatus=(rt->lastStatus^newState);
    rt->lastStatus=newState;
    if (rt->deltaStatus) {
      DBG_INFO("Status changed");
    }
  }

  DBG_LEAVE;
  return 0;
}




ERRORCODE CTDriver_PCSC_StatTerm(CTREADERTABLE *rt,
				 char *atrbuffer,
				 int *atrbufferlen){
  CTDRIVERPCSC_DRIVERDATA *dd;
  CTDRIVERPCSC_READERDATA *rd;
  ERRORCODE err;
  int newState;

  DBG_ENTER;
  assert(rt);
  assert(rt->driver);
  assert(rt->driver->driverData);
  assert(rt->driverData);
  assert(rt->descr);

  dd=(CTDRIVERPCSC_DRIVERDATA *)rt->driver->driverData;
  rd=(CTDRIVERPCSC_READERDATA *)rt->driverData;
  newState=0;

  if (rt->openCount==0) {
    /* we have no handle, so try to get one */
    DBG_DEBUG("Using SCardConnect");
    err=CTDriver__PCSC_ConnectTerm(rt);
    if (!Error_IsOk(err)) {
      DBG_DEBUG("Card not connectable, so maybe not properly inserted");
      newState=0;
    }
    else
      newState=CTREADERSTATUS_INSERTED | CTREADERSTATUS_CONNECTED;
  }

  if (rt->openCount>0) {
    /* we already have a handle, so get the status directly */
    DBG_DEBUG("Already open, will read status");
    err=CTDriver__PCSC_ReadStatus(rt,
				  &newState,
				  atrbuffer,
				  atrbufferlen);
    if (!Error_IsOk(err)) {
      DBG_DEBUG_ERR(err);
    }
  } /* if already open */

  DBG_DEBUG("===========> New status: %04x, Old Status: %04x",
	    newState,
	    rt->lastStatus);
  rt->deltaStatus=(rt->lastStatus^newState);
  rt->lastStatus=newState;
  if (rt->deltaStatus) {
    DBG_INFO("Status changed");
  }

  DBG_LEAVE;
  return 0;
}


CTREADERDESCRIPTION* CTDriver_PCSC_EnumTerms(CTDRIVERTABLE *dt){
  CTDRIVERPCSC_DRIVERDATA *dd;
  LONG scret;
  CTREADERDESCRIPTION* first;
  CTREADERDESCRIPTION* curr;
  CTREADERDESCRIPTION* last;
  char *names;
  char *pnames;
  DWORD nlen;

  assert(dt);
  assert(dt->driverData);
  dd=(CTDRIVERPCSC_DRIVERDATA *)dt->driverData;

  first=0;
  last=0;
  nlen=0;
  /* check size needed */
  scret=(*(dd->listReaders))(dd->context,
			     NULL,
			     NULL,
			     &nlen);
  if (scret!=SCARD_S_SUCCESS) {
    DBG_ERROR("SCard error: %08x",(unsigned int)scret);
    return 0;
  }
  names=(char*)malloc(nlen);

  scret=(*(dd->listReaders))(dd->context,
			     NULL,
			     names,
			     &nlen);
  if (scret!=SCARD_S_SUCCESS) {
    DBG_ERROR("SCard error: %08x",(unsigned int)scret);
    free(names);
    return 0;
  }

  /* create reader descriptions */
  pnames=names;
  while(*pnames) {
    /* create new description */
    curr=CTCore_ReaderDescr_new();

    /* make it the first one, if this IS the first */
    if (!first)
      first=curr;

    /* fill description */
    if (strlen(dt->name)+1<sizeof(curr->driverName) &&
	strlen(pnames)+1<sizeof(curr->name)) {

      curr->driverType=DriverTypePCSC;
      strcpy(curr->driverName,dt->name);
      strcpy(curr->name, pnames);

      /* append to list */
      if (last) {
	last->next=curr;
	last=curr;
      }
    }
    else {
      DBG_DEBUG("Will not add reader \"%s\"\n",
		pnames);
    }
    /* advance to next name */
    while ((*pnames)!=0)
      pnames++;
    pnames++;
  } // while
  free(names);

  return first;
}


ERRORCODE CTDriver_PCSC_CommandTerm(CTREADERTABLE *rt,
				    const char *sendBuffer,
				    int sendBufferLength,
				    char *recvBuffer,
				    int *recvBufferLength){
  CTDRIVERPCSC_DRIVERDATA *dd;
  CTDRIVERPCSC_READERDATA *rd;
  LONG scret;
  DWORD sblength;
  DWORD rblength;

  DBG_ENTER;
  assert(rt);
  assert(rt->driver);
  assert(rt->driver->driverData);
  assert(rt->driverData);
  assert(rt->descr);

  dd=(CTDRIVERPCSC_DRIVERDATA *)rt->driver->driverData;
  rd=(CTDRIVERPCSC_READERDATA *)rt->driverData;

  if (rt->cardChanged!=0) {
    DBG_NOTICE("Card removed");
    return Error_New(0,
		     ERROR_SEVERITY_ERR,
		     Error_FindType(CTCORE_ERROR_TYPE),
		     CTCORE_ERROR_CARD_REMOVED);
  }

  sblength=sendBufferLength;
  rblength=*recvBufferLength;

  if (sendBuffer[0]==0x20) {
    /* terminal command, so send it via SCardControl */
    DBG_DEBUG("Reader command");
    scret=dd->control(rd->cardhandle,
		      sendBuffer,
		      sblength,
		      recvBuffer,
		      &rblength);
  }
  else {
    /* card command, send it via SCardTransmit */
    SCARD_IO_REQUEST pioSendPci;
    SCARD_IO_REQUEST pioRecvPci;

    DBG_DEBUG("Card command");
    DBG_DEBUG("Using protocol now: %d",(unsigned int)(rd->protocol));
    pioSendPci.dwProtocol=rd->protocol;
    pioSendPci.cbPciLength=sizeof(SCARD_IO_REQUEST);
    pioRecvPci.dwProtocol=rd->protocol;
    pioRecvPci.cbPciLength=sizeof(SCARD_IO_REQUEST);
    scret=dd->transmit(rd->cardhandle,
		       &pioSendPci,
		       sendBuffer,
		       sblength,
		       &pioRecvPci,
		       recvBuffer,
		       &rblength);
  }
  if (scret!=SCARD_S_SUCCESS) {
    DBG_ERROR("SCard error: %08x",(unsigned int)scret);
    DBG_LEAVE;
    return Error_New(0,
		     ERROR_SEVERITY_ERR,
		     Error_FindType(CTCORE_ERROR_TYPE),
		     CTCORE_ERROR_DRIVER_IO);
  }

  /* done */
  *recvBufferLength=rblength;
  DBG_LEAVE;
  return 0;
}





ERRORCODE CTDriver_PCSC_Open(CTDRIVERTABLE *dt,
			     CTREADERDESCRIPTION *rd,
			     CONFIGGROUP *ddescr){
  ERRORCODE err;
  CTDRIVERPCSC_DRIVERDATA *dd;
  LONG scret;

  DBG_ENTER;
  assert(dt);
  assert(rd);

  /* create driver data */
  dd=CTDriver_PCSC_DriverData_new();
  dt->driverData=dd;
  dd->libHandle=LibLoader_new();

  /* load library */
  err=LibLoader_OpenLibrary(dd->libHandle, WINSCARD_LIB);
  if (!Error_IsOk(err)) {
    CTDriver_PCSC_DriverData_free(dd);
    dt->driverData=0;
    return err;
  }

  /* resolve symbols */
  err=LibLoader_Resolve(dd->libHandle,
			"SCardEstablishContext",
			(void*)&dd->establishContext);
  if (!Error_IsOk(err))
    err=LibLoader_Resolve(dd->libHandle,
			  "SCardEstablishContextA",
			  (void*)&dd->establishContext);
  if (!Error_IsOk(err))
    err=LibLoader_Resolve(dd->libHandle,
			  "_SCardEstablishContext",
			  (void*)&dd->establishContext);
  if (!Error_IsOk(err)) {
    LibLoader_CloseLibrary(dd->libHandle);
    CTDriver_PCSC_DriverData_free(dd);
    dt->driverData=0;
    return err;
  }

  err=LibLoader_Resolve(dd->libHandle,
			"SCardReleaseContext",
			(void*)&dd->releaseContext);
  if (!Error_IsOk(err))
    err=LibLoader_Resolve(dd->libHandle,
			  "SCardReleaseContextA",
			  (void*)&dd->releaseContext);
  if (!Error_IsOk(err))
    err=LibLoader_Resolve(dd->libHandle,
			  "_SCardReleaseContext",
			  (void*)&dd->releaseContext);
  if (!Error_IsOk(err)) {
    LibLoader_CloseLibrary(dd->libHandle);
    CTDriver_PCSC_DriverData_free(dd);
    dt->driverData=0;
    return err;
  }

  err=LibLoader_Resolve(dd->libHandle,
			"SCardListReaders",
			(void*)&dd->listReaders);
  if (!Error_IsOk(err))
    err=LibLoader_Resolve(dd->libHandle,
			  "SCardListReadersA",
			  (void*)&dd->listReaders);
  if (!Error_IsOk(err))
    err=LibLoader_Resolve(dd->libHandle,
			  "_SCardListReaders",
			  (void*)&dd->listReaders);
  if (!Error_IsOk(err)) {
    LibLoader_CloseLibrary(dd->libHandle);
    CTDriver_PCSC_DriverData_free(dd);
    dt->driverData=0;
    return err;
  }

  err=LibLoader_Resolve(dd->libHandle,
			"SCardConnect",
			(void*)&dd->connect);
  if (!Error_IsOk(err))
    err=LibLoader_Resolve(dd->libHandle,
			  "SCardConnectA",
			  (void*)&dd->connect);
  if (!Error_IsOk(err))
    err=LibLoader_Resolve(dd->libHandle,
			  "_SCardConnect",
			  (void*)&dd->connect);
  if (!Error_IsOk(err)) {
    LibLoader_CloseLibrary(dd->libHandle);
    CTDriver_PCSC_DriverData_free(dd);
    dt->driverData=0;
    return err;
  }

  err=LibLoader_Resolve(dd->libHandle,
			"SCardDisconnect",
			(void*)&dd->disconnect);
  if (!Error_IsOk(err))
    err=LibLoader_Resolve(dd->libHandle,
			  "SCardDisconnectA",
			  (void*)&dd->disconnect);
  if (!Error_IsOk(err))
    err=LibLoader_Resolve(dd->libHandle,
			  "_SCardDisconnect",
			  (void*)&dd->disconnect);
  if (!Error_IsOk(err)) {
    LibLoader_CloseLibrary(dd->libHandle);
    CTDriver_PCSC_DriverData_free(dd);
    dt->driverData=0;
    return err;
  }

  err=LibLoader_Resolve(dd->libHandle,
			"SCardControl",
			(void*)&dd->control);
  if (!Error_IsOk(err))
    err=LibLoader_Resolve(dd->libHandle,
			  "SCardControlA",
			  (void*)&dd->control);
  if (!Error_IsOk(err))
    err=LibLoader_Resolve(dd->libHandle,
			  "_SCardControl",
			  (void*)&dd->control);
  if (!Error_IsOk(err)) {
    LibLoader_CloseLibrary(dd->libHandle);
    CTDriver_PCSC_DriverData_free(dd);
    dt->driverData=0;
    return err;
  }

  err=LibLoader_Resolve(dd->libHandle,
			"SCardTransmit",
			(void*)&dd->transmit);
  if (!Error_IsOk(err))
    err=LibLoader_Resolve(dd->libHandle,
			  "SCardTransmitA",
			  (void*)&dd->transmit);
  if (!Error_IsOk(err))
    err=LibLoader_Resolve(dd->libHandle,
			  "_SCardTransmit",
			  (void*)&dd->transmit);
  if (!Error_IsOk(err)) {
    LibLoader_CloseLibrary(dd->libHandle);
    CTDriver_PCSC_DriverData_free(dd);
    dt->driverData=0;
    return err;
  }

  err=LibLoader_Resolve(dd->libHandle,
			"SCardReconnect",
			(void*)&dd->reconnect);
  if (!Error_IsOk(err))
    err=LibLoader_Resolve(dd->libHandle,
			  "SCardReconnectA",
			  (void*)&dd->reconnect);
  if (!Error_IsOk(err))
    err=LibLoader_Resolve(dd->libHandle,
			  "_SCardReconnect",
			  (void*)&dd->reconnect);
  if (!Error_IsOk(err)) {
    LibLoader_CloseLibrary(dd->libHandle);
    CTDriver_PCSC_DriverData_free(dd);
    dt->driverData=0;
    return err;
  }

  err=LibLoader_Resolve(dd->libHandle,
			"SCardStatus",
			(void*)&dd->status);
  if (!Error_IsOk(err))
    err=LibLoader_Resolve(dd->libHandle,
			  "SCardStatusA",
			  (void*)&dd->status);
  if (!Error_IsOk(err))
    err=LibLoader_Resolve(dd->libHandle,
			  "_SCardStatus",
			  (void*)&dd->status);
  if (!Error_IsOk(err)) {
    LibLoader_CloseLibrary(dd->libHandle);
    CTDriver_PCSC_DriverData_free(dd);
    dt->driverData=0;
    return err;
  }

  /* establish SCard context */
  scret=(*(dd->establishContext))(SCARD_SCOPE_SYSTEM,
				  NULL,
				  NULL,
				  &(dd->context));
  if (scret!=SCARD_S_SUCCESS) {
    DBG_ERROR("SCard error: %08x",(unsigned int)scret);
    LibLoader_CloseLibrary(dd->libHandle);
    CTDriver_PCSC_DriverData_free(dd);
    return Error_New(0,
		     ERROR_SEVERITY_ERR,
		     Error_FindType(CTCORE_ERROR_TYPE),
		     CTCORE_ERROR_DRIVER_IO);
  }

  /* set functions */
  dt->closeDriver=CTDriver_PCSC_Close;
  dt->statTerm=CTDriver_PCSC_StatTerm;
  dt->allocTerm=CTDriver_PCSC_AllocTerm;
  dt->releaseTerm=CTDriver_PCSC_ReleaseTerm;
  dt->connectTerm=CTDriver_PCSC_ConnectTerm;
  dt->disconnectTerm=CTDriver_PCSC_DisconnectTerm;
  dt->commandTerm=CTDriver_PCSC_CommandTerm;
  dt->enumTerms=CTDriver_PCSC_EnumTerms;
  return 0;
}


ERRORCODE CTDriver_PCSC_Close(CTDRIVERTABLE *dt){
  ERRORCODE err;
  CTDRIVERPCSC_DRIVERDATA *dd;

  assert(dt);
  assert(dt->driverData);
  dd=(CTDRIVERPCSC_DRIVERDATA *)(dt->driverData);
  err=LibLoader_CloseLibrary(dd->libHandle);
  CTDriver_PCSC_DriverData_free(dd);
  dt->driverData=0;

  dt->closeDriver=0;
  dt->statTerm=0;
  dt->allocTerm=0;
  dt->releaseTerm=0;
  dt->connectTerm=0;
  dt->disconnectTerm=0;
  dt->commandTerm=0;
  dt->enumTerms=0;

  if (!Error_IsOk(err))
    return err;

  return 0;
}


#endif /* USE_PCSC */





