/***************************************************************************
  dbmusicvalidator.h  -  description
  -------------------
begin                : Wed Dec 19 2001
copyright            : (C) 2001 by Will DeRousse
email                : badhack@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DBMUSICVALIDATOR_H
#define DBMUSICVALIDATOR_H

#include "dbmusicglobals.h"
#include <iostream.h>
#include <qstring.h>

/**
 * These functions are for parsing a QString for illegal/bad/dangerous/whatever characters
 * and returning something clean or suitable.
 * @short Validating QStrings
 * @author Will DeRousse <badhack@users.sourceforge.net>
 */


/**
 * Parses a QString for characters that a bash interface does not like and replaces them with '_'.
 * @param filename Name of file.
 */
QString validateFilename(const QString&filename);

/**
 * Parses a QString for non-digit characters and converts them to a 1.
 *
 * Good for int submissions to a postgreSQL server
 * @param QString QString containing int value.
 */
QString validateNumQString(QString&string);
/**
 * Parses a QString for non-digit characters and converts them to a 1.
 *
 * Good for int submissions to a PostgreSQL server
 * @param QString QString containing int value.
 */
QString validateNumQString(const QString&string);

/**
 * Parses a QString for ' characters and escapes ('') them.
 *
 * This will prevent postgreSQL from generating errors with ' in the name.
 * For example "INSERT INTO table (name) VALUES ('Apostrophe's')" would generate an error while
 * "INSERT INTO table (name) VALUES ('Apostrohpe''s')" would not.
 * @param QString QString containing value.
 */
QString validateQString(const QString&);

/**
 * Parses a QString for ' characters and escapes (\') them.
 *
 * This will prevent postgreSQL from generating errors with ' in the name.
 * For example "INSERT INTO table (name) VALUES ('Apostrophe's')" would generate an error while
 * "INSERT INTO table (name) VALUES ('Apostrohpe\'s')" would not.
 * @param QString QString containing value.
 */
QString validateQString(QString&);

/**
 * Makes sure the QString is in an acceptable interval type format.
 *@param QString string to verify
 */
QString validateInterval(QString &);

/**
 * Makes sure the QString is in an acceptable interval type format. Const version.
 *@param QString string to verify
 */
QString validateInterval(const QString &);

/**
 * Returns the connect information string used by PostgreSQL.
 *
 *@param QString host
 *@param QString port
 *@param QString dbname
 *@param QString user
 *@param QString password
 */
QString returnConnectInfo(const QString &, const QString &, const QString &, const QString &, const QString &);
#endif
