/***************************************************************************
                          dbmusic.cpp  -  description
                             -------------------
    begin                : Wed Dec 19 2001
    copyright            : (C) 2001 by root
    email                : root@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dbmusic.h"
/* Put here so it's not automatically included by dbinit.h */
#include "dbmusicvalidator.h"

/** Constructor.
 * The connection to the backend is made, and all the QMap caches are filled.
 * <pre>
 * dbMusic *music=new dbMusic("dbname");
 * music->addArtist();
 * delete music;
 * </pre>
 *
 * Initializing a dbMusic object makes the connect. Deleting the object breaks the connect.
 *@param string db name
 */
dbMusic::dbMusic(const QString &name) : PgDatabase(validateQString(name).local8Bit().data())
{
	cerr << "dbMusic instantiated." << endl;

	// initialize our variables
	boxset=new StringHashQMap();
	rboxset=new StringHashQMap();
	artist=new StringHashQMap();
	genremap=new StringHashQMap();
	labelmap=new StringHashQMap();
	typemap=new StringHashQMap();
	methodmap=new StringHashQMap();
	formatmap=new StringHashQMap();
	rformatmap=new StringHashQMap();
	rgenremap=new StringHashQMap();
	rlabelmap=new StringHashQMap();
	rmethodmap=new StringHashQMap();
	rtypemap=new StringHashQMap();

	htmlrep=0;
	s=0;

	// this slows the connection time by a little bit
	// this also causes a lot of I/O right in the beginning.
	// but afterwards, there is close to none.
	// I prefer this method.
	fillArtistQMap();
	fillQMap(KBOXSET);
	fillQMap(KFORMAT);
	fillQMap(KGENRE);
	fillQMap(KLABEL);
	fillQMap(KMETHOD);
	fillQMap(KTYPE);
	fillReverseQMap(KBOXSET);
	fillReverseQMap(KFORMAT);
	fillReverseQMap(KGENRE);
	fillReverseQMap(KLABEL);
	fillReverseQMap(KMETHOD);
	fillReverseQMap(KTYPE);
}
/**
 * Destructor
 */
dbMusic::~dbMusic()
{
}
/** Checks the connection with the database to insure that it is ok.
 *
 * Returns error code.
 */
bool dbMusic::checkConnect( )
{
	// if connection is bad, COnnectionBad() returns true, I want to return the opposite.
	return !ConnectionBad();
}
/** Retrieves the currently opened database version and sets the QString passed.
 *	Returns the error code.
 *
 *@param QString version
 */
int dbMusic::dbVersionLive(QString &z)
{
	sqlstring="SELECT version FROM version";
	cerr << "getVersion: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if ((a=execCheck())<0)
		return VERSION_GET_FAIL;
	z=GetValue(0,0);

	return EVERYTHING_OK;

}
/** Retrieves the database version this library was compiled for and sets the QString passed.
 *
 *Returns the error code.
 *@param QString version
 */
int dbMusic::dbVersionCompat(QString &z)
{
	z=DB_VERSION;
	return EVERYTHING_OK;
}
/** Checks the result of the query or whatever and returns the error code.
 *
 * Returns error code.
 */
int dbMusic::execCheck() const
{
	// checks stat for it's value and then returns it.
	switch(stat)
	{
		case PGRES_EMPTY_QUERY:	return DB_EMPTY_QUERY;
		case PGRES_TUPLES_OK:		return DB_TUPLES_OK;
		case PGRES_COMMAND_OK:	return DB_COMMAND_OK;
		case PGRES_BAD_RESPONSE:return DB_BAD_RESPONSE;
		case PGRES_NONFATAL_ERROR:	return DB_NONFATAL_ERROR;
		case PGRES_FATAL_ERROR:	return DB_FATAL_ERROR;
		default:	return DB_UNKNOWN_ERROR;
	};
}
/** Fills the QMap with the name,aid information for the kcombobox in the artisttitle class.
 *
 * Returns error code.
 */
int dbMusic::fillArtistQMap()
{
	cerr << "Filling ArtistQMap" << endl;
	artist->clear();
	stat=Exec("SELECT name,aid from artist ORDER BY name");
	if ((a=execCheck())<0)
		return a;
	int nt=Tuples();
	for (int i=0;i<nt;i++)
		artist->insert(GetValue(i,0),GetValue(i,1));

	return EVERYTHING_OK;
}
/** Fills in the boxset map info. Should be done just after a connect and musicArtistTitle is filled and anytime the boxset table is altered.
 *
 * Returns error code.
 */
int dbMusic::fillQMap(const int &x)
{
	cerr << "Filling category QMap: " << x << endl;
	// based on the const int value passed to me, if will clear the appropriate qmap,
	// exec and then fill up the qmap with the new data.
	switch(x)
	{
		case KBOXSET:
			boxset->clear();
			stat=Exec("SELECT name,grpid FROM boxset");
			break;
		case KFORMAT:
			formatmap->clear();
			stat=Exec("SELECT name,fid FROM format");
			break;
		case KGENRE:
			genremap->clear();
			stat=Exec("SELECT name,gid FROM genre");
			break;
		case KLABEL:
			labelmap->clear();
			stat=Exec("SELECT name,lid FROM label");
			break;
		case KMETHOD:
			methodmap->clear();
			stat=Exec("SELECT name,mid FROM method");
			break;
		case KTYPE:
			typemap->clear();
			stat=Exec("SELECT name,tid FROM type");
			break;
		default:
			return NO_TUPLES;
	};

	if ((a=execCheck())<0)
		return a;
	int nt=Tuples();
	StringHashQMap *temp;
	switch(x)
	{
		case KBOXSET:
			temp=boxset;
			break;
		case KFORMAT:
			temp=formatmap;
			break;
		case KGENRE:
			temp=genremap;
			break;
		case KLABEL:
			temp=labelmap;
			break;
		case KMETHOD:
			temp=methodmap;
			break;
		case KTYPE:
			temp=typemap;
			break;
		default:
			return NO_TUPLES;
	};
	for (int i=0;i<nt;i++)
		temp->insert(GetValue(i,0),GetValue(i,1));

	return EVERYTHING_OK;
}
/** Fills the boxset qmap the the data swapped around (required in some instances).
 *
 * Returns error code.
 */
void dbMusic::fillReverseQMap(const int &x)
{
	cerr << "Filling reverse qmap from cache" << endl;
	// for the reverse maps we don't need to query the server, we can just take the
	// original qmap and reverse it.
	StringHashQMap::Iterator it;
	StringHashQMap *forward=0, *reverse=0;

	// assign pointers based on type and then fill the list
	switch(x)
	{
		case KBOXSET:
			forward=boxset;
			reverse=rboxset;
			break;
		case KFORMAT:
			forward=formatmap;
			reverse=rformatmap;
			break;
		case KGENRE:
			forward=genremap;
			reverse=rgenremap;
			break;
		case KLABEL:
			forward=labelmap;
			reverse=rlabelmap;
			break;
		case KMETHOD:
			forward=methodmap;
			reverse=rmethodmap;
			break;
		case KTYPE:
			forward=typemap;
			reverse=rtypemap;
			break;
		default:
			return;
	};

	reverse->clear();
	for( it = forward->begin(); it != forward->end(); ++it )
		reverse->insert(it.data(),it.key());
}
/** Runs VACUUM (optimizer/defrag) on the database.
 *
 * Returns error code.
 */
int dbMusic::opti()
{
	cerr << "opti called" << endl;
	stat=Exec("VACUUM");
	if (execCheck() < 0)
		return VACUUM_FAIL;
	stat=Exec("ANALYZE");
	if (execCheck() < 0)
		return VACUUM_FAIL;
	return EVERYTHING_OK;
}
/** Tests the connection with the db to insure that it is reliable.
 *
 * Returns error code.
 */
int dbMusic::testConnect( )
{
	stat = Exec("BEGIN");
	if ((a=execCheck())>0)
		Exec("COMMIT");
	return a;
}
/** Sets the QString to the total number of artists.
 *
 * Returns error code
 *@param QString Pass a string to have its value set.
 */
int dbMusic::totalArtist(QString &t)
{
	t=QString::number(artist->count());
	cerr << "Total Artists: " << t << endl;
	return EVERYTHING_OK;
}
/** Sets the number of collected titles by the current artist.
 *
 * Returns error code
 *@param QString Artist name
 *@param QString This will get set to the number.
 */
int dbMusic::totalCollectedTitlesByArtist(const QString &x, QString &t)
{
	if (x.isEmpty())
		return TITLE_SUM_FAIL;
	sqlstring="SELECT COUNT(cdid) FROM title WHERE collected=true AND aid=";
	sqlstring.append(artist->find(x).data());
	cerr << "countTitle: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if ((a=execCheck())<0)
		return a;
	t=GetValue(0,0);
	return EVERYTHING_OK;
}
/** Sets the total length of the titles by the current artist.
 *
 * Returns error code
 *@param QString Artist name
 *@param QString This will get set to the number.
 */
int dbMusic::totalLengthByArtist(const QString &x, QString &t)
{
	if (x.isEmpty())
		return TRACK_SUM_FAIL;
	sqlstring="SELECT SUM(cdlen) FROM title WHERE aid=";
	sqlstring.append(artist->find(x).data());
	cerr << "sumTitle: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if ((a=execCheck())<0)
		return a;
	t=GetValue(0,0);
	return EVERYTHING_OK;
}
/** Sets the number of titles by the current artist.
 *
 * Returns error code
 *@param QString Artist name
 *@param QString This will get set to the number.
 */
int dbMusic::totalTitlesByArtist(const QString &x, QString &t)
{
	if (x.isEmpty())
		return TITLE_SUM_FAIL;
	sqlstring="SELECT COUNT(cdid) FROM title WHERE aid=";
	sqlstring.append(artist->find(x).data());
	cerr << "countTitle: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if ((a=execCheck())<0)
		return a;
	t=GetValue(0,0);
	return EVERYTHING_OK;
}

//	switch (t)
//	{
//		case KBOXSET:
//			break;
//		case KFORMAT:
//			break;
//		case KGENRE:
//			break;
//		case KLABEL:
//			break;
//		case KMETHOD:
//			break;
//		case KTYPE:
//			break;
//		case KBTE:
//			break;
//		default:
//			return;
//	};
