#!/usr/bin/ruby1.8
require "eptrb"
require 'set'


def deptree( pkg, depth, seen )
  seen << pkg.name()
  puts ' ' * depth + pkg.name()
  pkg.candidateVersion().relations().each { |r|
    if r.type() == Eptrb::AptRelation::Dependency or r.type() == Eptrb::AptRelation::PreDependency
      r.targetPackages().each { |p|
        deptree( p, depth + 1, seen ) unless seen.include?( p.name() )
      }
    end
  }
end

Eptrb::init()
agg = Eptrb::AptAggregator.new()
root = agg.index().packageByName( ARGV[0] )

deptree( root, 0, Set.new() )
