%option noyywrap
%option never-interactive
%option prefix="flyy"
%option outfile="lex.yy.c"

/* Token tree scanner */

%{
#include "config.h"
#include "tt.h"
static TT *tt_cur, *tt_temp;
%}

%x ESCAPE QUOTE1 QUOTE2

%%

"#".*\n                                   /* Eat comments */

"{"[ \n\r\t]*                             { /* Enter sub-branch */
  tt_set_ready(tt_cur, 1);
  tt_temp = tt_cur;
  tt_cur = tt_new();
	tt_add_as_first_child(tt_temp, tt_cur);
}

"}"[ \n\r\t]*                             { tt_cur = tt_get_parent(tt_cur); }

"\""                                      {
  BEGIN(QUOTE1);
  if (tt_is_ready(tt_cur))
	{
	  tt_temp = tt_cur;
		tt_cur = tt_new();
		tt_add_after(tt_temp, tt_cur);
	}
}

"\'"                                      {
  BEGIN(QUOTE2);
  if (tt_is_ready(tt_cur))
	{
	  tt_temp = tt_cur;
		tt_cur = tt_new();
		tt_add_after(tt_temp, tt_cur);
	}
}

[ \n\r\t]+                                { /* Blank space between nodes */
  if (tt_has_data(tt_cur)) tt_set_ready(tt_cur, 1);
}

[^ \n\r\t\\\{\}\"\'\#]+                   { /* Unquoted text */
  if (tt_is_ready(tt_cur))
	{
	  tt_temp = tt_cur;
		tt_cur = tt_new();
		tt_add_after(tt_temp, tt_cur);
	}
  tt_data_append_bytes(tt_cur, flyytext, strlen(flyytext));
}

<QUOTE1>[^\\\"]+                          { /* Quoted text */
  tt_data_append_bytes(tt_cur, flyytext, strlen(flyytext));
}

<QUOTE2>[^\\\']+                          { /* Quoted text */
  tt_data_append_bytes(tt_cur, flyytext, strlen(flyytext));
}

<INITIAL,QUOTE1,QUOTE2>"\\"[0-9a-fA-F]{2} { /* Escaped hex value */
  printf("[hex %s]", flyytext + 1);
}

<INITIAL,QUOTE1,QUOTE2>"\\".              { /* Escaped character */
  if (tt_is_ready(tt_cur))
	{
	  tt_temp = tt_cur;
		tt_cur = tt_new();
		tt_add_after(tt_temp, tt_cur);
	}
  tt_data_append_bytes(tt_cur, flyytext + 1, 1);
}

<QUOTE1>"\""                              { /* End of quote */
  tt_set_ready(tt_cur, 1);
	BEGIN(INITIAL);
}

<QUOTE2>"\'"                              { /* End of quote */
  tt_set_ready(tt_cur, 1);
	BEGIN(INITIAL);
}

%%

TT *tt_scan_from_file(FILE *in)
{
	TT *tt_root;

	flyyin = in;
	tt_root = tt_new();
	tt_cur = tt_new();
	tt_add_as_first_child(tt_root, tt_cur);
	flyylex();
	
	return(tt_root);
}
