/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include "config.h"
#include "flux.h"
#include <sys/time.h>

#if defined(HAVE_GETRUSAGE) && !defined(__CYGWIN__)
# include <sys/resource.h>
# include <unistd.h>
#endif


#if defined(HAVE_GETRUSAGE) && !defined(__CYGWIN__)
struct rusage ru0, ru1;
#else
# warning (Using gettimeofday() for benchmarking)
struct timeval tv0, tv1;
#endif


void bm_start()
{
#if defined(HAVE_GETRUSAGE) && !defined(__CYGWIN__)
  getrusage(RUSAGE_SELF, &ru0);
#else
  gettimeofday(&tv0, 0);
#endif
}


void bm_end()
{
#if defined(HAVE_GETRUSAGE) && !defined(__CYGWIN__)
  getrusage(RUSAGE_SELF, &ru1);
#else
  gettimeofday(&tv1, 0);
#endif
}


double bm_diff_get_usec()
{
#if defined(HAVE_GETRUSAGE) && !defined(__CYGWIN__)
  return((((double) ru1.ru_utime.tv_sec * 1000000.0) + (double) ru1.ru_utime.tv_usec +
          ((double) ru1.ru_stime.tv_sec * 1000000.0) + (double) ru1.ru_stime.tv_usec) -
         (((double) ru0.ru_utime.tv_sec * 1000000.0) + (double) ru0.ru_utime.tv_usec +
          ((double) ru0.ru_stime.tv_sec * 1000000.0) + (double) ru0.ru_stime.tv_usec));
#else
  return((((double) tv1.tv_sec * 1000000.0) + (double) tv1.tv_usec) -
         (((double) tv0.tv_sec * 1000000.0) + (double) tv0.tv_usec));
#endif
}
