/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: FWOptions.cc,v 1.3 2001/12/19 12:46:16 lord Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <fwbuilder/FWOptions.hh>

#include <fwbuilder/Firewall.hh>

using namespace std;
using namespace libfwbuilder;

const char *FWOptions::TYPENAME={"FWOptions"};

FWOptions::FWOptions() 
{
    remStr("comment");
    remStr("name"   );
    remStr("id"     );
}

void FWOptions::fromXML(xmlNodePtr root)
{
    const char *n;
    const char *cont;

    for(xmlNodePtr cur=root->xmlChildrenNode; cur; cur=cur->next)   
    {
        if(cur && !xmlIsBlankNode(cur))    
        {

	    n=FROMXMLCAST(xmlGetProp(cur,TOXMLCAST("name")));
	    assert(n!=NULL);
	    cont=FROMXMLCAST( xmlNodeGetContent(cur) );
	    if (cont)
		setStr(n, cont );
        }
    }
}

xmlNodePtr FWOptions::toXML(xmlNodePtr root)
{
    xmlNodePtr opt;

    xmlNodePtr me = xmlNewChild(root, NULL, 
		xml_name.empty()?STRTOXMLCAST(getTypeName()):STRTOXMLCAST(xml_name), 
				NULL);


    map<string, string>::iterator i;
    for(i=data.begin(); i!=data.end(); ++i)  
    {
        string name  = (*i).first;
        string value = (*i).second;
        
	opt=xmlNewChild(me,NULL,TOXMLCAST("Option"),STRTOXMLCAST(value));
        xmlNewProp(opt, TOXMLCAST("name") , STRTOXMLCAST(name));
    }
    return me;
}

bool FWOptions::isDefault() { return false; }


const char *HostOptions::TYPENAME  ={"HostOptions"};
HostOptions::HostOptions() : FWOptions() {}

const char *FirewallOptions::TYPENAME  ={"FirewallOptions"};
FirewallOptions::FirewallOptions() : FWOptions() {}

const char *PolicyRuleOptions::TYPENAME={"PolicyRuleOptions"};
PolicyRuleOptions::PolicyRuleOptions(){}

bool PolicyRuleOptions::isDefault() 
{
    bool res=false;
    FWObject *p;

    p=this;
    do {  p=p->getParent();
    } while ( p!=NULL && Firewall::cast(p)==NULL );

    assert(p!=NULL);

    string platform = p->getStr("platform");

    if (platform=="ipfilter") {
	res= ( ! getBool("log_or_block") && 
	       ! getBool("log_body")     &&
	       ! getBool("log_first")    &&
	       ! getBool("icmp_as_dest") &&
	       getStr("action_on_reject").empty() );
    }

    if (platform=="iptables") {

	res= ( getStr("log_prefix").empty()       && 
	       getStr("action_on_reject").empty() && 
	       getInt("limit_value")<=0  &&
	       getBool("stateless")==false );
    }

    return res; 
}

const char *NATRuleOptions::TYPENAME={"NATRuleOptions"};

NATRuleOptions::NATRuleOptions(){}

bool NATRuleOptions::isDefault() 
{
    return false;
}

