/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: RuleElement.cc,v 1.3 2001/12/19 12:47:06 lord Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <fwbuilder/FWObjectDatabase.hh>
#include <fwbuilder/RuleElement.hh>

#include <fwbuilder/IPService.hh>
#include <fwbuilder/Interval.hh>

#include <fwbuilder/FWObjectReference.hh>
#include <fwbuilder/FWServiceReference.hh>
#include <fwbuilder/FWIntervalReference.hh>

#include <fwbuilder/XMLTools.hh>

using namespace std;
using namespace libfwbuilder;

const char *RuleElement::TYPENAME={"RuleElement"};

RuleElement::RuleElement() 
{
    remStr("comment");
    remStr("name");
    remStr("id");

    setBool("neg",false);
}

void RuleElement::fromXML(xmlNodePtr root)
{
    const char *n;

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("neg")));
    if(n)  setStr("neg",n);

    FWObject::fromXML(root);
}

void RuleElement::addRef(FWObject *obj)
{
    FWObject *o=NULL;
    if (isAny()) {
	o=(*(begin()));
	o=(FWReference::cast(o))->getPointer();
    }
    FWObject::addRef(obj);
    if (o!=NULL) removeRef(o);
}

void RuleElement::removeRef(FWObject *obj)
{
    FWObject::removeRef(obj);
    
    if (getChildrenCount()==0) {   // there is nothing left
	obj=obj->getRoot()->getById( getAnyElementId() , true );
	if (obj)  {
	    addRef(obj);
	}
    }
}

bool RuleElement::isAny()
{
    if (getChildrenCount()!=1) return(false);

    FWObject *o;
    vector<FWObject*>::iterator m;
    m=begin();
    if (  (o=(*m))!=NULL ) {
	if ( FWObjectReference::isA(o) ||
	     FWServiceReference::isA(o) ||
	     FWIntervalReference::isA(o) ) {

	    o=(FWReference::cast(o))->getPointer();
	    if (o->getId()==getAnyElementId()) return(true);
	}
    }
    return(false);
}


void RuleElement::setAnyElement()
{
    string any_id=getAnyElementId();
    
    FWObject *any=getRoot()->getById( any_id , true );
    if (any) 
	addRef( any );
}


string RuleElement::getAnyElementId()
{
    return "";
}

/*
 *   Meaning of "source","destination" and "service" can be negated
 */
bool RuleElement::getNeg()
{
    return ( getBool("neg") );
}

void RuleElement::setNeg(bool f) 
{ 
    if (!empty()) setBool("neg",f);
    else          setBool("neg",false);  // it does not make sence to negate nothing
}

void RuleElement::toggleNeg()
{ 
    bool n;
    n=getBool("neg");
    if (!empty()) setBool("neg",!n );
    else          setBool("neg",false);  // it does not make sence to negate nothing
}

const char *RuleElementSrc::TYPENAME={"Src"};
RuleElementSrc::RuleElementSrc() {}
FWReference* RuleElementSrc::createRef( FWObject* obj ){
    return new FWObjectReference(obj);
}
string RuleElementSrc::getAnyElementId() {
    return FWObjectDatabase::db->std.AnyNetworkId;
}

const char *RuleElementDst::TYPENAME={"Dst"};
RuleElementDst::RuleElementDst() {}
FWReference* RuleElementDst::createRef( FWObject* obj ){
    return new FWObjectReference(obj);
}
string RuleElementDst::getAnyElementId() {
    return FWObjectDatabase::db->std.AnyNetworkId;
}



const char *RuleElementSrv::TYPENAME={"Srv"};
RuleElementSrv::RuleElementSrv() {}
FWReference* RuleElementSrv::createRef( FWObject* obj ){
    return new FWServiceReference(obj);
}
string RuleElementSrv::getAnyElementId() {
    return FWObjectDatabase::db->std.AnyIPServiceId;
}

const char *RuleElementOSrc::TYPENAME={"OSrc"};
RuleElementOSrc::RuleElementOSrc() {}
FWReference* RuleElementOSrc::createRef( FWObject* obj ){
    return new FWObjectReference(obj);
}
string RuleElementOSrc::getAnyElementId() {
    return FWObjectDatabase::db->std.AnyNetworkId;
}


const char *RuleElementODst::TYPENAME={"ODst"};
RuleElementODst::RuleElementODst() {}
FWReference* RuleElementODst::createRef( FWObject* obj ){
    return new FWObjectReference(obj);
}
string RuleElementODst::getAnyElementId() {
    return FWObjectDatabase::db->std.AnyNetworkId;
}

const char *RuleElementOSrv::TYPENAME={"OSrv"};
RuleElementOSrv::RuleElementOSrv() {}
FWReference* RuleElementOSrv::createRef( FWObject* obj ){
    return new FWServiceReference(obj);
}
string RuleElementOSrv::getAnyElementId() {
    return FWObjectDatabase::db->std.AnyIPServiceId;
}



const char *RuleElementTSrc::TYPENAME={"TSrc"};
RuleElementTSrc::RuleElementTSrc() {}
FWReference* RuleElementTSrc::createRef( FWObject* obj ){
    return new FWObjectReference(obj);
}
string RuleElementTSrc::getAnyElementId() {
    return FWObjectDatabase::db->std.AnyNetworkId;
}


const char *RuleElementTDst::TYPENAME={"TDst"};
RuleElementTDst::RuleElementTDst() {}
FWReference* RuleElementTDst::createRef( FWObject* obj ){
    return new FWObjectReference(obj);
}
string RuleElementTDst::getAnyElementId() {
    return FWObjectDatabase::db->std.AnyNetworkId;
}

const char *RuleElementTSrv::TYPENAME={"TSrv"};
RuleElementTSrv::RuleElementTSrv()  {}
FWReference* RuleElementTSrv::createRef( FWObject* obj ){
    return new FWServiceReference(obj);
}
string RuleElementTSrv::getAnyElementId() {
    return FWObjectDatabase::db->std.AnyIPServiceId;
}



const char *RuleElementInterval::TYPENAME={"When"};
RuleElementInterval::RuleElementInterval() {}
FWReference* RuleElementInterval::createRef( FWObject* obj ){
    return new  FWIntervalReference(obj);
}
string RuleElementInterval::getAnyElementId() {
    return FWObjectDatabase::db->std.AnyIntervalId;
}















