/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: RuleSet.cc,v 1.3 2001/12/19 12:47:09 lord Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <fwbuilder/FWObjectDatabase.hh>
#include <fwbuilder/RuleSet.hh>
#include <fwbuilder/FWOptions.hh>
#include <fwbuilder/XMLTools.hh>

using namespace std;
using namespace libfwbuilder;
 
const char *RuleSet::TYPENAME={"Ruleset"};

RuleSet::RuleSet()
{
    setName("RuleSet");
    rule_elements=NULL;
}

RuleSet::~RuleSet() {}

Rule* RuleSet::insertRuleAtTop() 
{
    Rule *r=createRule();
    r->setPosition( 0 );
    insert(begin(), r);
    _adopt(r);
    renumberRules();
    createElements(r);
    return(r);
}

Rule* RuleSet::insertRuleBefore(int rule_n) 
{
    Rule *old_rule=getRuleByNum(rule_n);
    Rule *r=createRule();
//    r->setName( old_rule+"a" );    // change the name
    insert_before(old_rule,r);
    renumberRules();
    createElements(r);
    return(r);
}

Rule* RuleSet::appendRuleAtBottom() 
{
    Rule *r=createRule();
//    r->setName("zzzz");  // rule object needs some name
    add( r );            // FWObject::add adds to the end of the list
    renumberRules();
    createElements(r);
    return(r);
}

Rule* RuleSet::appendRuleAfter(int rule_n) 
{
    Rule *old_rule=getRuleByNum(rule_n);
    Rule *r=createRule();
//    r->setName( old_rule+"a" );    // change the name
    insert_after(old_rule,r);
    renumberRules();
    createElements(r);
    return(r);
}

bool RuleSet::deleteRule(int rule_n) 
{
    return deleteRule( getRuleByNum(rule_n) );
}

bool RuleSet::deleteRule(Rule *r) 
{
    if (r!=NULL) {
	remove(r);
	renumberRules();
	return(true);
    }
    return(false);
}

bool RuleSet::moveRuleUp(int rule_n) 
{
    if (rule_n==0) return(false);

    FWObject* o   =getRuleByNum( rule_n );
    FWObject* prev=getRuleByNum( rule_n-1 );

    swapObjects(prev,o);
    renumberRules();
    return(true);
}

bool RuleSet::moveRuleDown(int rule_n) 
{
    if (rule_n > (getRuleSetSize()-2) ) return(false);

    FWObject* o   =getRuleByNum( rule_n );
    FWObject* next=getRuleByNum( rule_n+1 );

    swapObjects(o,next);
    renumberRules();
    return(true);
}

bool RuleSet::disableRule(int rule_n)
{
    FWObject* o   =getRuleByNum( rule_n );

    if (o) {
  	(Rule::cast(o))->disable();
  	return true;
    }
    return false;
}

bool RuleSet::enableRule(int rule_n)
{
    FWObject* o   =getRuleByNum( rule_n );

    if (o) {
  	(Rule::cast(o))->enable();
  	return true;
    }
    return false;
}

bool  RuleSet::isRuleDisabled(int rule_n)
{
    FWObject* o   =getRuleByNum( rule_n );

    if (o)
  	return((Rule::cast(o))->isDisabled());
    return false;
}


/*
 * Rule number src_rule_n moves right above rule number dst_rule_n
 */
bool RuleSet::moveRule(int src_rule_n, int dst_rule_n) 
{
      FWObject* src =getRuleByNum( src_rule_n );
      FWObject* dst =getRuleByNum( dst_rule_n );

      if (src!=NULL &&  dst!=NULL && src!=dst ) {

  	FWObject *o;
  	vector<FWObject*>::iterator m, m1, m2;
  	for (m=begin(); m!=end(); ++m) {
  	    if ( (o=(*m))!=NULL ) {
  		if ( o==src ) m1=m;
  		if ( o==dst ) m2=m;
  	    }
  	}
  	if ( (*m1)!=NULL && (*m2)!=NULL ) {
  	    erase(m1);
  	    insert(m2,src);
  	}
  	renumberRules();
  	return(true);
      }
    return(false);
}

void RuleSet::renumberRules()
{
    FWObject *o;
    vector<FWObject*>::iterator m;
    int rn;

    for (rn=0,m=begin(); m!=end(); ++rn,++m) {
	if ( (o=(*m))!=NULL && Rule::cast(o)!=NULL )   
	    (Rule::cast(o))->setPosition( rn );
    }
}

Rule* RuleSet::getRuleByNum(int n)
{
    FWObject *o;
    vector<FWObject*>::iterator m;
    Rule     *r;

    for (m=begin(); m!=end(); ++m) {
	if ( (o=(*m))!=NULL ) {
	    r= Rule::cast(o);
	    if (r && r->getPosition()==n) return r;
	}
    }
    return NULL;
}


size_t RuleSet::countElements()
{
    int n;
    const char** cptr;
    for (n=0,cptr=rule_elements; *cptr; ++cptr) ++n;
    return n;
}

int RuleSet::getRuleSetSize()
{
    return getChildrenCount();
}

void RuleSet::getElements(list<const char*>& elements)
{
    for (const char** cptr=rule_elements; *cptr; cptr++) 
	elements.push_back( *cptr );
}


Rule*   RuleSet::createRule()
{
    return NULL;
}

/*
 *  There are two types of elements: those which have children
 *  objects created for them (RuleElement does exist and holds all 
 *  the data for this element) and those which do not have children
 *  objects (RuleElement does not exist and all the data is stored
 *  in properties of Rule object)
 *
 *  Examples of elements of the first kind are "Src", "Dst", "Srv", "Interval"
 *  Examples of elements of the second kind are "Act", "Log", "Com".
 *
 */

void  RuleSet::createElements(Rule* rule)
{
    for (const char** cptr=rule_elements; *cptr; cptr++) {
	if (strcmp(*cptr,"Act")==SAME ||
	    strcmp(*cptr,"Dir")==SAME ||
	    strcmp(*cptr,"Log")==SAME ||
	    strcmp(*cptr,"Opt")==SAME ||
	    strcmp(*cptr,"Com")==SAME ) continue;
	rule->createAndAddRuleElement( *cptr );
    }
}
