/**
 * @file libgalago-gtk/galago-gtk-person-list.h
 *       Person list widget
 *
 * @Copyright (C) 2005-2006 Christian Hammond.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_GTK_PERSON_LIST_H_
#define _GALAGO_GTK_PERSON_LIST_H_

typedef struct _GalagoGtkPersonList      GalagoGtkPersonList;
typedef struct _GalagoGtkPersonListClass GalagoGtkPersonListClass;
typedef struct _GalagoGtkPersonListPriv  GalagoGtkPersonListPriv;

#include <libgalago/galago.h>
#include <gtk/gtktreeview.h>

#define GALAGO_GTK_TYPE_PERSON_LIST (galago_gtk_person_list_get_type())
#define GALAGO_GTK_PERSON_LIST(obj) \
		(G_TYPE_CHECK_INSTANCE_CAST((obj), GALAGO_GTK_TYPE_PERSON_LIST, GalagoGtkPersonList))
#define GALAGO_GTK_PERSON_LIST_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_CAST((klass), GALAGO_GTK_TYPE_PERSON_LIST, GalagoGtkPersonListClass))
#define GALAGO_GTK_IS_PERSON_LIST(obj) \
		(G_TYPE_CHECK_INSTANCE_TYPE((obj), GALAGO_GTK_TYPE_PERSON_LIST))
#define GALAGO_GTK_IS_PERSON_LIST_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_TYPE((klass), GALAGO_GTK_TYPE_PERSON_LIST))
#define GALAGO_GTK_PERSON_LIST_GET_CLASS(obj) \
		(G_TYPE_INSTANCE_GET_CLASS ((obj), GALAGO_GTK_TYPE_PERSON_LIST, GalagoGtkPersonListClass))

struct _GalagoGtkPersonList
{
	GtkTreeView parent_object;

	GalagoGtkPersonListPriv *priv;

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

struct _GalagoGtkPersonListClass
{
	GtkTreeViewClass parent_class;

	/* Signals */
	void (*selection_changed)(GalagoGtkPersonList *person_list);
	void (*person_activated)(GalagoGtkPersonList *person_list,
							 GalagoPerson *person);

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

G_BEGIN_DECLS

GType galago_gtk_person_list_get_type(void);

GtkWidget *galago_gtk_person_list_new(void);

void galago_gtk_person_list_set_person(GalagoGtkPersonList *list,
									   GalagoPerson *account);
void galago_gtk_person_list_set_show_offline(GalagoGtkPersonList *list,
                                             gboolean show_offline);

GalagoPerson *galago_gtk_person_list_get_person(
	const GalagoGtkPersonList *list);
gboolean galago_gtk_person_list_get_show_offline(
	const GalagoGtkPersonList *list);

G_END_DECLS

#endif /* _GALAGO_GTK_PERSON_LIST_H */
