/*******************************************************************************************************************************************
 cstring.h
 '\0' terminated characters array.
*******************************************************************************************************************************************/

#ifndef __CSTRING_H__
#define __CSTRING_H__

#include <string.h>
#include <ctype.h>
#include "nservices.h"

// CString buffer type definition
class CString; typedef NServices::TBuffer <CString> CStrings;

//-------------------------------------------------------------------------------------------------------------------------------------------
// CString
//-------------------------------------------------------------------------------------------------------------------------------------------
class CString
{
	// instanciation section
	public :

		CString				(const char * =NULL);
		CString				(const char);
		CString				(const CString &);
		CString				(const long);
		CString				(const unsigned long);
		CString				(const double);
		virtual ~CString		();

	// characters array functions
	public :

		size_t				GetLength	() const;
		char *				Get		(const size_t inIndex=0) const;

		CString &			FGets		(const size_t inMax=512, FILE * =stdin);

		virtual void			Insert		(const char, const size_t);
		virtual void			Insert		(const CString &, const size_t);
		
		virtual void			Delete		(const char);
		virtual void			Delete		(const CString &);
		virtual void			Delete		(const size_t inStartIndex, const size_t inLength);

		virtual bool			Find		(const char, const size_t inStartIndex=0, size_t *outIndex=NULL) const;
		virtual bool			Find		(const CString &, const size_t inStartIndex=0, size_t *outIndex=NULL) const;

		virtual CStrings		Cut		(const CString &, const bool inAbsorbEmptyField=false) const;
		virtual void			Substitute	(const CString &inOld, const CString &inNew);

		virtual CStrings		GetLines	(const bool inAbsorbEmptyLine=false) const;

		virtual void			Sort		();

		virtual Bool			ToBool		() const;
		virtual long			ToLong		(const unsigned int inBase=10) const;
		virtual unsigned long		ToULong		(const unsigned int inBase=10) const;
		virtual double			ToDouble	() const;

		virtual CString &		ToLower		();
		virtual CString &		ToUpper		();

	// operators
	public :

		char *				operator []	(const size_t) const;

		bool				operator ==	(const CString &) const;
		bool				operator !=	(const CString &) const;
		
		bool				operator <	(const CString &) const;
		bool				operator <=	(const CString &) const;

		bool				operator >	(const CString &) const;
		bool				operator >=	(const CString &) const;
	
		CString &			operator =	(const CString &);
		
		CString &			operator +=	(const char);
		CString &			operator +=	(const CString &);

		CString &			operator -=	(const char);
		CString &			operator -=	(const CString &);

		CString				operator +	(const char) const;
		CString				operator +	(const CString &) const;
		
		CString				operator -	(const char) const;
		CString				operator -	(const CString &) const;

		friend CString			operator +	(const char *, const CString &);
		friend CString			operator -	(const char *, const CString &);

		friend CString			operator +	(const char,   const CString &);

	// protected section
	protected :

		NServices::TBuffer <char>	String;
};

#endif
