------------------------------------------------------------------------------
--                                                                          --
--                	        G N A T . RAVENSCAR                         --
--                                                                          --
--                      Copyright (C) 2008-2014, AdaCore                    --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

pragma Profile (Ravenscar);
with System;
with Ada.Real_Time;
with Examples;

procedure Test is
   pragma Priority (System.Priority'First);
   In_Param : Examples.Param_T := (1, True);
   T : Ada.Real_Time.Time;
   R1 : Examples.Complex_Request_T (Examples.REQ1);
   R2 : Examples.Complex_Request_T (Examples.REQ2);
   R3 : Examples.Complex_Request_T  (Examples.REQ3);
   Next_Request : Examples.Request_Kind_T := Examples.REQ1;
   use Ada.Real_Time;
begin
   T := Clock;
   loop
      T := T + Milliseconds (4_000);
      delay until T;
      Examples.Simple_Sporadic_Task_1.Release;
      Examples.Sporadic_Server_1.Put_Request (In_Param);
      Examples.Sporadic_Server_With_CallBack_1.Put_Request
        (In_Param,
         Examples.Sporadic_OP3_Callback'Access);
      case Next_Request is
         when Examples.REQ1 =>
            Examples.Multiple_Queue_Sporadic_Server.Put_Request
              (R1, Examples.REQ1);
            Examples.Multiple_Queue_Cyclic_Server.Put_Request
              (R1, Examples.REQ1);
            Next_Request := Examples.REQ2;
         when Examples.REQ2 =>
            R2.REQ2_I := In_Param.I;
            Examples.Multiple_Queue_Sporadic_Server.Put_Request
              (R2, Examples.REQ2);
            Examples.Multiple_Queue_Cyclic_Server.Put_Request
              (R2, Examples.REQ2);
            Next_Request := Examples.REQ3;
         when Examples.REQ3 =>
            R3.REQ3_I := In_Param.I;
            R3.REQ3_B := In_Param.B;
            Examples.Multiple_Queue_Sporadic_Server.Put_Request
              (R3, Examples.REQ3);
            Examples.Multiple_Queue_Cyclic_Server.Put_Request
              (R3, Examples.REQ3);
            Next_Request := Examples.REQ1;
      end case;

      Examples.Timed_Out_Sporadic_Server.Put_Request (In_Param);

      In_Param.I := In_Param.I + 1;
      In_Param.B := not In_Param.B;

   end loop;
end Test;
