/*
 * @(#)ReadUtilUTest.java
 *
 * Copyright (C) 2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.datastore;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.sourceforge.groboutils.autodoc.v1.AutoDoc;


/**
 * Tests the ReadUtil class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:28 $
 * @since     January 22, 2003
 */
public class ReadUtilUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = ReadUtilUTest.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public ReadUtilUTest( String name )
    {
        super( name );
    }


    //-------------------------------------------------------------------------
    // Tests
    
    public void testReadTo1()
    {
        Reader r = new StringReader( "" );
        try
        {
            ReadUtil.readTo( r, 'c' );
        }
        catch (IOException ex)
        {
            assertTrue(
                "Did not reference 'c'.",
                ex.getMessage().indexOf( "'c'" ) >= 0 );
        }
    }
    
    public void testReadTo2() throws Exception
    {
        Reader r = new StringReader( "c" );
        String s = ReadUtil.readTo( r, 'c' );
        assertEquals(
            "Didn't read correct string.",
            "",
            s );
    }
    
    public void testReadTo3() throws Exception
    {
        Reader r = new StringReader( "ccc" );
        String s = ReadUtil.readTo( r, 'c' );
        assertEquals(
            "Didn't read correct string.",
            "",
            s );
    }
    
    public void testReadTo4() throws Exception
    {
        Reader r = new StringReader( "abc" );
        String s = ReadUtil.readTo( r, 'c' );
        assertEquals(
            "Didn't read correct string.",
            "ab",
            s );
    }
    
    public void testReadCount1()
    {
        Reader r = new StringReader( "" );
        try
        {
            ReadUtil.readCount( r, 1 );
        }
        catch (IOException ex)
        {
            assertTrue(
                "Didn't reference count.",
                ex.getMessage().indexOf( " 1 " ) >= 0 );
        }
    }
    
    public void testReadCount2() throws Exception
    {
        Reader r = new StringReader( "a" );
        try
        {
            ReadUtil.readCount( r, 4 );
        }
        catch (IOException ex)
        {
            assertTrue(
                "Didn't reference count.",
                ex.getMessage().indexOf( " 3 " ) >= 0 );
        }
    }
    
    public void testReadCount3() throws Exception
    {
        Reader r = new StringReader( "" );
        String s = ReadUtil.readCount( r, 0 );
        assertEquals(
            "Did not return expected string.",
            "",
            s );
    }
    
    public void testReadCount4() throws Exception
    {
        Reader r = new StringReader( "a" );
        String s = ReadUtil.readCount( r, 1 );
        assertEquals(
            "Did not return expected string.",
            "a",
            s );
    }
    
    public void testReadCount5() throws Exception
    {
        Reader r = new StringReader( "abc" );
        String s = ReadUtil.readCount( r, 1 );
        assertEquals(
            "Did not return expected string.",
            "a",
            s );
    }
    
    public void testReadCount6() throws Exception
    {
        Reader r = new StringReader( "abc" );
        String s = ReadUtil.readCount( r, 3 );
        assertEquals(
            "Did not return expected string.",
            "abc",
            s );
    }

    public void testToInt1() throws Exception
    {
        assertEquals(
            "Didn't convert right.",
            -1,
            ReadUtil.toInt( "-1" ) );
    }

    public void testToInt2() throws Exception
    {
        assertEquals(
            "Didn't convert right.",
            0,
            ReadUtil.toInt( "0" ) );
    }
    
    public void testToInt3()
    {
        try
        {
            ReadUtil.toInt( "" );
        }
        catch (IOException ex)
        {
            // test exception
        }
    }
    
    public void testToInt4()
    {
        try
        {
            ReadUtil.toInt( null );
        }
        catch (IOException ex)
        {
            // test exception
        }
    }
    
    public void testToInt5()
    {
        try
        {
            ReadUtil.toInt( "ab" );
        }
        catch (IOException ex)
        {
            // test exception
        }
    }
    
    public void testToLong1() throws Exception
    {
        assertEquals(
            "Didn't convert right.",
            -1L,
            ReadUtil.toLong( "-1" ) );
    }

    public void testToLong2() throws Exception
    {
        assertEquals(
            "Didn't convert right.",
            0L,
            ReadUtil.toLong( "0" ) );
    }
    
    public void testToLong3()
    {
        try
        {
            ReadUtil.toLong( "" );
        }
        catch (IOException ex)
        {
            // test exception
        }
    }
    
    public void testToLong4()
    {
        try
        {
            ReadUtil.toLong( null );
        }
        catch (IOException ex)
        {
            // test exception
        }
    }
    
    public void testToLong5()
    {
        try
        {
            ReadUtil.toLong( "ab" );
        }
        catch (IOException ex)
        {
            // test exception
        }
    }
    
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();

       
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

