/*******************************************************************************************************************************************
 clabel.h
 
 CClass					CClass
 |--CSerialized				|--CSerialized
    |--CMetaModule			   |--CMetaModule
       |--CObject			      |--CObjectListener
          |--CComponent			         |
	     |--CControl			 |
	        |--CWidget			 |--CWidgetListener
		   |--CLabel			    

 The label widget displays a small amount of text.
*******************************************************************************************************************************************/

#ifndef __CLABEL_H__
#define __CLABEL_H__

#include "ccontainer.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// clabel xml serialization constants
//-----------------------------------------------------------------------------------------------------------------------------------------
// <clabel caption="string">
//    ...
// </clabel>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_LABEL_ELEMENT 		("clabel");
static CString XML_LABEL_ATTR_CAPTION		("caption");

//-----------------------------------------------------------------------------------------------------------------------------------------
// CLabel class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CLabel : public CWidget
{
	// instanciation section
	public :

		CLabel				(CContainer *inOwner=NULL, const CString &inCaption=CString(), 
						 const CWidgetListener *inListener=NULL);
		virtual ~CLabel			();

	// protected requests handling
	protected :

		// gtk widget instanciation and initialization
		virtual GtkWidget *		PerformWidgetInstanciate	();
		virtual void			PerformWidgetInitialize		();

	// CComponent redefinition
	public :

		// expected owner type __metaclasses(CContainer)
		virtual CMetaClasses		OwnerMustBe			() const;

	// label specifics
	public :

		// caption affectation
		virtual void			SetCaption			(const CString &inCaption);
		virtual CString			GetCaption			() const;

		
		// ...


	// serialization overloading
	public :

		// label serialization handling
		virtual void			Serialize			(CXMLElementNode *&ioXMLElementNode, const int inMode)
										 THROWABLE;

	// protected attributes
	protected :

		// label caption
		CString				m_Caption;

		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_DYNAMIC_METACLASS ('labl', CLabel, CWidget);

#endif
