/* GNOME Transcript
 * Copyright (C) 1999 the Free Software Foundation 
 * Authors : Matias Mutchinick
 *           Jos Miguel Ronquillo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */



#include <glib.h>
#include <stdlib.h>
#include "gtrans_ifase_conn.h"


/**
 * The idea is to create one single connection object to homogeneize
 * the call to transaction functions between the client and the 
 * different database backends using plugins.
 */

/*********************************************************************
 * Memory mangment                                                   *
 *********************************************************************/ 

/*
 * gtrans_ifase_conn_alloc
 * Alloc a new GTransIFaseConn *, and set everything to defaults.
 */
GTransIFaseConn *gtrans_ifase_conn_alloc()
{
	GTransIFaseConn *conn;
	
	conn = (GTransIFaseConn *)g_malloc(sizeof(GTransIFaseConn));
	
	conn->db = NULL;
	conn->host = NULL;
	conn->user = NULL;
	conn->pwd = NULL;
	conn->port = NULL;
	conn->conn = NULL;
	
	return conn;
}



/******************************************************************
 * Connection function                                            *
 ******************************************************************/


/*
 * gtrans_ifase_conn_start_conn
 * @conn  : A GTransIFaseConn
 * Start a connection.
 */
/*
GTransIFaseConn *
gtrans_ifase_conn_start_conn(gchar *host,
			     gchar *port,
			     gchar *db,
			     gchar *user,
			     gchar *pwd)
{
	return conn->Connect (host,port,db,user,pwd);
}
*/


/******************************************************************
 * Disconnection function                                         *
 ******************************************************************/


/*
 * gtrans_ifase_conn_finish_conn
 * @conn  : A GTransIFaseConn
 * finish the connection.
 */
void
gtrans_ifase_conn_finish_conn(GTransIFaseConn *conn)
{
	g_return_if_fail(conn != NULL);
	
	conn->Disconnect (conn);
}




/******************************************************************
 * Status function                                                *
 ******************************************************************/


/*
 * gtrans_ifase_conn_status
 * @conn : GTransIFaseConn to a database backend.
 *
 * Check the status of the connection.
 */
gint
gtrans_ifase_conn_status(GTransIFaseConn *conn)
{
	g_return_val_if_fail(conn != NULL,-1);
	
	return conn->Status (conn);
}



/******************************************************************
 * Error Message function                                         *
 ******************************************************************/



/*
 * gtrans_ifase_conn_error_msg
 * @conn : GTRansIFaseConn to a db backend.
 *
 * return the error message of the connection.
 */
gchar *
gtrans_ifase_conn_error_msg(GTransIFaseConn *conn)
{
	g_return_val_if_fail(conn != NULL,
			     g_strdup("Fatal Error : NULL connection"));
	
	return conn->ErrorMsg (conn);	
}

