/* GNOME Transcript
 * Copyright (C) 1999 the Free Software Foundation
 * Authors: Matias Mutchinick
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */



#ifndef __GTRANS_IFASE_RESULT_H__
#define __GTRANS_IFASE_RESULT_H__

#include <glib.h>


/* The result status */
enum {
	GTRANS_IFASE_RESULT_OK    = 0,
	GTRANS_IFASE_RESULT_ERROR = 1
};


/* The result type */
enum {
	GTRANS_IFASE_RESULT_COMMAND = 0,
	GTRANS_IFASE_RESULT_TUPPLES = 1
};




typedef struct __GTransIFaseResult GTransIFaseResult;
struct __GTransIFaseResult {
	
	/* The GList of rows */
	GList         *rows;

	/* The arry of field names */
	gchar        **fields;
	
	/* Status of the result (ok, error) */
	gint           status;

	/* Type of the result (command, tupples) */
	gint           type;
	
	/* Number of rows */
	gint           n_rows;
	/* Number of columns */
	gint           n_cols;
	
	/* Error Message */
	gchar         *errormsg;
};




/************************************************************************
 * Memory managment                                                     *
 ************************************************************************/



/**
 * gtrans_ifase_result_alloc
 *
 * Allocate memory and set some default falues for the GTransIFaseResult.
 * Returns : A pointer to a GTransIFaseResult.
 */
GTransIFaseResult *
gtrans_ifase_result_alloc();



/*
 * gtrans_ifase_result_free
 * @res : The GTransIFaseResult to free.
 *
 * Free all memory used by @res, this functions check
 * that wathever is being freed at the moment is not NULL.
 * The things that are freed are:
 * * @res->fields
 * * @res->rows
 * * @res->errormsg
 */
void
gtrans_ifase_result_free(GTransIFaseResult *res);



/************************************************************************
 * Functions for retriving from a GTransIFaseResult                     *
 ************************************************************************/
	

/**
 * gtrans_ifase_result_get_item
 * @res  : A GTransIFaseResult of a query exec.
 * @row  : number of a row.
 * @col  : number of a column.
 *
 * Get the result item placed at (@row,@col).
 * Returns : A string.
 */
gchar *
gtrans_ifase_result_get_item(GTransIFaseResult  *res,
			     gint                row,
			     gint                col);



/**
 * gtrans_ifase_result_get_row
 * @res  : A GTransIFaseResult of a query exec.
 * @row  : number of a row.
 *
 * Get the @row from the result.
 * Returns : An arry of strings.
 */
gchar **
gtrans_ifase_result_get_row(GTransIFaseResult  *res,
			    gint                row);



/**
 * gtrans_ifase_result_fetch_row
 * @res  : A GTransIFaseResult of a query exec.
 *
 * Fetch the next row from the result.
 * Returns : An arry of strings.
 */
gchar **
gtrans_ifase_result_fetch_row(GTransIFaseResult  *res);



/**
 * gtrans_ifase_result_rewind
 * @res  : A GTransIFaseResult of a query exec.
 *
 * Go to the begining of the result rows
 * in case we must after fetching rows.
 */
void
gtrans_ifase_result_rewind(GTransIFaseResult *res);




/************************************************************************
 * Functions for modifing a GTransIFaseResult                           *
 ************************************************************************/
	

/**
 * gtrans_ifase_result_replace_row
 * @res  : The GTransIFaseResult
 * @row  : The index of a row
 * @data : An arry of string
 *
 * Replace de contents of row @row with @data.
 */
void
gtrans_ifase_result_replace_row(GTransIFaseResult *res,
				gint               row,
				gchar            **data);



/**
 * gtrans_ifase_result_append_row
 * @res  : The GTransIFaseResult
 * @data : An arry of string
 *
 * Append a new row with @data to @res. 
 */
void
gtrans_ifase_result_append_row(GTransIFaseResult *res,
			       gchar            **data);



/**
 * gtrans_ifase_result_remove_row
 * @res  : The GTransIFaseResult
 * @row  : The index of a row
 *
 * Remove the row @row from the result.
 */
void
gtrans_ifase_result_remove_row(GTransIFaseResult *res,
			       gint               row);



/************************************************************************
 * Functions for status and error messages                              *
 ************************************************************************/

/**
 * gtrans_ifase_result_error_msg
 * @res  : The result.
 *
 * Return a pointer to the result error message.
 */
gchar *
gtrans_ifase_result_error_msg(GTransIFaseResult *res);



/**
 * gtrans_ifase_result_status
 * @res  : The result.
 *
 * Return the status of the result.
 */
gint
gtrans_ifase_result_status(GTransIFaseResult *res);



/**
 * gtrans_ifase_result_type
 * @res  : The result.
 *
 * Return the status of the result.
 */
gint
gtrans_ifase_result_type(GTransIFaseResult *res);



#endif /* __GTRANS_IFASE_RESULT_H__ */
