/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: AbstractFaceBuilder.java,v 1.5 2005/05/28 23:11:59 pietschy Exp $
 */

package org.pietschy.command;

import org.w3c.dom.Element;


/**
 * Implementations of this class are used used to construct face instances from the commands
 * configuration file.  Builders can be installed by calling {@link FaceManager#setFaceBuilder}.
 */
public abstract class
AbstractFaceBuilder
extends AbstractBuilder
{
   static final String _ID_ = "$Id: AbstractFaceBuilder.java,v 1.5 2005/05/28 23:11:59 pietschy Exp $";

   /**
    * Constructs a new {@link Face} witht the specified {@link FaceId} and that uses the
    * specified {@link FaceManager} to locate parent faces.
    *
    * @param id          the id of the face.
    * @param faceManager the {@link FaceManager} the face can use to locate its parent.
    * @return a new empty {@link Face}.
    */
   public abstract Face createFace(FaceId id, FaceManager faceManager);

   /**
    * Implementers of this class are responsible for building a {@link Face} element for the
    * specified configuration data.
    *
    * @param face        the face that is to be configured.
    * @param faceElement the face's configuration information.
    */
   public abstract void configure(Face face, Element faceElement);

}
