/*****************************************************************************
 *
 *	Hoard: A Fast, Scalable, and Memory-Efficient Allocator for 
 *	Shared-Memory Multiprocessors.
 *
 *	Portions: Copyright (c) 1998-2001, The University of Texas at Austin.
 *
 *	Portions of this are free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Library General Public License
 *	as published by the Free Software Foundation, http://www.fsf.org.
 *
 *	These portions are distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Library General Public License for more details.
 ****************************************************************************/

#ifndef _NTWRAPPER_H
#define _NTWRAPPER_H

namespace std {
	struct nothrow_t;
};

#include "config.h"

#define _CRTDBG_ALLOC_MEM_DF        0x01  /* Turn on debug allocation */

#define _HEAPOK         (-2)
#define _HEAPEND        (-5)

typedef void(*_CRT_ALLOC_HOOK)(void);
typedef void(*_CRT_DUMP_CLIENT)(void);
typedef int _HEAPINFO;
typedef int _CrtMemState;

extern "C" {

#ifdef _DEBUG

void *	lh__calloc_dbg(size_t num, size_t size, int blockType, const char *filename, int linenumber);
int 		lh__CrtCheckMemory(void);
void 		lh__CrtDoForAllClientObjects(void (*pfn)(void *, void *), void *context);
int 		lh__CrtDumpMemoryLeaks(void);
int 		lh__CrtIsMemoryBlock(const void *userData, unsigned int size, long *requestNumber, char **filename, int *linenumber);
int 		lh__CrtIsValidHeapPointer(const void *userData);
void 		lh__CrtMemCheckpoint(_CrtMemState *state);
int 		lh__CrtMemDifference(_CrtMemState *stateDiff, const _CrtMemState *oldState, const _CrtMemState *newState);
void 		lh__CrtMemDumpAllObjectsSince(const _CrtMemState *state);
void 		lh__CrtMemDumpStatistics(const _CrtMemState *state);
_CRT_ALLOC_HOOK 
			lh__CrtSetAllocHook(_CRT_ALLOC_HOOK allocHook);
long 		lh__CrtSetBreakAlloc(long lBreakAlloc);
int 		lh__CrtSetDbgFlag(int newFlag);
_CRT_DUMP_CLIENT 
			lh__CrtSetDumpClient(_CRT_DUMP_CLIENT dumpClient);
void *	lh__expand_dbg(void *userData, size_t newSize, int blockType, const char *filename, int linenumber);
void 		lh__free_dbg(void *userData, int blockType);
void *	lh__malloc_dbg(size_t size, int blockType, const char *filename, int linenumber);
size_t 	lh__msize_dbg(void *memblock, int blockType);
void * 	lh__realloc_dbg(void *userData, size_t newSize, int blockType, const char *filename, int linenumber);
void * lh_nh_malloc_dbg(size_t sz, size_t, int, int, const char *, int);

#endif	// ? _DEBUG

void *	lh__expand(void *memblock, size_t size);
int 		lh__heapchk(void);
int 		lh__heapmin(void);
int 		lh__heapset(unsigned int fill);
int 		lh__heapwalk(_HEAPINFO *entryinfo);
size_t 	lh__msize(void *memblock);
void * 	lh_calloc(size_t nelem, size_t elsize);
void 		lh_free (void * ptr);
void * 	lh_malloc (size_t sz);
void * 	lh_realloc(void * ptr, size_t sz);

void *  lh_new_nothrow(unsigned int,struct std::nothrow_t const &);
void *  lh_debug_operator_new (unsigned int cb, int, const char *, int);
void    lh_debug_operator_delete (void * p, int, const char *, int);


}	// extern "C"

#endif // _NTWRAPPER_H