#! /bin/sh -pe

# Regression test suite for libhsync.

# Copyright (C) 2000 by Martin Pool
# $Id: test-chain.sh,v 1.14 2000/07/29 18:24:01 mbp Exp $

# OK, this is how we test feeding hsync it's own filth.  Starting
# with an empty signature, we generate the difference from one
# file to another.

diff=$tmpdir/diff.tmp
files=`echo $srcdir/*.c|head -20`
out=$tmpdir/out.tmp
sig=$tmpdir/sig.tmp
newsig=$tmpdir/newsig.tmp

fromsig=$tmpdir/fromsig.tmp
fromlt=$tmpdir/fromlt.tmp
ltfile=$tmpdir/lt.tmp

for from in $files
do
    countdown
    run_test hsnad $debug $stats /dev/null <$from >$ltfile
    run_test hsdecode $debug $stats /dev/null $sig $out $ltfile

    run_test cmp $out $from

    for new in $files
    do
	countdown
        run_test hsnad $debug $stats $sig <$new >$diff
        run_test hsdecode $debug $stats $from $newsig $out $diff 
    
        run_test cmp $out $new
    done
done
    
    
