/*  Inti-GConf: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <inti/main.h>
#include <inti/core.h>
#include <inti/gconf/client.h>
#include <inti/gconf/value.h>
#include <inti/gtk/label.h>

using namespace Inti;

/* SimpleView is very simple program that monitors a single key for changes.
 */

class SimpleView : public Gtk::Window
{
	Pointer<GConf::Client> client;

	Pointer<GConf::Client::NotifySlot> notify_slot;
	unsigned int notify_id;
	
	Gtk::Label *label;

protected:
	void on_key_changed(unsigned int cnxn_id, const GConf::Entry& entry);

public:
	SimpleView();
	virtual ~SimpleView();
};

