/*  Inti-GConf: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  internals.cc - Vector to GSList, private implementation.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "internals.h"
#include "schema.h"

using namespace Inti;

GSList*
GConf::vector_to_gslist(const String& key, const std::vector<int>& list)
{
	g_return_val_if_fail(!list.empty(), 0);
	int count = list.size();
	GSList *tmp_list = 0;

	int i = 0;
	while (i < count)
	{
		tmp_list = g_slist_append(tmp_list, GINT_TO_POINTER(list[i]));
		i++;
	}

 	return tmp_list;
}

GSList* 
GConf::vector_to_gslist(const String& key, const std::vector<bool>& list)
{
	g_return_val_if_fail(!list.empty(), 0);
	int count = list.size();
	GSList *tmp_list = 0;

	int i = 0;
	while (i < count)
	{
		tmp_list = g_slist_append(tmp_list, GINT_TO_POINTER(list[i]));
		i++;
	}

	return tmp_list;
}

GSList* 
GConf::vector_to_gslist(const String& key, const std::vector<double>& list)
{
	g_return_val_if_fail(!list.empty(), 0);
	int count = list.size();
	GSList *tmp_list = 0;

	int i = 0;
	while (i < count)
	{
		tmp_list = g_slist_append(tmp_list, const_cast<double*>(&list[i]));
		i++;
	}

	return tmp_list;
}

GSList*
GConf::vector_to_gslist(const String& key, const std::vector<String>& list)
{
	g_return_val_if_fail(!list.empty(), 0);
	int count = list.size();
	GSList *tmp_list = 0;

	int i = 0;
	while (i < count)
	{
		tmp_list = g_slist_append(tmp_list, const_cast<char*>(list[i].c_str()));
		i++;
	}

	return tmp_list;
}

GSList*
GConf::vector_to_gslist(const String& key, const std::vector<Schema>& list)
{
	g_return_val_if_fail(!list.empty(), 0);
	int count = list.size();
	GSList *tmp_list = 0;

	int i = 0;
	while (i < count)
	{
		tmp_list = g_slist_append(tmp_list, list[i].gconf_schema());
		i++;
	}

	return tmp_list;
}

