/*  Inti-GConf: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

//! @file inti/inti-gconf.h
//! @brief The main Inti-GConf header file.

//! @defgroup gconf_group The GConf Namespace
//! @namespace Inti::GConf
//! @brief GConf module for the Integerated Foundation Classes.
//!
//! Wraps a C++ interface around the GConf database, making it easier
//! for your Inti applications to use GConf.

#ifndef INTI_GCONF_H
#define INTI_GCONF_H

extern const unsigned int inti-gconf_major_version;
//!< libinti-gconf major version  number.

extern const unsigned int inti-gconf_minor_version;
//!< libinti-gconf minor version  number.

extern const unsigned int inti-gconf_micro_version;
//!< libinti-gconf micro version  number.

#endif // INTI_GCONF_H

