#include "demowindow.h"

typedef Slot0<Gtk::Window*> DoSlot;

struct Demo
{
	String title;
	String filename;
	DoSlot *do_slot;
	Demo *children;

	~Demo()
	{
		if (do_slot)
			do_slot->unref();
	}
};

Gtk::Window* do_appwindow();
Gtk::Window* do_button_box();
Gtk::Window* do_changedisplay();
Gtk::Window* do_colorsel();
Gtk::Window* do_dialog();
Gtk::Window* do_drawingarea();
Gtk::Window* do_editable_cells();
Gtk::Window* do_images();
Gtk::Window* do_item_factory();
Gtk::Window* do_list_store();
Gtk::Window* do_menus();
Gtk::Window* do_panes();
Gtk::Window* do_pixbufs();
Gtk::Window* do_sizegroup();
Gtk::Window* do_stock_browser();
Gtk::Window* do_textview();
Gtk::Window* do_tree_store();

Demo child0[] = {
  { "Editable Cells", "editable_cells.cc", slot(&do_editable_cells), 0 },
  { "List Store", "list_store.cc", slot(&do_list_store), 0 },
  { "Tree Store", "tree_store.cc", slot(&do_tree_store), 0 },
  { 0 }
};

Demo testgtk_demos[] = {
  { "Application main window", "appwindow.cc", slot(&do_appwindow), 0 },
  { "Button Boxes", "button_box.cc", slot(&do_button_box), 0 },
  { "Change Display", "changedisplay.cc", slot(&do_changedisplay), 0 },
  { "Color Selector", "colorsel.cc", slot(&do_colorsel), 0 },
  { "Dialog and Message Boxes", "dialog.cc", slot(&do_dialog), 0 },
  { "Drawing Area", "drawingarea.cc", slot(&do_drawingarea), 0 },
  { "Images", "images.cc", slot(&do_images), 0 },
  { "Item Factory", "itemfactory.cc", slot(&do_item_factory), 0 },
  { "Menus", "menus.cc", slot(&do_menus), 0 },
  { "Paned Widgets", "panes.cc", slot(&do_panes), 0 },
  { "Pixbufs", "pixbufs.cc", slot(&do_pixbufs), 0 },
  { "Size Groups", "sizegroup.cc", slot(&do_sizegroup), 0 },
  { "Stock Item and Icon Browser", "stock_browser.cc", slot(&do_stock_browser), 0 },
  { "Text Widget", "textview.cc", slot(&do_textview), 0 },
  { "Tree View", 0, 0, child0 },
  { 0 }
};
