/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  type.cc - TypeInstance implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "type.h"

using namespace Inti;

/*  G::TypeInstance
 */

G::TypeInstance::TypeInstance()
: instance(0)
{
}

G::TypeInstance::~TypeInstance()
{
}

bool
G::TypeInstance::is_a(GType type) const
{ 
	return G_TYPE_CHECK_INSTANCE_TYPE(instance, type);
}

GType 
G::TypeInstance::type() const 
{
	return instance->g_class->g_type; 
}

String
G::TypeInstance::type_name() const 
{
	return g_type_name(type());
}

bool
G::TypeInstance::is_a_type(GType ancestor_type) const 
{ 
	return g_type_is_a(type(), ancestor_type);
}
	
GType
G::TypeInstance::parent_type() const
{
	return g_type_parent(type());
}

void
G::TypeInstance::add_interface(GType interface_type, GInterfaceInitFunc interface_init)
{
	add_interface(type(), interface_type, interface_init);
}

void
G::TypeInstance::add_interface(GType instance_type, GType interface_type, GInterfaceInitFunc interface_init)
{
	const GInterfaceInfo info =
	{
		interface_init,
		(GInterfaceFinalizeFunc) 0,
		0 // interface data
	};

	g_type_add_interface_static(instance_type, interface_type, &info);
}

GType
G::TypeInstance::register_type(GType parent_type, GClassInitFunc class_init)
{
	GType type = 0;
	GTypeQuery query;
	g_type_query(parent_type, &query);

	if (query.type)
	{
		const GTypeInfo info =
		{
			query.class_size,
			(GBaseInitFunc)0,
			(GBaseFinalizeFunc)0,
			class_init,
			0, 0, query.instance_size, 0,
			(GInstanceInitFunc)0
		};

		String type_name("Inti_");
		type_name.append(query.type_name);
		type = g_type_register_static(parent_type, type_name.c_str(), &info, GTypeFlags(0));
	}
	return type;
}

/*  G::TypeInterface
 */

G::TypeInterface::~TypeInterface()
{
}

GTypeInterface*
G::TypeInterface::g_type_interface() const
{
	return peek<GTypeInterface>(G_TYPE_INTERFACE);
}

