/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  accelgroup.cc - GtkAccelGroup C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "accelgroup.h"
#include "private/accelgroup_p.h"

using namespace Inti;

/*  Gtk::accel_groups_activate
 */

bool
Gtk::accel_groups_activate(G::Object& object, const AccelKey& accel_key)
{
	return gtk_accel_groups_activate(object.g_object(), accel_key.key(), GdkModifierType(accel_key.mods()));
}

/*  Gtk::accelerator_get_default_mod_mask
 */

Gdk::ModifierTypeField
Gtk::accelerator_get_default_mod_mask()
{
	return gtk_accelerator_get_default_mod_mask();
}

/*  Gtk::accelerator_set_default_mod_mask
 */

void
Gtk::accelerator_set_default_mod_mask(Gdk::ModifierTypeField default_mod_mask)
{
	gtk_accelerator_set_default_mod_mask((GdkModifierType)default_mod_mask);
}

/*  Gtk::accelerator_valid
 */

bool
Gtk::accelerator_valid(const AccelKey& accel_key)
{
	return gtk_accelerator_valid(accel_key.key(), GdkModifierType(accel_key.mods()));
}

/*  Gtk::accelerator_parse
 */

Gtk::AccelKey
Gtk::accelerator_parse(const char *accelerator, AccelFlagsField accel_flags)
{
	return AccelKey(accelerator, accel_flags);
}

/*  Gtk::accelerator_name
 */

String
Gtk::accelerator_name(const AccelKey& accel_key)
{
	return gtk_accelerator_name(accel_key.key(), GdkModifierType(accel_key.mods()));
}

/*  Gtk::AccelKey
 */

Gtk::AccelKey::AccelKey()
{
	set(0, 0, 0);
}

Gtk::AccelKey::AccelKey(const char *accelerator, AccelFlagsField accel_flags)
{
	set(accelerator, accel_flags);
}

Gtk::AccelKey::AccelKey(unsigned int accel_key, Gdk::ModifierTypeField accel_mods, AccelFlagsField accel_flags)
{
	set(accel_key, accel_mods, accel_flags);
}

Gtk::AccelKey::AccelKey(const AccelKey& src)
{
	key_ = src.key_;
}

Gtk::AccelKey&
Gtk::AccelKey::operator=(const AccelKey& src)
{
	key_ = src.key_;
	return *this;
}

Gtk::AccelKey::operator GtkAccelKey* () const
{
	return this ? gtk_accel_key() : 0;
}

unsigned int
Gtk::AccelKey::key() const
{
	return key_.accel_key;
}

Gdk::ModifierTypeField
Gtk::AccelKey::mods() const
{
	return key_.accel_mods;
}

Gtk::AccelFlagsField
Gtk::AccelKey::flags() const
{
	return key_.accel_flags;
}

void
Gtk::AccelKey::set(const char *accelerator, AccelFlagsField accel_flags)
{
	gtk_accelerator_parse(accelerator, &key_.accel_key, &key_.accel_mods);
	key_.accel_flags = accel_flags;
}

void
Gtk::AccelKey::set(unsigned int accel_key, Gdk::ModifierTypeField accel_mods, AccelFlagsField accel_flags)
{
	key_.accel_key = accel_key;
	key_.accel_mods = (GdkModifierType)accel_mods;
	key_.accel_flags = accel_flags;
}

/*  Gtk::AccelGroup
 */

Gtk::AccelGroup::AccelGroup(GtkAccelGroup *group, bool reference)
: G::Object((GObject*)group, reference)
{
}	

Gtk::AccelGroup::AccelGroup() 
: G::Object((GObject*)AccelGroupClass::create())
{
}	

Gtk::AccelGroup::~AccelGroup() 
{
}
	
GtkAccelGroupClass*
Gtk::AccelGroup::gtk_accel_group_class() const
{ 
	return get_class<GtkAccelGroupClass>(); 
}
	
Gtk::AccelGroup::operator GtkAccelGroup* () const
{
	return this ? gtk_accel_group() : 0;
}

Gtk::AccelGroup*
Gtk::AccelGroup::from_accel_closure(GClosure *closure)
{
	GtkAccelGroup *accel_group = gtk_accel_group_from_accel_closure(closure);
	return accel_group ? G::Object::wrap<AccelGroup>(accel_group) : 0;
}

void
Gtk::AccelGroup::lock()
{
	gtk_accel_group_lock(gtk_accel_group());
}

void
Gtk::AccelGroup::unlock()
{
	gtk_accel_group_unlock(gtk_accel_group());
}

void
Gtk::AccelGroup::connect(const AccelKey& accel_key, GClosure *closure)
{
	gtk_accel_group_connect(gtk_accel_group(), accel_key.key(), GdkModifierType(accel_key.mods()),
	                        GtkAccelFlags(accel_key.flags()), closure);
}

void
Gtk::AccelGroup::connect(const char *accel_path, GClosure *closure)
{
	gtk_accel_group_connect_by_path(gtk_accel_group(), accel_path, closure);
}

bool
Gtk::AccelGroup::disconnect(GClosure *closure)
{
	return gtk_accel_group_disconnect(gtk_accel_group(), closure);
}

bool
Gtk::AccelGroup::disconnect(const AccelKey& accel_key)
{
	return gtk_accel_group_disconnect_key(gtk_accel_group(), accel_key.key(), GdkModifierType(accel_key.mods()));
}

/*  Gtk::AccelGroupClass
 */

void
Gtk::AccelGroupClass::init(GtkAccelGroupClass *g_class)
{
	G::ObjectClass::init((GObjectClass*)g_class);
	g_class->accel_changed = &accel_changed_proxy;
}

GType
Gtk::AccelGroupClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_ACCEL_GROUP, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::AccelGroupClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::AccelGroupClass::accel_changed_proxy(GtkAccelGroup *accel_group, guint keyval, GdkModifierType modifier, GClosure *accel_closure)
{
	AccelGroup *tmp_accel_group = G::Object::pointer<AccelGroup>(accel_group);
	if (tmp_accel_group)
	{
		AccelKey accel_key(keyval, (Gdk::ModifierTypeField)modifier);
		tmp_accel_group->on_accel_changed(accel_key, accel_closure);
	}
	else
	{
		GtkAccelGroupClass *g_class = G::TypeInstance::class_peek_parent<GtkAccelGroupClass>(GTK_ACCEL_GROUP_GET_CLASS(accel_group));
		if (g_class->accel_changed)
			g_class->accel_changed(accel_group, keyval, modifier, accel_closure);
	}
}

/*  Signal handlers
 */

void
Gtk::AccelGroup::on_accel_changed(const AccelKey& accel_key, GClosure *accel_closure)
{
	GtkAccelGroupClass *g_class = class_peek_parent<GtkAccelGroupClass>(gtk_accel_group_class());
	if (g_class->accel_changed)
		g_class->accel_changed(gtk_accel_group(), accel_key.key(), GdkModifierType(accel_key.mods()), accel_closure);
}

/*  Signals
 */

const Gtk::AccelGroup::AccelChangedSignalType Gtk::AccelGroup::accel_changed_signal("accel_changed");

