/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  box.cc - GtkBox, GtkHBox and GtkVBox C++ wrapper implemntation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "box.h"
#include "private/box_p.h"
#include "widget.h"

using namespace Inti;

/*  Gtk::BoxChild
 */
	
Gtk::Widget* 
Gtk::BoxChild::widget() const
{
	return G::Object::wrap<Widget>(child_.widget);
}

/*  Gtk::Box
 */

Gtk::Box::Box(GtkBox *box, bool reference)
: Container((GtkContainer*)box, reference)
{
}

Gtk::Box::Box()
: Container((GtkContainer*)BoxClass::create())
{
}

Gtk::Box::~Box()
{
}

GtkBoxClass*
Gtk::Box::gtk_box_class() const
{
	return get_class<GtkBoxClass>();
}

Gtk::Box::operator GtkBox* () const
{
	return this ? gtk_box() : 0; 
}

bool
Gtk::Box::children(std::vector<BoxChild*>& child_list) const
{
	g_return_val_if_fail(child_list.empty(), false);
	GList *first = gtk_box()->children;
	GList *next = first;

	while (next != 0)
	{
		child_list.push_back(reinterpret_cast<BoxChild*>(next->data));
		next = g_list_next(next);
	}
	return !child_list.empty();
}

bool
Gtk::Box::get_homogeneous() const
{
	return gtk_box_get_homogeneous(gtk_box());
}

int
Gtk::Box::get_spacing() const
{
	return gtk_box_get_spacing(gtk_box());
}

void
Gtk::Box::pack_start(Widget& child, bool expand, bool fill, unsigned int padding)
{
	gtk_box_pack_start(gtk_box(), child.gtk_widget(), expand, fill, padding);
}

void 
Gtk::Box::pack_end(Widget& child, bool expand, bool fill, unsigned int padding)
{
	gtk_box_pack_end(gtk_box(), child.gtk_widget(), expand, fill, padding);
}

void 
Gtk::Box::insert_start(Widget& child, int position, bool expand, bool fill, unsigned int padding)
{
	gtk_box_pack_start(gtk_box(), child.gtk_widget(), expand, fill, padding);
	if (position != -1)
		gtk_box_reorder_child(gtk_box(), child.gtk_widget(), position);
}

void 
Gtk::Box::insert_end(Widget& child, int position, bool expand, bool fill, unsigned int padding)
{
	gtk_box_pack_end(gtk_box(), child.gtk_widget(), expand, fill, padding);
	if (position != -1)
		gtk_box_reorder_child(gtk_box(), child.gtk_widget(), position);
}

void 
Gtk::Box::set_homogeneous(bool homogeneous)
{
	gtk_box_set_homogeneous(gtk_box(), homogeneous);
}

void 
Gtk::Box::set_spacing(int spacing)
{
	gtk_box_set_spacing(gtk_box(), spacing);
}

void 
Gtk::Box::reorder_child(Widget& child, int position)
{
	gtk_box_reorder_child(gtk_box(), child.gtk_widget(), position);
}

void
Gtk::Box::query_child_packing(Widget& child, bool *expand, bool *fill, unsigned int *padding, PackType *pack_type) const
{
	gtk_box_query_child_packing(gtk_box(), child.gtk_widget(), (gboolean*)expand, (gboolean*)fill, padding, (GtkPackType*)pack_type);
}

void
Gtk::Box::set_child_packing(Widget& child, bool expand, bool fill, unsigned int padding, PackType pack_type)
{
	gtk_box_set_child_packing(gtk_box(), child.gtk_widget(), expand, fill, padding, (GtkPackType)pack_type);
}

/*  Gtk::BoxClass
 */

void
Gtk::BoxClass::init(GtkBoxClass *g_class)
{
	ContainerClass::init((GtkContainerClass*)g_class);
}

GType
Gtk::BoxClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_BOX, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::BoxClass::create()
{
	return g_object_new(get_type(), 0);
}

/*  Gtk::Box properties
 */

const Gtk::Box::SpacingPropertyType Gtk::Box::spacing_property("spacing");

const Gtk::Box::HomogeneousPropertyType Gtk::Box::homogeneous_property("homogeneous");

const Gtk::Box::ExpandPropertyType Gtk::Box::expand_property("expand");

const Gtk::Box::FillPropertyType Gtk::Box::fill_property("fill");

const Gtk::Box::PaddingPropertyType Gtk::Box::padding_property("padding");

const Gtk::Box::PackTypePropertyType Gtk::Box::pack_type_property("pack_type");

const Gtk::Box::PositionPropertyType Gtk::Box::position_property("position");

/*  Gtk::HBox
 */

Gtk::HBox::HBox(GtkHBox *hbox, bool reference)
: Box((GtkBox*)hbox, reference)
{
}

Gtk::HBox::HBox(bool homogeneous, int spacing)
: Box((GtkBox*)HBoxClass::create())
{
	set_homogeneous(homogeneous);
	set_spacing(spacing);
}

Gtk::HBox::~HBox()
{
}

GtkHBoxClass* 
Gtk::HBox::gtk_hbox_class() const 
{
	return get_class<GtkHBoxClass>();
}
		
Gtk::HBox::operator GtkHBox* () const 
{ 
	return this ? gtk_hbox() : 0; 
}
	
/*  Gtk::HBoxClass
 */

void
Gtk::HBoxClass::init(GtkHBoxClass *g_class)
{
	BoxClass::init((GtkBoxClass*)g_class);
}

GType
Gtk::HBoxClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_HBOX, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::HBoxClass::create()
{
	return g_object_new(get_type(), 0);
}

/*  Gtk::VBox
 */
 
Gtk::VBox::VBox(GtkVBox *vbox, bool reference)
: Box((GtkBox*)vbox, reference)
{
}

Gtk::VBox::VBox(bool homogeneous, int spacing) 
: Box((GtkBox*)VBoxClass::create())
{
	set_homogeneous(homogeneous);
	set_spacing(spacing);
}

Gtk::VBox::~VBox()
{
}

GtkVBoxClass* 
Gtk::VBox::gtk_vbox_class() const 
{ 
	return get_class<GtkVBoxClass>(); 
}
	
Gtk::VBox::operator GtkVBox* () const 
{ 
	return this ? gtk_vbox() : 0; 
}
	
/*  Gtk::VBoxClass
 */

void
Gtk::VBoxClass::init(GtkVBoxClass *g_class)
{
	BoxClass::init((GtkBoxClass*)g_class);
}

GType
Gtk::VBoxClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_VBOX, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::VBoxClass::create()
{
	return g_object_new(get_type(), 0);
}

