/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  object.cc - GtkObject C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "object.h"
#include "private/object_p.h"

using namespace Inti;

/*  Gtk::Object
 */

Gtk::Object::Object(GtkObject *object, bool reference)
: G::Object((GObject*)object, reference)
{
}

Gtk::Object::Object()
: G::Object((GObject*)ObjectClass::create())
{
}

Gtk::Object::~Object()
{
}

GtkObjectClass*
Gtk::Object::gtk_object_class() const 
{ 	
	return get_class<GtkObjectClass>(); 
}

Gtk::Object::operator GtkObject* () const 
{ 
	return this ? gtk_object() : 0; 
}

void
Gtk::Object::sink()
{
	gtk_object_sink(gtk_object());
}

void
Gtk::Object::ref()
{
	G::Object::ref();
	if (gtk_object()->flags & GTK_FLOATING)
	{
		sink();
		set_referenced(true);
	}
}

void
Gtk::Object::dispose()
{
	if (!(gtk_object()->flags & GTK_IN_DESTRUCTION))
		G::Object::dispose();
}

/*  Gtk::ObjectClass
 */

void
Gtk::ObjectClass::init(GtkObjectClass *g_class)
{
	G::ObjectClass::init((GObjectClass*)g_class);
	g_class->destroy = &destroy_proxy;
}

GType
Gtk::ObjectClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_OBJECT, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::ObjectClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::ObjectClass::destroy_proxy(GtkObject *object)
{
	Object *tmp_object = G::Object::pointer<Object>(object);
	if (tmp_object)
		tmp_object->on_destroy();
	else
	{
		GtkObjectClass *g_class = G::TypeInstance::class_peek_parent<GtkObjectClass>(GTK_OBJECT_GET_CLASS(object));
		if (g_class->destroy)
			g_class->destroy(object);
	}
}

/*  Signal handlers
 */

void
Gtk::Object::on_destroy()
{
	GtkObjectClass *g_class = class_peek_parent<GtkObjectClass>(gtk_object_class());
	if (g_class->destroy)
		g_class->destroy(gtk_object());
}

/*  Properties
 */

const Gtk::Object::UserDataPropertyType Gtk::Object::user_data_property("user_data");

/*  Signals
 */

const Gtk::Object::DestroySignalType Gtk::Object::destroy_signal("destroy");

