/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.kernel.inject.test;

import junit.framework.Test;

import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.test.kernel.inject.support.CallbackTestObject;

/**
 * Cardinality tests.
 *
 * @author <a href="mailto:ales.justin@gmail.com">Ales Justin</a>
 */
public class BadCardinalityCallbackTestCase extends AbstractManualInjectTest
{
   public BadCardinalityCallbackTestCase(String name)
   {
      super(name);
   }

   public static Test suite()
   {
      return suite(BadCardinalityCallbackTestCase.class);
   }

   public void testCallback() throws Throwable
   {
      KernelControllerContext context = getControllerContext("testObject", ControllerState.NOT_INSTALLED);
      assertNull(context.getTarget());
      assertEquals(ControllerState.NOT_INSTALLED, context.getState());

      change(context, ControllerState.CREATE);
      CallbackTestObject injectee = (CallbackTestObject)context.getTarget();
      assertNotNull(injectee);
      assertNull(injectee.getTesterInterfaces());

      KernelControllerContext tester1 = getControllerContext("tester1", ControllerState.NOT_INSTALLED);
      assertNotNull(tester1);
      change(tester1, ControllerState.INSTALLED);

      assertEquals(ControllerState.CONFIGURED, context.getState());
      assertNull(injectee.getTesterInterfaces());

      KernelControllerContext tester2 = getControllerContext("tester2", ControllerState.NOT_INSTALLED);
      assertNotNull(tester2);
      change(tester2, ControllerState.INSTALLED);

      change(context, ControllerState.INSTALLED);
      assertNull(injectee.getTesterInterfaces());
      assertEquals(ControllerState.INSTALLED, context.getState());
   }

}
