package Locales::DB::Language::nb;

# Auto generated from CLDR

$Locales::DB::Language::nb::VERSION = '0.06';

$Locales::DB::Language::nb::cldr_version = '1.7.2';

%Locales::DB::Language::nb::misc_info = (
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => undef,
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'language'                => "Språk\:\ \{0\}",
        'locale'                  => "\{0\}\ \(\{1\}\)",
        'percent'                 => "\#\,\#\#0 \%",
        'territory'               => "Område\:\ \{0\}"
    },
    'fallback'    => [ "nn\ da\ sv\ en" ],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr' => [
            'nei',
            {
                'alt'     => "proposed\-x1001",
                'content' => "nei\:n",
                'draft'   => 'unconfirmed'
            }
        ],
        'yesstr' => [
            'ja',
            {
                'alt'     => "proposed\-x1001",
                'content' => "ja\:j",
                'draft'   => 'unconfirmed'
            }
        ]
    },
);

%Locales::DB::Language::nb::code_to_name = (
    'aa'    => 'afar',
    'ab'    => 'abkhasisk',
    'ace'   => 'achinesisk',
    'ach'   => 'acoli',
    'ada'   => 'adangme',
    'ady'   => 'adyghe',
    'ae'    => 'avestisk',
    'af'    => 'afrikaans',
    'afa'   => "afro\-asiatisk\ språk",
    'afh'   => 'afrihili',
    'ain'   => "ainu\ \(Japan\)",
    'ak'    => 'akan',
    'akk'   => 'akkadisk',
    'ale'   => 'aleutisk',
    'alg'   => "algonkinsk\ språk",
    'alt'   => 'søraltaisk',
    'am'    => 'amharisk',
    'an'    => 'aragonsk',
    'ang'   => 'gammelengelsk',
    'anp'   => 'angika',
    'apa'   => 'apachespråk',
    'ar'    => 'arabisk',
    'arc'   => "klassisk\ arameisk",
    'arn'   => 'araukansk',
    'arp'   => 'arapaho',
    'art'   => "kunstig\ språk",
    'arw'   => 'arawak',
    'as'    => 'assamesisk',
    'ast'   => 'asturisk',
    'ath'   => "athapaskisk\ språk",
    'aus'   => "australsk\ språk",
    'av'    => 'avarisk',
    'awa'   => 'awadhi',
    'ay'    => 'aymara',
    'az'    => 'aserbajdsjansk',
    'ba'    => 'basjkirsk',
    'bad'   => 'bandaspråk',
    'bai'   => "bamilekisk\ språk",
    'bal'   => 'baluchi',
    'ban'   => 'balinesisk',
    'bas'   => "basa\ \(Kamerun\)",
    'bat'   => "baltisk\ språk",
    'be'    => 'hviterussisk',
    'bej'   => 'beja',
    'bem'   => "bemba\ \(Zambia\)",
    'ber'   => 'berbisk',
    'bg'    => 'bulgarsk',
    'bh'    => "biharisk\ språk",
    'bho'   => 'bhojpuri',
    'bi'    => 'bislama',
    'bik'   => 'bicolano',
    'bin'   => 'bini',
    'bla'   => 'siksika',
    'bm'    => 'bambara',
    'bn'    => 'bengalisk',
    'bnt'   => 'bantuspåk',
    'bo'    => 'tibetansk',
    'br'    => 'bretonsk',
    'bra'   => 'braj',
    'bs'    => 'bosnisk',
    'btk'   => 'batakspråk',
    'bua'   => 'buriat',
    'bug'   => 'buginesisk',
    'byn'   => 'blin',
    'ca'    => 'katalansk',
    'cad'   => 'caddo',
    'cai'   => "sentralamerikansk\ indiansk\ språk",
    'car'   => 'galibisk',
    'cau'   => "kaukasisk\ språk",
    'cch'   => 'atsam',
    'ce'    => 'tsjetsjensk',
    'ceb'   => 'cebuansk',
    'cel'   => "keltisk\ språk",
    'ch'    => 'chamorro',
    'chb'   => 'chibcha',
    'chg'   => 'chagatai',
    'chk'   => 'chuukesisk',
    'chm'   => "marisk\ \(Russland\)",
    'chn'   => "chinook\ pidginengelsk",
    'cho'   => 'choctaw',
    'chp'   => 'chipewiansk',
    'chr'   => 'cherokee',
    'chy'   => 'cheyenne',
    'cmc'   => "kamisk\ språk",
    'co'    => 'korsikansk',
    'cop'   => 'koptisk',
    'cpe'   => "engelskbasert\ kreol\-\ eller\ pidginspråk",
    'cpf'   => "franskbasert\ kreol\-\ eller\ pidginspråk",
    'cpp'   => "portugisiskbasert\ kreol\-\ eller\ pidginspråk",
    'cr'    => 'cree',
    'crh'   => 'krimturkisk',
    'crp'   => "kreol\-\ eller\ pidginspråk",
    'cs'    => 'tsjekkisk',
    'csb'   => 'kasjubisk',
    'cu'    => 'kirkeslavisk',
    'cus'   => "kusjitisk\ språk",
    'cv'    => 'tsjuvansk',
    'cy'    => 'walisisk',
    'da'    => 'dansk',
    'dak'   => 'dakota',
    'dar'   => 'dargwa',
    'day'   => "dajakisk\ språk",
    'de'    => 'tysk',
    'de_at' => "østerriksk\ tysk",
    'de_ch' => "sveitsisk\ høytysk",
    'del'   => 'delaware',
    'den'   => 'slavej',
    'dgr'   => 'dogrib',
    'din'   => 'dinka',
    'doi'   => "dogri\-kangri",
    'dra'   => "dravidisk\ språk",
    'dsb'   => 'lavsorbisk',
    'dua'   => 'duala',
    'dum'   => 'mellomnederlandsk',
    'dv'    => 'divehi',
    'dyu'   => 'dyula',
    'dz'    => 'bhutansk',
    'ee'    => 'ewe',
    'efi'   => 'efik',
    'egy'   => 'gammelegyptisk',
    'eka'   => 'ekajuk',
    'el'    => 'gresk',
    'elx'   => 'elamittisk',
    'en'    => 'engelsk',
    'en_au' => "australsk\ engelsk",
    'en_ca' => "canadisk\ engelsk",
    'en_gb' => "britisk\ engelsk",
    'en_us' => "amerikansk\ engelsk",
    'enm'   => 'mellomengelsk',
    'eo'    => 'esperanto',
    'es'    => 'spansk',
    'es_es' => "iberisk\ spansk",
    'et'    => 'estisk',
    'eu'    => 'baskisk',
    'ewo'   => 'ewondo',
    'fa'    => 'persisk',
    'fan'   => 'fang',
    'fat'   => 'fanti',
    'ff'    => 'fulfulde',
    'fi'    => 'finsk',
    'fil'   => 'filippinsk',
    'fiu'   => "finsk\-ugrisk\ språk",
    'fj'    => 'fijiansk',
    'fo'    => 'færøysk',
    'fon'   => 'fon',
    'fr'    => 'fransk',
    'fr_ca' => "canadisk\ fransk",
    'fr_ch' => "sveitsisk\ fransk",
    'frm'   => 'mellomfransk',
    'fro'   => 'gammelfransk',
    'frr'   => 'nordfrisisk',
    'frs'   => 'østfrisisk',
    'fur'   => 'friuliansk',
    'fy'    => 'vestfrisisk',
    'ga'    => 'irsk',
    'gaa'   => 'ga',
    'gay'   => 'gayo',
    'gba'   => 'gbaya',
    'gd'    => "skotsk\ gælisk",
    'gem'   => "germansk\ språk",
    'gez'   => 'ges',
    'gil'   => 'kiribatisk',
    'gl'    => 'galisisk',
    'gmh'   => 'mellomhøytysk',
    'gn'    => 'guarani',
    'goh'   => 'gammelhøytysk',
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gotisk',
    'grb'   => 'grebo',
    'grc'   => 'gammelgresk',
    'gsw'   => 'sveitsertysk',
    'gu'    => 'gujarati',
    'gv'    => 'manx',
    'gwi'   => 'gwichin',
    'ha'    => 'hausa',
    'hai'   => 'haida',
    'haw'   => 'hawaiisk',
    'he'    => 'hebraisk',
    'hi'    => 'hindi',
    'hil'   => 'hiligaynon',
    'him'   => "himachalisk\ språk",
    'hit'   => 'hettittisk',
    'hmn'   => 'hmong',
    'ho'    => "hiri\ motu",
    'hr'    => 'kroatisk',
    'hsb'   => 'høysorbisk',
    'ht'    => 'haitisk',
    'hu'    => 'ungarsk',
    'hup'   => 'hupa',
    'hy'    => 'armensk',
    'hz'    => 'herero',
    'ia'    => 'interlingua',
    'iba'   => 'iban',
    'id'    => 'indonesisk',
    'ie'    => 'interlingue',
    'ig'    => 'ibo',
    'ii'    => "sichuan\-yi",
    'ijo'   => 'ijospråk',
    'ik'    => 'inupiak',
    'ilo'   => 'iloko',
    'inc'   => "indisk\ språk",
    'ine'   => "indo\-europeisk\ språk",
    'inh'   => 'ingusjisk',
    'io'    => 'ido',
    'ira'   => 'iransk',
    'iro'   => "irokansk\ språk",
    'is'    => 'islandsk',
    'it'    => 'italiensk',
    'iu'    => 'inuktitut',
    'ja'    => 'japansk',
    'jbo'   => 'lojban',
    'jpr'   => 'jødepersisk',
    'jrb'   => 'jødearabisk',
    'jv'    => 'javanesisk',
    'ka'    => 'georgisk',
    'kaa'   => 'karakalpakisk',
    'kab'   => 'kabylsk',
    'kac'   => 'kachin',
    'kaj'   => 'jju',
    'kam'   => "kamba\ \(Kenya\)",
    'kar'   => "karensk\ språk",
    'kaw'   => 'kawi',
    'kbd'   => 'kabardisk',
    'kcg'   => 'tyap',
    'kfo'   => 'koro',
    'kg'    => 'kikongo',
    'kha'   => 'khasi',
    'khi'   => 'khoisanspråk',
    'kho'   => 'khotanesisk',
    'ki'    => 'kikuyu',
    'kj'    => 'kuanyama',
    'kk'    => 'kasakhisk',
    'kl'    => 'grønlandsk',
    'km'    => 'kambodjansk',
    'kmb'   => 'kimbundu',
    'kn'    => 'kannada',
    'ko'    => 'koreansk',
    'kok'   => 'konkani',
    'kos'   => 'kosraeansk',
    'kpe'   => 'kpèllé',
    'kr'    => 'kanuri',
    'krc'   => "karachay\-balkar",
    'krl'   => 'karelsk',
    'kro'   => 'kruspråk',
    'kru'   => 'kurukh',
    'ks'    => 'kasjmirsk',
    'ku'    => 'kurdisk',
    'kum'   => 'kumyk',
    'kut'   => 'kutenai',
    'kv'    => 'komi',
    'kw'    => 'kornisk',
    'ky'    => 'kirgisisk',
    'la'    => 'latin',
    'lad'   => 'ladinsk',
    'lah'   => 'lahnda',
    'lam'   => 'lamba',
    'lb'    => 'luxemburgsk',
    'lez'   => 'lezghian',
    'lg'    => 'ganda',
    'li'    => 'limburgisk',
    'ln'    => 'lingala',
    'lo'    => 'laotisk',
    'lol'   => 'mongo',
    'loz'   => 'lozi',
    'lt'    => 'litauisk',
    'lu'    => "luba\-Katanga",
    'lua'   => "luba\-Lulua",
    'lui'   => 'luiseno',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'lushai',
    'lv'    => 'latvisk',
    'mad'   => 'maduresisk',
    'mag'   => 'magahi',
    'mai'   => 'maithili',
    'mak'   => 'makasar',
    'man'   => 'mandingo',
    'map'   => "austronesisk\ språk",
    'mas'   => 'masai',
    'mdf'   => 'moksha',
    'mdr'   => 'mandar',
    'men'   => "mende\ \(Sierra\ Leone\)",
    'mfe'   => 'Morisyen',
    'mg'    => 'madagassisk',
    'mga'   => 'mellomirsk',
    'mh'    => 'marshallesisk',
    'mi'    => 'maori',
    'mic'   => 'miʼkmak',
    'min'   => 'minangkabau',
    'mis'   => "\(annet\ språk\)",
    'mk'    => 'makedonsk',
    'mkh'   => "mon\-khmerspråk",
    'ml'    => 'malayalam',
    'mn'    => 'mongolsk',
    'mnc'   => 'mandsju',
    'mni'   => 'manipuri',
    'mno'   => 'manobospråk',
    'mo'    => 'moldavisk',
    'moh'   => 'mohawk',
    'mos'   => 'mossi',
    'mr'    => 'marathi',
    'ms'    => 'malayisk',
    'mt'    => 'maltesisk',
    'mul'   => "\(flere\ språk\)",
    'mun'   => 'mundaspråk',
    'mus'   => 'creek',
    'mwl'   => 'mirandesisk',
    'mwr'   => 'marwari',
    'my'    => 'burmesisk',
    'myn'   => 'mayaspråk',
    'myv'   => 'erzya',
    'na'    => 'nauru',
    'nah'   => "aztekisk\ språk",
    'nai'   => "nordamerikansk\ indiansk\ språk",
    'nap'   => 'napolitansk',
    'nb'    => "norsk\ bokmål",
    'nd'    => "nord\-ndebele",
    'nds'   => 'lavtysk',
    'ne'    => 'nepalsk',
    'new'   => 'newarisk',
    'ng'    => 'ndonga',
    'nia'   => 'nias',
    'nic'   => "niger\-kordofiansk\ språk",
    'niu'   => 'niueansk',
    'nl'    => 'nederlandsk',
    'nl_be' => 'flamsk',
    'nn'    => 'nynorsk',
    'no'    => 'norsk',
    'nog'   => 'nogai',
    'non'   => 'gammelnorsk',
    'nqo'   => "n\-kå",
    'nr'    => "sør\-ndebele",
    'nso'   => "nord\-sotho",
    'nub'   => "nubisk\ språk",
    'nv'    => 'navajo',
    'nwc'   => "klassisk\ newarisk",
    'ny'    => 'nyanja',
    'nym'   => 'nyamwezi',
    'nyn'   => 'nyankole',
    'nyo'   => 'nyoro',
    'nzi'   => 'nzima',
    'oc'    => 'oksitansk',
    'oj'    => 'ojibwa',
    'om'    => 'oromo',
    'or'    => 'oriya',
    'os'    => 'ossetisk',
    'osa'   => 'osage',
    'ota'   => 'osmansk',
    'oto'   => "otomisk\ språk",
    'pa'    => 'panjabi',
    'paa'   => "papuisk\ språk",
    'pag'   => 'pangasinan',
    'pal'   => 'middelpersisk',
    'pam'   => 'pampanga',
    'pap'   => 'papiamento',
    'pau'   => 'palauisk',
    'peo'   => 'gammelpersisk',
    'phi'   => "filippinsk\ språk",
    'phn'   => 'fønikisk',
    'pi'    => 'pali',
    'pl'    => 'polsk',
    'pon'   => 'ponapisk',
    'pra'   => 'prakritspråk',
    'pro'   => 'gammelprovençalsk',
    'ps'    => 'pashto',
    'pt'    => 'portugisisk',
    'pt_br' => "brasiliansk\ portugisisk",
    'pt_pt' => "iberisk\ portugisisk",
    'qu'    => 'quechua',
    'raj'   => 'rajasthanisk',
    'rap'   => 'rapanuisk',
    'rar'   => 'rarotongansk',
    'rm'    => 'retoromansk',
    'rn'    => 'rundisk',
    'ro'    => 'rumensk',
    'roa'   => "romansk\ språk",
    'rom'   => 'romani',
    'ru'    => 'russisk',
    'rup'   => 'arumensk',
    'rw'    => 'kinjarwanda',
    'sa'    => 'sanskrit',
    'sad'   => 'sandawe',
    'sah'   => 'jakutsk',
    'sai'   => "søramerikansk\ indiansk\ språk",
    'sal'   => "salishansk\ språk",
    'sam'   => "samaritansk\ arameisk",
    'sas'   => 'sasak',
    'sat'   => 'santalisk',
    'sc'    => 'sardisk',
    'scn'   => 'siciliansk',
    'sco'   => 'skotsk',
    'sd'    => 'sindhi',
    'se'    => 'nordsamisk',
    'sel'   => 'selkupisk',
    'sem'   => "semittisk\ språk",
    'sg'    => 'sango',
    'sga'   => 'gammelirsk',
    'sgn'   => 'tegnspråk',
    'sh'    => 'serbokroatisk',
    'shn'   => 'shan',
    'si'    => 'singalesisk',
    'sid'   => 'sidamo',
    'sio'   => 'siouxspråk',
    'sit'   => "sino\-tibetansk\ språk",
    'sk'    => 'slovakisk',
    'sl'    => 'slovensk',
    'sla'   => "slavisk\ språk",
    'sm'    => 'samoansk',
    'sma'   => 'sørsamisk',
    'smi'   => "samisk\ språk",
    'smj'   => 'lulesamisk',
    'smn'   => 'enaresamisk',
    'sms'   => 'skoltesamisk',
    'sn'    => 'shona',
    'snk'   => 'soninke',
    'so'    => 'somalisk',
    'sog'   => 'sogdisk',
    'son'   => 'songhai',
    'sq'    => 'albansk',
    'sr'    => 'serbisk',
    'srn'   => "sranan\ tongo",
    'srr'   => 'serer',
    'ss'    => 'swati',
    'ssa'   => "nilo\-saharaspråk",
    'st'    => "sør\-sotho",
    'su'    => 'sundanesisk',
    'suk'   => 'sukuma',
    'sus'   => 'susu',
    'sux'   => 'sumerisk',
    'sv'    => 'svensk',
    'sw'    => 'swahili',
    'syc'   => "klassisk\ syrisk",
    'syr'   => 'syrisk',
    'ta'    => 'tamilsk',
    'tai'   => 'taispråk',
    'te'    => 'telugu',
    'tem'   => 'temne',
    'ter'   => 'tereno',
    'tet'   => 'tetum',
    'tg'    => 'tadsjikisk',
    'th'    => 'thai',
    'ti'    => 'tigrinja',
    'tig'   => 'tigré',
    'tiv'   => 'tivi',
    'tk'    => 'turkmensk',
    'tkl'   => 'tokelau',
    'tl'    => 'tagalog',
    'tlh'   => 'klingon',
    'tli'   => 'tlingit',
    'tmh'   => 'tamasjek',
    'tn'    => 'setswana',
    'to'    => "tongansk\ \(Tongaøerne\)",
    'tog'   => "tongansk\ \(Niassa\ i\ Moçambique\)",
    'tpi'   => "tok\ pisin",
    'tr'    => 'tyrkisk',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimshian',
    'tt'    => 'tatarisk',
    'tum'   => 'tumbukisk',
    'tup'   => 'tupispråk',
    'tut'   => "altaisk\ språk",
    'tvl'   => 'tuvalu',
    'tw'    => 'twi',
    'ty'    => 'tahitisk',
    'tyv'   => 'tuvinisk',
    'udm'   => 'udmurt',
    'ug'    => 'uigurisk',
    'uga'   => 'ugaritisk',
    'uk'    => 'ukrainsk',
    'umb'   => 'umbundu',
    'und'   => "\(ukjent\ språk\)",
    'ur'    => 'urdu',
    'uz'    => 'usbekisk',
    'vai'   => 'vai',
    've'    => 'venda',
    'vi'    => 'vietnamesisk',
    'vo'    => 'volapyk',
    'vot'   => 'votisk',
    'wa'    => 'vallonsk',
    'wak'   => "wakasjansk\ språk",
    'wal'   => 'walamo',
    'war'   => "waray\ \(Filippinerne\)",
    'was'   => 'washo',
    'wen'   => "sorbisk\ språk",
    'wo'    => 'wolof',
    'xal'   => 'kalmyk',
    'xh'    => 'xhosa',
    'yao'   => 'yao',
    'yap'   => 'yapesisk',
    'yi'    => 'jiddisk',
    'yo'    => 'joruba',
    'ypk'   => "jupisk\ språk",
    'za'    => 'zhuang',
    'zap'   => 'zapotec',
    'zbl'   => "bliss\-symboler",
    'zen'   => 'zenaga',
    'zh'    => 'kinesisk',
    'znd'   => 'zande',
    'zu'    => 'zulu',
    'zun'   => 'zuni',
    'zxx'   => "\(uten\ språklig\ innhold\)",
    'zza'   => 'zazaisk',
);

%Locales::DB::Language::nb::name_to_code = (
    'abkhasisk'                               => 'ab',
    'achinesisk'                              => 'ace',
    'acoli'                                   => 'ach',
    'adangme'                                 => 'ada',
    'adyghe'                                  => 'ady',
    'afar'                                    => 'aa',
    'afrihili'                                => 'afh',
    'afrikaans'                               => 'af',
    'afroasiatiskspråk'                      => 'afa',
    'ainujapan'                               => 'ain',
    'akan'                                    => 'ak',
    'akkadisk'                                => 'akk',
    'albansk'                                 => 'sq',
    'aleutisk'                                => 'ale',
    'algonkinskspråk'                        => 'alg',
    'altaiskspråk'                           => 'tut',
    'amerikanskengelsk'                       => 'en_us',
    'amharisk'                                => 'am',
    'angika'                                  => 'anp',
    'annetspråk'                             => 'mis',
    'apachespråk'                            => 'apa',
    'arabisk'                                 => 'ar',
    'aragonsk'                                => 'an',
    'arapaho'                                 => 'arp',
    'araukansk'                               => 'arn',
    'arawak'                                  => 'arw',
    'armensk'                                 => 'hy',
    'arumensk'                                => 'rup',
    'aserbajdsjansk'                          => 'az',
    'assamesisk'                              => 'as',
    'asturisk'                                => 'ast',
    'athapaskiskspråk'                       => 'ath',
    'atsam'                                   => 'cch',
    'australskengelsk'                        => 'en_au',
    'australskspråk'                         => 'aus',
    'austronesiskspråk'                      => 'map',
    'avarisk'                                 => 'av',
    'avestisk'                                => 'ae',
    'awadhi'                                  => 'awa',
    'aymara'                                  => 'ay',
    'aztekiskspråk'                          => 'nah',
    'balinesisk'                              => 'ban',
    'baltiskspråk'                           => 'bat',
    'baluchi'                                 => 'bal',
    'bambara'                                 => 'bm',
    'bamilekiskspråk'                        => 'bai',
    'bandaspråk'                             => 'bad',
    'bantuspåk'                              => 'bnt',
    'basakamerun'                             => 'bas',
    'basjkirsk'                               => 'ba',
    'baskisk'                                 => 'eu',
    'batakspråk'                             => 'btk',
    'beja'                                    => 'bej',
    'bembazambia'                             => 'bem',
    'bengalisk'                               => 'bn',
    'berbisk'                                 => 'ber',
    'bhojpuri'                                => 'bho',
    'bhutansk'                                => 'dz',
    'bicolano'                                => 'bik',
    'bihariskspråk'                          => 'bh',
    'bini'                                    => 'bin',
    'bislama'                                 => 'bi',
    'blin'                                    => 'byn',
    'blisssymboler'                           => 'zbl',
    'bosnisk'                                 => 'bs',
    'braj'                                    => 'bra',
    'brasilianskportugisisk'                  => 'pt_br',
    'bretonsk'                                => 'br',
    'britiskengelsk'                          => 'en_gb',
    'buginesisk'                              => 'bug',
    'bulgarsk'                                => 'bg',
    'buriat'                                  => 'bua',
    'burmesisk'                               => 'my',
    'caddo'                                   => 'cad',
    'canadiskengelsk'                         => 'en_ca',
    'canadiskfransk'                          => 'fr_ca',
    'cebuansk'                                => 'ceb',
    'chagatai'                                => 'chg',
    'chamorro'                                => 'ch',
    'cherokee'                                => 'chr',
    'cheyenne'                                => 'chy',
    'chibcha'                                 => 'chb',
    'chinookpidginengelsk'                    => 'chn',
    'chipewiansk'                             => 'chp',
    'choctaw'                                 => 'cho',
    'chuukesisk'                              => 'chk',
    'cree'                                    => 'cr',
    'creek'                                   => 'mus',
    'dajakiskspråk'                          => 'day',
    'dakota'                                  => 'dak',
    'dansk'                                   => 'da',
    'dargwa'                                  => 'dar',
    'delaware'                                => 'del',
    'dinka'                                   => 'din',
    'divehi'                                  => 'dv',
    'dogrib'                                  => 'dgr',
    'dogrikangri'                             => 'doi',
    'dravidiskspråk'                         => 'dra',
    'duala'                                   => 'dua',
    'dyula'                                   => 'dyu',
    'efik'                                    => 'efi',
    'ekajuk'                                  => 'eka',
    'elamittisk'                              => 'elx',
    'enaresamisk'                             => 'smn',
    'engelsk'                                 => 'en',
    'engelskbasertkreolellerpidginspråk'     => 'cpe',
    'erzya'                                   => 'myv',
    'esperanto'                               => 'eo',
    'estisk'                                  => 'et',
    'ewe'                                     => 'ee',
    'ewondo'                                  => 'ewo',
    'fang'                                    => 'fan',
    'fanti'                                   => 'fat',
    'fijiansk'                                => 'fj',
    'filippinsk'                              => 'fil',
    'filippinskspråk'                        => 'phi',
    'finsk'                                   => 'fi',
    'finskugriskspråk'                       => 'fiu',
    'flamsk'                                  => 'nl_be',
    'flerespråk'                             => 'mul',
    'fon'                                     => 'fon',
    'fransk'                                  => 'fr',
    'franskbasertkreolellerpidginspråk'      => 'cpf',
    'friuliansk'                              => 'fur',
    'fulfulde'                                => 'ff',
    'færøysk'                               => 'fo',
    'fønikisk'                               => 'phn',
    'ga'                                      => 'gaa',
    'galibisk'                                => 'car',
    'galisisk'                                => 'gl',
    'gammelegyptisk'                          => 'egy',
    'gammelengelsk'                           => 'ang',
    'gammelfransk'                            => 'fro',
    'gammelgresk'                             => 'grc',
    'gammelhøytysk'                          => 'goh',
    'gammelirsk'                              => 'sga',
    'gammelnorsk'                             => 'non',
    'gammelpersisk'                           => 'peo',
    'gammelprovençalsk'                      => 'pro',
    'ganda'                                   => 'lg',
    'gayo'                                    => 'gay',
    'gbaya'                                   => 'gba',
    'georgisk'                                => 'ka',
    'germanskspråk'                          => 'gem',
    'ges'                                     => 'gez',
    'gondi'                                   => 'gon',
    'gorontalo'                               => 'gor',
    'gotisk'                                  => 'got',
    'grebo'                                   => 'grb',
    'gresk'                                   => 'el',
    'grønlandsk'                             => 'kl',
    'guarani'                                 => 'gn',
    'gujarati'                                => 'gu',
    'gwichin'                                 => 'gwi',
    'haida'                                   => 'hai',
    'haitisk'                                 => 'ht',
    'hausa'                                   => 'ha',
    'hawaiisk'                                => 'haw',
    'hebraisk'                                => 'he',
    'herero'                                  => 'hz',
    'hettittisk'                              => 'hit',
    'hiligaynon'                              => 'hil',
    'himachaliskspråk'                       => 'him',
    'hindi'                                   => 'hi',
    'hirimotu'                                => 'ho',
    'hmong'                                   => 'hmn',
    'hupa'                                    => 'hup',
    'hviterussisk'                            => 'be',
    'høysorbisk'                             => 'hsb',
    'iban'                                    => 'iba',
    'iberiskportugisisk'                      => 'pt_pt',
    'iberiskspansk'                           => 'es_es',
    'ibo'                                     => 'ig',
    'ido'                                     => 'io',
    'ijospråk'                               => 'ijo',
    'iloko'                                   => 'ilo',
    'indiskspråk'                            => 'inc',
    'indoeuropeiskspråk'                     => 'ine',
    'indonesisk'                              => 'id',
    'ingusjisk'                               => 'inh',
    'interlingua'                             => 'ia',
    'interlingue'                             => 'ie',
    'inuktitut'                               => 'iu',
    'inupiak'                                 => 'ik',
    'iransk'                                  => 'ira',
    'irokanskspråk'                          => 'iro',
    'irsk'                                    => 'ga',
    'islandsk'                                => 'is',
    'italiensk'                               => 'it',
    'jakutsk'                                 => 'sah',
    'japansk'                                 => 'ja',
    'javanesisk'                              => 'jv',
    'jiddisk'                                 => 'yi',
    'jju'                                     => 'kaj',
    'joruba'                                  => 'yo',
    'jupiskspråk'                            => 'ypk',
    'jødearabisk'                            => 'jrb',
    'jødepersisk'                            => 'jpr',
    'kabardisk'                               => 'kbd',
    'kabylsk'                                 => 'kab',
    'kachin'                                  => 'kac',
    'kalmyk'                                  => 'xal',
    'kambakenya'                              => 'kam',
    'kambodjansk'                             => 'km',
    'kamiskspråk'                            => 'cmc',
    'kannada'                                 => 'kn',
    'kanuri'                                  => 'kr',
    'karachaybalkar'                          => 'krc',
    'karakalpakisk'                           => 'kaa',
    'karelsk'                                 => 'krl',
    'karenskspråk'                           => 'kar',
    'kasakhisk'                               => 'kk',
    'kasjmirsk'                               => 'ks',
    'kasjubisk'                               => 'csb',
    'katalansk'                               => 'ca',
    'kaukasiskspråk'                         => 'cau',
    'kawi'                                    => 'kaw',
    'keltiskspråk'                           => 'cel',
    'khasi'                                   => 'kha',
    'khoisanspråk'                           => 'khi',
    'khotanesisk'                             => 'kho',
    'kikongo'                                 => 'kg',
    'kikuyu'                                  => 'ki',
    'kimbundu'                                => 'kmb',
    'kinesisk'                                => 'zh',
    'kinjarwanda'                             => 'rw',
    'kirgisisk'                               => 'ky',
    'kiribatisk'                              => 'gil',
    'kirkeslavisk'                            => 'cu',
    'klassiskarameisk'                        => 'arc',
    'klassisknewarisk'                        => 'nwc',
    'klassisksyrisk'                          => 'syc',
    'klingon'                                 => 'tlh',
    'komi'                                    => 'kv',
    'konkani'                                 => 'kok',
    'koptisk'                                 => 'cop',
    'koreansk'                                => 'ko',
    'kornisk'                                 => 'kw',
    'koro'                                    => 'kfo',
    'korsikansk'                              => 'co',
    'kosraeansk'                              => 'kos',
    'kpèllé'                                => 'kpe',
    'kreolellerpidginspråk'                  => 'crp',
    'krimturkisk'                             => 'crh',
    'kroatisk'                                => 'hr',
    'kruspråk'                               => 'kro',
    'kuanyama'                                => 'kj',
    'kumyk'                                   => 'kum',
    'kunstigspråk'                           => 'art',
    'kurdisk'                                 => 'ku',
    'kurukh'                                  => 'kru',
    'kusjitiskspråk'                         => 'cus',
    'kutenai'                                 => 'kut',
    'ladinsk'                                 => 'lad',
    'lahnda'                                  => 'lah',
    'lamba'                                   => 'lam',
    'laotisk'                                 => 'lo',
    'latin'                                   => 'la',
    'latvisk'                                 => 'lv',
    'lavsorbisk'                              => 'dsb',
    'lavtysk'                                 => 'nds',
    'lezghian'                                => 'lez',
    'limburgisk'                              => 'li',
    'lingala'                                 => 'ln',
    'litauisk'                                => 'lt',
    'lojban'                                  => 'jbo',
    'lozi'                                    => 'loz',
    'lubakatanga'                             => 'lu',
    'lubalulua'                               => 'lua',
    'luiseno'                                 => 'lui',
    'lulesamisk'                              => 'smj',
    'lunda'                                   => 'lun',
    'luo'                                     => 'luo',
    'lushai'                                  => 'lus',
    'luxemburgsk'                             => 'lb',
    'madagassisk'                             => 'mg',
    'maduresisk'                              => 'mad',
    'magahi'                                  => 'mag',
    'maithili'                                => 'mai',
    'makasar'                                 => 'mak',
    'makedonsk'                               => 'mk',
    'malayalam'                               => 'ml',
    'malayisk'                                => 'ms',
    'maltesisk'                               => 'mt',
    'mandar'                                  => 'mdr',
    'mandingo'                                => 'man',
    'mandsju'                                 => 'mnc',
    'manipuri'                                => 'mni',
    'manobospråk'                            => 'mno',
    'manx'                                    => 'gv',
    'maori'                                   => 'mi',
    'marathi'                                 => 'mr',
    'mariskrussland'                          => 'chm',
    'marshallesisk'                           => 'mh',
    'marwari'                                 => 'mwr',
    'masai'                                   => 'mas',
    'mayaspråk'                              => 'myn',
    'mellomengelsk'                           => 'enm',
    'mellomfransk'                            => 'frm',
    'mellomhøytysk'                          => 'gmh',
    'mellomirsk'                              => 'mga',
    'mellomnederlandsk'                       => 'dum',
    'mendesierraleone'                        => 'men',
    'middelpersisk'                           => 'pal',
    'minangkabau'                             => 'min',
    'mirandesisk'                             => 'mwl',
    'miʼkmak'                                => 'mic',
    'mohawk'                                  => 'moh',
    'moksha'                                  => 'mdf',
    'moldavisk'                               => 'mo',
    'mongo'                                   => 'lol',
    'mongolsk'                                => 'mn',
    'monkhmerspråk'                          => 'mkh',
    'morisyen'                                => 'mfe',
    'mossi'                                   => 'mos',
    'mundaspråk'                             => 'mun',
    'napolitansk'                             => 'nap',
    'nauru'                                   => 'na',
    'navajo'                                  => 'nv',
    'ndonga'                                  => 'ng',
    'nederlandsk'                             => 'nl',
    'nepalsk'                                 => 'ne',
    'newarisk'                                => 'new',
    'nias'                                    => 'nia',
    'nigerkordofianskspråk'                  => 'nic',
    'nilosaharaspråk'                        => 'ssa',
    'niueansk'                                => 'niu',
    'nkå'                                    => 'nqo',
    'nogai'                                   => 'nog',
    'nordamerikanskindianskspråk'            => 'nai',
    'nordfrisisk'                             => 'frr',
    'nordndebele'                             => 'nd',
    'nordsamisk'                              => 'se',
    'nordsotho'                               => 'nso',
    'norsk'                                   => 'no',
    'norskbokmål'                            => 'nb',
    'nubiskspråk'                            => 'nub',
    'nyamwezi'                                => 'nym',
    'nyanja'                                  => 'ny',
    'nyankole'                                => 'nyn',
    'nynorsk'                                 => 'nn',
    'nyoro'                                   => 'nyo',
    'nzima'                                   => 'nzi',
    'ojibwa'                                  => 'oj',
    'oksitansk'                               => 'oc',
    'oriya'                                   => 'or',
    'oromo'                                   => 'om',
    'osage'                                   => 'osa',
    'osmansk'                                 => 'ota',
    'ossetisk'                                => 'os',
    'otomiskspråk'                           => 'oto',
    'palauisk'                                => 'pau',
    'pali'                                    => 'pi',
    'pampanga'                                => 'pam',
    'pangasinan'                              => 'pag',
    'panjabi'                                 => 'pa',
    'papiamento'                              => 'pap',
    'papuiskspråk'                           => 'paa',
    'pashto'                                  => 'ps',
    'persisk'                                 => 'fa',
    'polsk'                                   => 'pl',
    'ponapisk'                                => 'pon',
    'portugisisk'                             => 'pt',
    'portugisiskbasertkreolellerpidginspråk' => 'cpp',
    'prakritspråk'                           => 'pra',
    'quechua'                                 => 'qu',
    'rajasthanisk'                            => 'raj',
    'rapanuisk'                               => 'rap',
    'rarotongansk'                            => 'rar',
    'retoromansk'                             => 'rm',
    'romani'                                  => 'rom',
    'romanskspråk'                           => 'roa',
    'rumensk'                                 => 'ro',
    'rundisk'                                 => 'rn',
    'russisk'                                 => 'ru',
    'salishanskspråk'                        => 'sal',
    'samaritanskarameisk'                     => 'sam',
    'samiskspråk'                            => 'smi',
    'samoansk'                                => 'sm',
    'sandawe'                                 => 'sad',
    'sango'                                   => 'sg',
    'sanskrit'                                => 'sa',
    'santalisk'                               => 'sat',
    'sardisk'                                 => 'sc',
    'sasak'                                   => 'sas',
    'selkupisk'                               => 'sel',
    'semittiskspråk'                         => 'sem',
    'sentralamerikanskindianskspråk'         => 'cai',
    'serbisk'                                 => 'sr',
    'serbokroatisk'                           => 'sh',
    'serer'                                   => 'srr',
    'setswana'                                => 'tn',
    'shan'                                    => 'shn',
    'shona'                                   => 'sn',
    'sichuanyi'                               => 'ii',
    'siciliansk'                              => 'scn',
    'sidamo'                                  => 'sid',
    'siksika'                                 => 'bla',
    'sindhi'                                  => 'sd',
    'singalesisk'                             => 'si',
    'sinotibetanskspråk'                     => 'sit',
    'siouxspråk'                             => 'sio',
    'skoltesamisk'                            => 'sms',
    'skotsk'                                  => 'sco',
    'skotskgælisk'                           => 'gd',
    'slavej'                                  => 'den',
    'slaviskspråk'                           => 'sla',
    'slovakisk'                               => 'sk',
    'slovensk'                                => 'sl',
    'sogdisk'                                 => 'sog',
    'somalisk'                                => 'so',
    'songhai'                                 => 'son',
    'soninke'                                 => 'snk',
    'sorbiskspråk'                           => 'wen',
    'spansk'                                  => 'es',
    'sranantongo'                             => 'srn',
    'sukuma'                                  => 'suk',
    'sumerisk'                                => 'sux',
    'sundanesisk'                             => 'su',
    'susu'                                    => 'sus',
    'sveitsertysk'                            => 'gsw',
    'sveitsiskfransk'                         => 'fr_ch',
    'sveitsiskhøytysk'                       => 'de_ch',
    'svensk'                                  => 'sv',
    'swahili'                                 => 'sw',
    'swati'                                   => 'ss',
    'syrisk'                                  => 'syr',
    'søraltaisk'                             => 'alt',
    'søramerikanskindianskspråk'            => 'sai',
    'sørndebele'                             => 'nr',
    'sørsamisk'                              => 'sma',
    'sørsotho'                               => 'st',
    'tadsjikisk'                              => 'tg',
    'tagalog'                                 => 'tl',
    'tahitisk'                                => 'ty',
    'taispråk'                               => 'tai',
    'tamasjek'                                => 'tmh',
    'tamilsk'                                 => 'ta',
    'taroko'                                  => 'trv',
    'tatarisk'                                => 'tt',
    'tegnspråk'                              => 'sgn',
    'telugu'                                  => 'te',
    'temne'                                   => 'tem',
    'tereno'                                  => 'ter',
    'tetum'                                   => 'tet',
    'thai'                                    => 'th',
    'tibetansk'                               => 'bo',
    'tigrinja'                                => 'ti',
    'tigré'                                  => 'tig',
    'tivi'                                    => 'tiv',
    'tlingit'                                 => 'tli',
    'tokelau'                                 => 'tkl',
    'tokpisin'                                => 'tpi',
    'tonganskniassaimoçambique'              => 'tog',
    'tongansktongaøerne'                     => 'to',
    'tsimshian'                               => 'tsi',
    'tsjekkisk'                               => 'cs',
    'tsjetsjensk'                             => 'ce',
    'tsjuvansk'                               => 'cv',
    'tsonga'                                  => 'ts',
    'tumbukisk'                               => 'tum',
    'tupispråk'                              => 'tup',
    'turkmensk'                               => 'tk',
    'tuvalu'                                  => 'tvl',
    'tuvinisk'                                => 'tyv',
    'twi'                                     => 'tw',
    'tyap'                                    => 'kcg',
    'tyrkisk'                                 => 'tr',
    'tysk'                                    => 'de',
    'udmurt'                                  => 'udm',
    'ugaritisk'                               => 'uga',
    'uigurisk'                                => 'ug',
    'ukjentspråk'                            => 'und',
    'ukrainsk'                                => 'uk',
    'umbundu'                                 => 'umb',
    'ungarsk'                                 => 'hu',
    'urdu'                                    => 'ur',
    'usbekisk'                                => 'uz',
    'utenspråkliginnhold'                    => 'zxx',
    'vai'                                     => 'vai',
    'vallonsk'                                => 'wa',
    'venda'                                   => 've',
    'vestfrisisk'                             => 'fy',
    'vietnamesisk'                            => 'vi',
    'volapyk'                                 => 'vo',
    'votisk'                                  => 'vot',
    'wakasjanskspråk'                        => 'wak',
    'walamo'                                  => 'wal',
    'walisisk'                                => 'cy',
    'warayfilippinerne'                       => 'war',
    'washo'                                   => 'was',
    'wolof'                                   => 'wo',
    'xhosa'                                   => 'xh',
    'yao'                                     => 'yao',
    'yapesisk'                                => 'yap',
    'zande'                                   => 'znd',
    'zapotec'                                 => 'zap',
    'zazaisk'                                 => 'zza',
    'zenaga'                                  => 'zen',
    'zhuang'                                  => 'za',
    'zulu'                                    => 'zu',
    'zuni'                                    => 'zun',
    'østerriksktysk'                         => 'de_at',
    'østfrisisk'                             => 'frs',
);

1;
