# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN {
    $| = 1;
    print "# MDN::API\n";
    print "1..45\n";
    use lib '..';
    require 'eucjp';
    $MDN::API::config_file = '../common/mdn.conf';
}

END {
    print "not ok 1\n" unless $loaded;
}

use MDN::API;
$loaded = 1;
print "ok 1\n";

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

MDN::API->enable(1);

$test_id = 2;

sub to_utf8 ($) {
    my $result = '';
    my ($offset, $mask, $length);

    foreach my $i (split(/[ \t\n]/, $_[0])) {
	if ($i =~ /^U\+([0-9A-Fa-f]+)$/) {
	    $ucs = hex($1);
	} elsif ($i =~ /^[\x21-\x7e]$/) {
	    $ucs = ord($i);
	} else {
	    die "invalid character, $i\n" 
	}

        if ($ucs < 0x80) {
	    $mask = 0;
	    $length = 1;
        } elsif ($ucs < 0x800) {
	    $mask = 0xc0;
	    $length = 2;
        } elsif ($ucs < 0x10000) {
	    $mask = 0xe0;
	    $length = 3;
        } elsif ($ucs < 0x200000) {
	    $mask = 0xf0;
	    $length = 4;
        } elsif ($ucs < 0x4000000) {
	    $mask = 0xf8;
	    $length = 5;
        } elsif ($ucs < 0x80000000) {
	    $mask = 0xfc;
	    $length = 6;
        } else {
	    die "unicode codepoint too big, $i\n";
        }

        $offset = 6 * ($length - 1);
	$result .= pack('C', ($ucs >> $offset) | $mask);
	$mask = 0x80;
	while ($offset > 0) {
	    $offset -= 6;
	    $result .= pack('C', (($ucs >> $offset) & 0x3f) | $mask);
	}
    }

    return $result;
}

sub to_eucjp ($) {
    my $result = $_[0];
    $result =~ s/ //g;
    return $result;
}

#####
if (!open(TESTDATA, '../common/testdata')) {
    die "failed to open the file, $!: ../common/testdata\n";
}

while (<TESTDATA>) {
    chomp;
    next if (/^\#/ || /^$/);
    ($title, $action, $incode, $inname, $expcode, $expname)
	= split(/[ \t]*:[ \t]*/, $_);

    next if ($action eq 'm' || $action eq 'n' || $action eq 'p');

    if ($incode eq 'UTF-8') {
	$inname = to_utf8($inname);
    } elsif ($incode eq 'EUC-JP') {
	$inname = to_eucjp($inname);
    }
    if ($expcode eq 'UTF-8') {
	$expname = to_utf8($expname);
    } elsif ($expcode eq 'EUC-JP') {
	$expname = to_eucjp($expname);
    }

    if ($action eq 'l') {
	$outname1 = MDN::API->encode_name($inname, 'localconv');
    } elsif ($action eq 'L') {
	$outname1 = MDN::API->decode_name($inname, 'localconv');
    } elsif ($action eq 'd') {
	$outname1 = MDN::API->encode_name($inname, 'delimmap');
    } elsif ($action eq 'M') {
	$outname1 = MDN::API->encode_name($inname, 'localmap');
    } elsif ($action eq 'N') {
	$outname1 = MDN::API->encode_name($inname, 'nameprep');
    } elsif ($action eq '!N') {
	$outname1 = MDN::API->decode_name($inname, 'nameprep');
    } elsif ($action eq 'I') {
	$outname1 = MDN::API->encode_name($inname, 'idnconv');
    } elsif ($action eq 'i') {
	$outname1 = MDN::API->decode_name($inname, 'idnconv');
    } elsif ($action eq 'ldMNI') {
	$outname1 = MDN::API->encode_name($inname);
    } elsif ($action eq 'i!NL') {
	$outname1 = MDN::API->decode_name($inname);
    } else {
	next;
    }

    print "# $title (encode_name & decode_name)\n";
    if (!defined($outname1)) {
	($outname1 = MDN::ResConf->lasterror()) =~ s/, .*$//;
    }
    print($outname1 eq $expname ? 'ok ' : 'not ok ', $test_id++, "\n");

    if ($action eq 'l') {
	$outname2 = MDN::API->local_to_utf8($inname);
    } elsif ($action eq 'L') {
	$outname2 = MDN::API->utf8_to_local($inname);
    } elsif ($action eq 'd') {
	$outname2 = MDN::API->delimiter_map($inname);
    } elsif ($action eq 'M') {
	$outname2 = MDN::API->local_map($inname);
    } elsif ($action eq 'm') {
	$outname2 = MDN::API->map($inname);
    } elsif ($action eq 'n') {
	$outname2 = MDN::API->normalize($inname);
    } elsif ($action eq 'p') {
	$outname2 = MDN::API->prohibit_check($inname);
    } elsif ($action eq 'N') {
	$outname2 = MDN::API->nameprep($inname);
    } elsif ($action eq '!N') {
	$outname2 = MDN::API->nameprep_check($inname);
    } elsif ($action eq 'I') {
	$outname2 = MDN::API->utf8_to_idn($inname);
    } elsif ($action eq 'i') {
	$outname2 = MDN::API->idn_to_utf8($inname);
    } elsif ($action eq 'ldMNI') {
	$outname2 = MDN::API->local_to_idn($inname);
    } elsif ($action eq 'i!NL') {
	$outname2 = MDN::API->idn_to_local($inname);
    } else {
	next;
    }

    print "# $title (X_to_Y)\n";
    if (!defined($outname2)) {
	($outname2 = MDN::ResConf->lasterror()) =~ s/, .*$//;
    }
    print($outname2 eq $expname ? 'ok ' : 'not ok ', $test_id++, "\n");
}

close(TESTDATA);
